/*
 * Decompiled with CFR 0.152.
 */
package diskCacheV111.util;

import java.io.ObjectStreamException;
import java.io.Serializable;

public final class RetentionPolicy
implements Serializable {
    private static final long serialVersionUID = -2206085171393244383L;
    private final String _name;
    private final int _id;
    public static final RetentionPolicy REPLICA = new RetentionPolicy("REPLICA", 2);
    public static final RetentionPolicy OUTPUT = new RetentionPolicy("OUTPUT", 1);
    public static final RetentionPolicy CUSTODIAL = new RetentionPolicy("CUSTODIAL", 0);

    private RetentionPolicy(String name, int id) {
        this._name = name;
        this._id = id;
    }

    public static RetentionPolicy[] getAllPoliciess() {
        return RetentionPolicy.getAllPolicies();
    }

    public static RetentionPolicy[] getAllPolicies() {
        return new RetentionPolicy[]{REPLICA, OUTPUT, CUSTODIAL};
    }

    public String toString() {
        return this._name;
    }

    public int getId() {
        return this._id;
    }

    public static RetentionPolicy getRetentionPolicy(String policy) throws IllegalArgumentException {
        if (policy == null || policy.equalsIgnoreCase("null")) {
            throw new NullPointerException(" null state ");
        }
        if (RetentionPolicy.REPLICA._name.equalsIgnoreCase(policy)) {
            return REPLICA;
        }
        if (RetentionPolicy.OUTPUT._name.equalsIgnoreCase(policy)) {
            return OUTPUT;
        }
        if (RetentionPolicy.CUSTODIAL._name.equalsIgnoreCase(policy)) {
            return CUSTODIAL;
        }
        try {
            int id = Integer.parseInt(policy);
            return RetentionPolicy.getRetentionPolicy(id);
        }
        catch (Exception e) {
            throw new IllegalArgumentException("Unknown Policy");
        }
    }

    public static RetentionPolicy getRetentionPolicy(int id) throws IllegalArgumentException {
        if (RetentionPolicy.REPLICA._id == id) {
            return REPLICA;
        }
        if (RetentionPolicy.OUTPUT._id == id) {
            return OUTPUT;
        }
        if (RetentionPolicy.CUSTODIAL._id == id) {
            return CUSTODIAL;
        }
        throw new IllegalArgumentException("Unknown policy Id");
    }

    public boolean equals(Object obj) {
        return obj instanceof RetentionPolicy && ((RetentionPolicy)obj).getId() == this.getId();
    }

    public int hashCode() {
        return this._name.hashCode();
    }

    public Object readResolve() throws ObjectStreamException {
        return RetentionPolicy.getRetentionPolicy(this.getId());
    }
}

