/*
 * Decompiled with CFR 0.152.
 */
package org.dcache.srm.util;

import com.google.common.base.Strings;
import java.io.FileWriter;
import java.io.IOException;
import java.net.InetAddress;
import java.sql.SQLException;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.dcache.srm.AbstractStorageElement;
import org.dcache.srm.SRM;
import org.dcache.srm.SRMAuthorization;
import org.dcache.srm.SRMUserPersistenceManager;
import org.dcache.srm.client.Transport;
import org.dcache.srm.util.Pgpass;
import org.w3c.dom.Comment;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.Text;

public class Configuration {
    public static final String ON_RESTART_FAIL_REQUEST = "fail";
    public static final String ON_RESTART_RESTORE_REQUEST = "restore";
    public static final String ON_RESTART_WAIT_FOR_UPDATE_REQUEST = "wait-update";
    private static final String XML_LABEL_TRANSPORT_CLIENT = "client_transport";
    private static final String INFINITY = "infinity";
    public static final String LS_PARAMETERS = "ls";
    public static final String PUT_PARAMETERS = "put";
    public static final String GET_PARAMETERS = "get";
    public static final String COPY_PARAMETERS = "copy";
    public static final String BRINGONLINE_PARAMETERS = "bringonline";
    public static final String RESERVE_PARAMETERS = "reserve";
    private boolean debug = false;
    private String urlcopy = "../scripts/urlcopy.sh";
    private String gsiftpclinet = "globus-url-copy";
    private boolean gsissl = true;
    private String glue_mapfile = null;
    private String webservice_path = "srm/managerv1.wsdl";
    private String webservice_protocol = "https";
    private int buffer_size = 2048;
    private int tcp_buffer_size;
    private int parallel_streams = 10;
    private String[] protocols = new String[]{"http", "dcap", "ftp", "gsiftp"};
    private int port = 8443;
    private String authzCacheLifetime = "180";
    private String srm_root = "/";
    private String proxies_directory = "../proxies";
    private int timeout = 3600;
    private String timeout_script = "../scripts/timeout.sh";
    private String srmHost;
    private final Set<String> localSrmHosts = new HashSet<String>();
    private AbstractStorageElement storage;
    private SRMAuthorization authorization;
    private SRM localSRM;
    private int getReqTQueueSize = 1000;
    private int getThreadPoolSize = 30;
    private int getMaxWaitingRequests = 1000;
    private int getReadyQueueSize = 1000;
    private int getMaxReadyJobs = 60;
    private int getMaxNumOfRetries = 10;
    private long getRetryTimeout = 60000L;
    private int getMaxRunningBySameOwner = 10;
    private long getSwitchToAsynchronousModeDelay = 0L;
    private String getRequestRestorePolicy = "wait-update";
    private int lsReqTQueueSize = 1000;
    private int lsThreadPoolSize = 30;
    private int lsMaxWaitingRequests = 1000;
    private int lsReadyQueueSize = 1000;
    private int lsMaxReadyJobs = 60;
    private int lsMaxNumOfRetries = 10;
    private long lsRetryTimeout = 60000L;
    private int lsMaxRunningBySameOwner = 10;
    private long lsSwitchToAsynchronousModeDelay = 0L;
    private String lsRequestRestorePolicy = "wait-update";
    private int bringOnlineReqTQueueSize = 1000;
    private int bringOnlineThreadPoolSize = 30;
    private int bringOnlineMaxWaitingRequests = 1000;
    private int bringOnlineReadyQueueSize = 1000;
    private int bringOnlineMaxReadyJobs = 60;
    private int bringOnlineMaxNumOfRetries = 10;
    private long bringOnlineRetryTimeout = 60000L;
    private int bringOnlineMaxRunningBySameOwner = 10;
    private long bringOnlineSwitchToAsynchronousModeDelay = 0L;
    private String bringOnlineRequestRestorePolicy = "wait-update";
    private int putReqTQueueSize = 1000;
    private int putThreadPoolSize = 30;
    private int putMaxWaitingRequests = 1000;
    private int putReadyQueueSize = 1000;
    private int putMaxReadyJobs = 60;
    private int putMaxNumOfRetries = 10;
    private long putRetryTimeout = 60000L;
    private int putMaxRunningBySameOwner = 10;
    private long putSwitchToAsynchronousModeDelay = 0L;
    private String putRequestRestorePolicy = "wait-update";
    private int copyReqTQueueSize = 1000;
    private int copyThreadPoolSize = 30;
    private int copyMaxWaitingRequests = 1000;
    private int copyMaxNumOfRetries = 10;
    private long copyRetryTimeout = 60000L;
    private int copyMaxRunningBySameOwner = 10;
    private String copyRequestRestorePolicy = "wait-update";
    private long lsLifetime = 3600000L;
    private long getLifetime = 86400000L;
    private long bringOnlineLifetime = 86400000L;
    private long putLifetime = 86400000L;
    private long copyLifetime = 86400000L;
    private long defaultSpaceLifetime = 86400000L;
    private String x509ServiceKey = "/etc/grid-security/hostkey.pem";
    private String x509ServiceCert = "/etc/grid-security/hostcert.pem";
    private String x509TrastedCACerts = "/etc/grid-security/certificates";
    private boolean useUrlcopyScript = false;
    private boolean useDcapForSrmCopy = false;
    private boolean useGsiftpForSrmCopy = true;
    private boolean useHttpForSrmCopy = true;
    private boolean useFtpForSrmCopy = true;
    private boolean recursiveDirectoryCreation = false;
    private boolean advisoryDelete = false;
    private boolean moveEntry = false;
    private boolean createDirectory = false;
    private boolean removeDirectory = false;
    private boolean removeFile = false;
    private boolean saveMemory = false;
    private String jdbcUrl;
    private String jdbcClass;
    private String jdbcUser;
    private String jdbcPass;
    private String jdbcPwdfile;
    private String nextRequestIdStorageTable = "srmnextrequestid";
    private boolean reserve_space_implicitely;
    private boolean space_reservation_strict;
    private long storage_info_update_period = TimeUnit.SECONDS.toMillis(30L);
    private String qosPluginClass = null;
    private String qosConfigFile = null;
    private String getPriorityPolicyPlugin = "DefaultJobAppraiser";
    private String bringOnlinePriorityPolicyPlugin = "DefaultJobAppraiser";
    private String putPriorityPolicyPlugin = "DefaultJobAppraiser";
    private String copyPriorityPolicyPlugin = "DefaultJobAppraiser";
    private String lsPriorityPolicyPlugin = "DefaultJobAppraiser";
    private Integer maxQueuedJdbcTasksNum;
    private Integer jdbcExecutionThreadNum;
    private String credentialsDirectory = "/opt/d-cache/credentials";
    private boolean overwrite = false;
    private boolean overwrite_by_default = false;
    private int sizeOfSingleRemoveBatch = 100;
    private SRMUserPersistenceManager srmUserPersistenceManager;
    private int maxNumberOfLsEntries = 1000;
    private int maxNumberOfLsLevels = 100;
    private boolean clientDNSLookup = false;
    private String counterRrdDirectory = null;
    private String gaugeRrdDirectory = null;
    private String srmCounterRrdDirectory = null;
    private String srmGaugeRrdDirectory = null;
    private String clientTransport = Transport.GSI.name();
    private Map<String, DatabaseParameters> databaseParameters = new HashMap<String, DatabaseParameters>();

    public Configuration() {
        this.databaseParameters.put(PUT_PARAMETERS, new DatabaseParameters("Put"));
        this.databaseParameters.put(GET_PARAMETERS, new DatabaseParameters("Get"));
        this.databaseParameters.put(LS_PARAMETERS, new DatabaseParameters("Ls"));
        this.databaseParameters.put(COPY_PARAMETERS, new DatabaseParameters("Copy"));
        this.databaseParameters.put(BRINGONLINE_PARAMETERS, new DatabaseParameters("Bring Online"));
        this.databaseParameters.put(RESERVE_PARAMETERS, new DatabaseParameters("Reserve Space"));
    }

    public Configuration(String configuration_file) throws Exception {
        if (configuration_file != null && !configuration_file.isEmpty()) {
            this.read(configuration_file);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void read(String file) throws Exception {
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        DocumentBuilder builder = factory.newDocumentBuilder();
        Document document = builder.parse(file);
        Node root = document.getFirstChild();
        while (root != null && !"srm-configuration".equals(root.getNodeName())) {
            root = document.getNextSibling();
        }
        if (root == null) {
            System.err.println(" error, root element \"srm-configuration\" is not found");
            throw new IOException();
        }
        if (root != null && root.getNodeName().equals("srm-configuration")) {
            for (Node node = root.getFirstChild(); node != null; node = node.getNextSibling()) {
                if (node.getNodeType() != 1) continue;
                Node child = node.getFirstChild();
                while (child != null && child.getNodeType() != 3) {
                    child = node.getNextSibling();
                }
                if (child == null) continue;
                Text t = (Text)child;
                String node_name = node.getNodeName();
                String text_value = t.getData().trim();
                if (text_value != null && text_value.equalsIgnoreCase("null")) {
                    text_value = null;
                }
                this.set(node_name.trim(), text_value);
            }
        }
        Set<String> set = this.localSrmHosts;
        synchronized (set) {
            try {
                this.localSrmHosts.add(InetAddress.getLocalHost().getCanonicalHostName());
            }
            catch (IOException ioe) {
                this.localSrmHosts.add("localhost");
            }
        }
    }

    protected static void put(Document document, Node root, String elem_name, String value, String comment_str) {
        Text t = document.createTextNode("\n\n\t");
        root.appendChild(t);
        Comment comment = document.createComment(comment_str);
        root.appendChild(comment);
        t = document.createTextNode("\n\t");
        root.appendChild(t);
        Element element = document.createElement(elem_name);
        t = document.createTextNode(" " + value + " ");
        element.appendChild(t);
        root.appendChild(element);
    }

    public void write(String file) throws Exception {
        DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
        DocumentBuilder db = dbf.newDocumentBuilder();
        Document document = db.newDocument();
        Element root = document.createElement("srm-configuration");
        this.write(document, root);
        Text t = document.createTextNode("\n");
        root.appendChild(t);
        document.appendChild(root);
        TransformerFactory tFactory = TransformerFactory.newInstance();
        Transformer transformer = tFactory.newTransformer();
        DOMSource source = new DOMSource(document);
        StreamResult result = new StreamResult(new FileWriter(file));
        transformer.transform(source, result);
    }

    protected void write(Document document, Element root) {
        Configuration.put(document, root, "debug", new Boolean(this.debug).toString(), " true or false");
        Configuration.put(document, root, "urlcopy", this.urlcopy, " path to the urlcopy script ");
        Configuration.put(document, root, "gsiftpclient", this.gsiftpclinet, " \"globus-url-copy\" or \"kftp\"");
        Configuration.put(document, root, "gsissl", new Boolean(this.gsissl).toString(), "true if use http over gsi over ssl for SOAP invocations \n\tor false to use plain http (no authentication or encryption)");
        Configuration.put(document, root, "mapfile", this.glue_mapfile, " path to the \"glue\" mapfile");
        Configuration.put(document, root, "webservice_path", this.webservice_path, " path to the  in the srm webservices server,\n\tsrm/managerv1.wsdl\" in case of srm in dcache");
        Configuration.put(document, root, "webservice_protocol", this.webservice_protocol, " this could be http or https");
        Configuration.put(document, root, "buffer_size", Integer.toString(this.buffer_size), "nonnegative integer, 2048 by default");
        Configuration.put(document, root, "tcp_buffer_size", Integer.toString(this.tcp_buffer_size), "integer, 0 by default (which means do not set tcp_buffer_size at all)");
        Configuration.put(document, root, "port", Integer.toString(this.port), "port on which to publish the srm service");
        Configuration.put(document, root, "srmAuthzCacheLifetime", this.authzCacheLifetime, "time in seconds to cache authorizations ");
        Configuration.put(document, root, "srm_root", this.srm_root, "root of the srm within the file system, nothing outside the root is accessible to the users");
        Configuration.put(document, root, "proxies_directory", this.proxies_directory, "directory where deligated credentials will be temporarily stored, if external client is to be utilized");
        Configuration.put(document, root, "timeout", Integer.toString(this.timeout), "timeout in seconds, how long to wait for the completeon of the transfer via external client, should the external client be used for the MSS to MSS transfers");
        Configuration.put(document, root, "timeout_script", this.timeout_script, "location of the timeout script");
        Configuration.put(document, root, "getReqTQueueSize", Integer.toString(this.getReqTQueueSize), "getReqTQueueSize");
        Configuration.put(document, root, "getThreadPoolSize", Integer.toString(this.getThreadPoolSize), "getThreadPoolSize");
        Configuration.put(document, root, "getMaxWaitingRequests", Integer.toString(this.getMaxWaitingRequests), "getMaxWaitingRequests");
        Configuration.put(document, root, "getReadyQueueSize", Integer.toString(this.getReadyQueueSize), "getReadyQueueSize");
        Configuration.put(document, root, "getMaxReadyJobs", Integer.toString(this.getMaxReadyJobs), "getMaxReadyJobs");
        Configuration.put(document, root, "getMaxNumOfRetries", Integer.toString(this.getMaxNumOfRetries), "Maximum Number Of Retries for get file request");
        Configuration.put(document, root, "getRetryTimeout", Long.toString(this.getRetryTimeout), "get request Retry Timeout in milliseconds");
        Configuration.put(document, root, "getMaxRunningBySameOwner", Integer.toString(this.getMaxRunningBySameOwner), "getMaxRunningBySameOwner");
        Configuration.put(document, root, "getRequestRestorePolicy", this.getRequestRestorePolicy, "getRequestRestorePolicy determines what happens with the pending/runnig get request\n       request, when srm is restarted, the possble values are:\n       \"fail\", \"restore\" and \"wait-update\\n       \"fail\"  will lead to the failure of the restored get requests\n       \"restore\" - will cause the execution of the restored get requests\n       \"wait-update\" - will cause the system not to execute the restored requests\n                         unless srmcp client attempts to update the status of the request");
        Configuration.put(document, root, "bringOnlineReqTQueueSize", Integer.toString(this.bringOnlineReqTQueueSize), "bringOnlineReqTQueueSize");
        Configuration.put(document, root, "bringOnlineThreadPoolSize", Integer.toString(this.bringOnlineThreadPoolSize), "bringOnlineThreadPoolSize");
        Configuration.put(document, root, "bringOnlineMaxWaitingRequests", Integer.toString(this.bringOnlineMaxWaitingRequests), "bringOnlineMaxWaitingRequests");
        Configuration.put(document, root, "bringOnlineReadyQueueSize", Integer.toString(this.bringOnlineReadyQueueSize), "bringOnlineReadyQueueSize");
        Configuration.put(document, root, "bringOnlineMaxReadyJobs", Integer.toString(this.bringOnlineMaxReadyJobs), "bringOnlineMaxReadyJobs");
        Configuration.put(document, root, "bringOnlineMaxNumOfRetries", Integer.toString(this.bringOnlineMaxNumOfRetries), "Maximum Number Of Retries for bringOnline file request");
        Configuration.put(document, root, "bringOnlineRetryTimeout", Long.toString(this.bringOnlineRetryTimeout), "bringOnline request Retry Timeout in milliseconds");
        Configuration.put(document, root, "bringOnlineMaxRunningBySameOwner", Integer.toString(this.bringOnlineMaxRunningBySameOwner), "bringOnlineMaxRunningBySameOwner");
        Configuration.put(document, root, "bringOnlineRequestRestorePolicy", this.bringOnlineRequestRestorePolicy, "bringOnlineRequestRestorePolicy determines what happens with the pending/runnig bringOnline request\n       request, when srm is restarted, the possble values are:\n       \"fail\", \"restore\" and \"wait-update\\n       \"fail\"  will lead to the failure of the restored bringOnline requests\n       \"restore\" - will cause the execution of the restored bringOnline requests\n       \"wait-update\" - will cause the system not to execute the restored requests\n                         unless srmcp client attempts to update the status of the request");
        Configuration.put(document, root, "lsReqTQueueSize", Integer.toString(this.lsReqTQueueSize), "lsReqTQueueSize");
        Configuration.put(document, root, "lsThreadPoolSize", Integer.toString(this.lsThreadPoolSize), "lsThreadPoolSize");
        Configuration.put(document, root, "lsMaxWaitingRequests", Integer.toString(this.lsMaxWaitingRequests), "lsMaxWaitingRequests");
        Configuration.put(document, root, "lsReadyQueueSize", Integer.toString(this.lsReadyQueueSize), "lsReadyQueueSize");
        Configuration.put(document, root, "lsMaxReadyJobs", Integer.toString(this.lsMaxReadyJobs), "lsMaxReadyJobs");
        Configuration.put(document, root, "lsMaxNumOfRetries", Integer.toString(this.lsMaxNumOfRetries), "Maximum Number Of Retries for ls file request");
        Configuration.put(document, root, "lsRetryTimeout", Long.toString(this.lsRetryTimeout), "ls request Retry Timeout in milliseconds");
        Configuration.put(document, root, "lsMaxRunningBySameOwner", Integer.toString(this.lsMaxRunningBySameOwner), "lsMaxRunningBySameOwner");
        Configuration.put(document, root, "lsRequestRestorePolicy", this.lsRequestRestorePolicy, "lsRequestRestorePolicy determines what happens with the pending/runnig ls request\n       request, when srm is restarted, the possble values are:\n       \"fail\", \"restore\" and \"wait-update\\n       \"fail\"  will lead to the failure of the restored ls requests\n       \"restore\" - will cause the execution of the restored ls requests\n       \"wait-update\" - will cause the system not to execute the restored requests\n                         unless srmcp client attempts to update the status of the request");
        Configuration.put(document, root, "putReqTQueueSize", Integer.toString(this.putReqTQueueSize), "putReqTQueueSize");
        Configuration.put(document, root, "putThreadPoolSize", Integer.toString(this.putThreadPoolSize), "putThreadPoolSize");
        Configuration.put(document, root, "putMaxWaitingRequests", Integer.toString(this.putMaxWaitingRequests), "putMaxWaitingRequests");
        Configuration.put(document, root, "putReadyQueueSize", Integer.toString(this.putReadyQueueSize), "putReadyQueueSize");
        Configuration.put(document, root, "putMaxReadyJobs", Integer.toString(this.putMaxReadyJobs), "putMaxReadyJobs");
        Configuration.put(document, root, "putMaxNumOfRetries", Integer.toString(this.putMaxNumOfRetries), "Maximum Number Of Retries for put file request");
        Configuration.put(document, root, "putRetryTimeout", Long.toString(this.putRetryTimeout), "put request Retry Timeout in milliseconds");
        Configuration.put(document, root, "putMaxRunningBySameOwner", Integer.toString(this.putMaxRunningBySameOwner), "putMaxRunningBySameOwner");
        Configuration.put(document, root, "putRequestRestorePolicy", this.putRequestRestorePolicy, "putRequestRestorePolicy determines what happens with the pending/runnig put request\n       request, when srm is restarted, the possble values are:\n       \"fail\", \"restore\" and \"wait-update\\n       \"fail\"  will lead to the failure of the restored put requests\n       \"restore\" - will cause the execution of the restored put requests\n       \"wait-update\" - will cause the system not to execute the restored requests\n                         unless srmcp client attempts to update the status of the request");
        Configuration.put(document, root, "copyReqTQueueSize", Integer.toString(this.copyReqTQueueSize), "copyReqTQueueSize");
        Configuration.put(document, root, "copyThreadPoolSize", Integer.toString(this.copyThreadPoolSize), "copyThreadPoolSize");
        Configuration.put(document, root, "copyMaxWaitingRequests", Integer.toString(this.copyMaxWaitingRequests), "copyMaxWaitingRequests");
        Configuration.put(document, root, "copyMaxNumOfRetries", Integer.toString(this.copyMaxNumOfRetries), "Maximum Number Of Retries for copy file request");
        Configuration.put(document, root, "copyRetryTimeout", Long.toString(this.copyRetryTimeout), "copy request Retry Timeout in milliseconds");
        Configuration.put(document, root, "copyMaxRunningBySameOwner", Integer.toString(this.copyMaxRunningBySameOwner), "copyMaxRunningBySameOwner");
        Configuration.put(document, root, "copyRequestRestorePolicy", this.copyRequestRestorePolicy, "copyRequestRestorePolicy determines what happens with the pending/runnig copy request\n       request, when srm is restarted, the possble values are:\n       \"fail\", \"restore\" and \"wait-update\\n       \"fail\"  will lead to the failure of the restored copy requests\n       \"restore\" - will cause the execution of the restored copy requests\n       \"wait-update\" - will cause the system not to execute the restored requests\n                         unless srmcp client attempts to update the status of the request");
        Configuration.put(document, root, "getLifetime", Long.toString(this.getLifetime), "getLifetime");
        Configuration.put(document, root, "bringOnlineLifetime", Long.toString(this.bringOnlineLifetime), "bringOnlineLifetime");
        Configuration.put(document, root, "lsLifetime", Long.toString(this.lsLifetime), "lsLifetime");
        Configuration.put(document, root, "putLifetime", Long.toString(this.putLifetime), "putLifetime");
        Configuration.put(document, root, "copyLifetime", Long.toString(this.copyLifetime), "copyLifetime");
        Configuration.put(document, root, "defaultSpaceLifetime", Long.toString(this.defaultSpaceLifetime), "defaultSpaceLifetime");
        Configuration.put(document, root, "x509ServiceKey", this.x509ServiceKey, "x509ServiceKey");
        Configuration.put(document, root, "x509ServiceCert", this.x509ServiceCert, "x509ServiceCert");
        Configuration.put(document, root, "x509TrastedCACerts", this.x509TrastedCACerts, "x509TrastedCACerts");
        Configuration.put(document, root, "useUrlcopyScript", new Boolean(this.useUrlcopyScript).toString(), "useUrlcopyScript");
        Configuration.put(document, root, "useDcapForSrmCopy", new Boolean(this.useDcapForSrmCopy).toString(), "useDcapForSrmCopy");
        Configuration.put(document, root, "useGsiftpForSrmCopy", new Boolean(this.useGsiftpForSrmCopy).toString(), "useGsiftpForSrmCopy");
        Configuration.put(document, root, "useHttpForSrmCopy", new Boolean(this.useHttpForSrmCopy).toString(), "useHttpForSrmCopy");
        Configuration.put(document, root, "useFtpForSrmCopy", new Boolean(this.useFtpForSrmCopy).toString(), "useFtpForSrmCopy");
        Configuration.put(document, root, "recursiveDirectoryCreation", new Boolean(this.recursiveDirectoryCreation).toString(), "recursiveDirectoryCreation");
        Configuration.put(document, root, "advisoryDelete", new Boolean(this.advisoryDelete).toString(), "advisoryDelete");
        Configuration.put(document, root, "removeFile", new Boolean(this.removeFile).toString(), "removeFile");
        Configuration.put(document, root, "removeDirectory", new Boolean(this.removeDirectory).toString(), "removeDirectory");
        Configuration.put(document, root, "createDirectory", new Boolean(this.createDirectory).toString(), "createDirectory");
        Configuration.put(document, root, "createDirectory", new Boolean(this.moveEntry).toString(), "moveEntry");
        Configuration.put(document, root, "saveMemory", new Boolean(this.saveMemory).toString(), "saveMemory");
        Configuration.put(document, root, "jdbcUrl", this.jdbcUrl, "jdbcUrl");
        Configuration.put(document, root, "jdbcClass", this.jdbcClass, "jdbcClass");
        Configuration.put(document, root, "jdbcUser", this.jdbcUser, "jdbcUser");
        Configuration.put(document, root, "jdbcPass", this.jdbcPass, "jdbcPass");
        Configuration.put(document, root, "jdbcPwdfile", this.jdbcPwdfile, "jdbcPwdfile");
        Configuration.put(document, root, "nextRequestIdStorageTable", this.nextRequestIdStorageTable, "nextRequestIdStorageTable");
        Configuration.put(document, root, "reserve_space_implicitely", new Boolean(this.reserve_space_implicitely).toString(), " true or false");
        Configuration.put(document, root, "space_reservation_strict", new Boolean(this.space_reservation_strict).toString(), " true or false");
        Configuration.put(document, root, "storage_info_update_period", Long.toString(this.storage_info_update_period), "storage_info_update_period in milliseconds");
        Configuration.put(document, root, XML_LABEL_TRANSPORT_CLIENT, this.clientTransport, "transport to use when connecting to other SRM instances");
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected void set(String name, String value) {
        if (name.equals("debug")) {
            this.debug = Boolean.valueOf(value);
            return;
        } else if (name.equals("gsissl")) {
            this.gsissl = Boolean.valueOf(value);
            return;
        } else if (name.equals("gsiftpclient")) {
            this.gsiftpclinet = value;
            return;
        } else if (name.equals("mapfile")) {
            this.glue_mapfile = value;
            return;
        } else if (name.equals("webservice_path")) {
            this.webservice_path = value;
            return;
        } else if (name.equals("webservice_protocol")) {
            this.webservice_protocol = value;
            return;
        } else if (name.equals("urlcopy")) {
            this.urlcopy = value;
            return;
        } else if (name.equals("buffer_size")) {
            this.buffer_size = Integer.parseInt(value);
            return;
        } else if (name.equals("tcp_buffer_size")) {
            this.tcp_buffer_size = Integer.parseInt(value);
            return;
        } else if (name.equals("port")) {
            this.port = Integer.parseInt(value);
            return;
        } else if (name.equals("srmAuthzCacheLifetime")) {
            this.authzCacheLifetime = value;
            return;
        } else if (name.equals("srm_root")) {
            this.srm_root = value;
            return;
        } else if (name.equals("proxies_directory")) {
            this.proxies_directory = value;
            return;
        } else if (name.equals("timeout")) {
            this.timeout = Integer.parseInt(value);
            return;
        } else if (name.equals("timeout_script")) {
            this.timeout_script = value;
            return;
        } else if (name.equals("getReqTQueueSize")) {
            this.getReqTQueueSize = Integer.parseInt(value);
            return;
        } else if (name.equals("getThreadPoolSize")) {
            this.getThreadPoolSize = Integer.parseInt(value);
            return;
        } else if (name.equals("getMaxWaitingRequests")) {
            this.getMaxWaitingRequests = Integer.parseInt(value);
            return;
        } else if (name.equals("getReadyQueueSize")) {
            this.getReadyQueueSize = Integer.parseInt(value);
            return;
        } else if (name.equals("getMaxReadyJobs")) {
            this.getMaxReadyJobs = Integer.parseInt(value);
            return;
        } else if (name.equals("getMaxNumOfRetries")) {
            this.getMaxNumOfRetries = Integer.parseInt(value);
            return;
        } else if (name.equals("getRetryTimeout")) {
            this.getRetryTimeout = Long.parseLong(value);
            return;
        } else if (name.equals("getMaxRunningBySameOwner")) {
            this.getMaxRunningBySameOwner = Integer.parseInt(value);
            return;
        } else if (name.equals("getRequestRestorePolicy")) {
            if (!value.equalsIgnoreCase(ON_RESTART_FAIL_REQUEST) && !value.equalsIgnoreCase(ON_RESTART_RESTORE_REQUEST) && !value.equalsIgnoreCase(ON_RESTART_RESTORE_REQUEST)) throw new IllegalArgumentException("getRequestRestorePolicy value must be one of \"fail\", \"restore\" or \"wait-update\"  but received value=" + value);
            this.getRequestRestorePolicy = value;
            return;
        } else if (name.equals("bringOnlineReqTQueueSize")) {
            this.bringOnlineReqTQueueSize = Integer.parseInt(value);
            return;
        } else if (name.equals("bringOnlineThreadPoolSize")) {
            this.bringOnlineThreadPoolSize = Integer.parseInt(value);
            return;
        } else if (name.equals("bringOnlineMaxWaitingRequests")) {
            this.bringOnlineMaxWaitingRequests = Integer.parseInt(value);
            return;
        } else if (name.equals("bringOnlineReadyQueueSize")) {
            this.bringOnlineReadyQueueSize = Integer.parseInt(value);
            return;
        } else if (name.equals("bringOnlineMaxReadyJobs")) {
            this.bringOnlineMaxReadyJobs = Integer.parseInt(value);
            return;
        } else if (name.equals("bringOnlineMaxNumOfRetries")) {
            this.bringOnlineMaxNumOfRetries = Integer.parseInt(value);
            return;
        } else if (name.equals("bringOnlineRetryTimeout")) {
            this.bringOnlineRetryTimeout = Long.parseLong(value);
            return;
        } else if (name.equals("bringOnlineMaxRunningBySameOwner")) {
            this.bringOnlineMaxRunningBySameOwner = Integer.parseInt(value);
            return;
        } else if (name.equals("bringOnlineRequestRestorePolicy")) {
            if (!value.equalsIgnoreCase(ON_RESTART_FAIL_REQUEST) && !value.equalsIgnoreCase(ON_RESTART_RESTORE_REQUEST) && !value.equalsIgnoreCase(ON_RESTART_RESTORE_REQUEST)) throw new IllegalArgumentException("bringOnlineRequestRestorePolicy value must be one of \"fail\", \"restore\" or \"wait-update\"  but received value=" + value);
            this.bringOnlineRequestRestorePolicy = value;
            return;
        } else if (name.equals("lsReqTQueueSize")) {
            this.lsReqTQueueSize = Integer.parseInt(value);
            return;
        } else if (name.equals("lsThreadPoolSize")) {
            this.lsThreadPoolSize = Integer.parseInt(value);
            return;
        } else if (name.equals("lsMaxWaitingRequests")) {
            this.lsMaxWaitingRequests = Integer.parseInt(value);
            return;
        } else if (name.equals("lsReadyQueueSize")) {
            this.lsReadyQueueSize = Integer.parseInt(value);
            return;
        } else if (name.equals("lsMaxReadyJobs")) {
            this.lsMaxReadyJobs = Integer.parseInt(value);
            return;
        } else if (name.equals("lsMaxNumOfRetries")) {
            this.lsMaxNumOfRetries = Integer.parseInt(value);
            return;
        } else if (name.equals("lsRetryTimeout")) {
            this.lsRetryTimeout = Long.parseLong(value);
            return;
        } else if (name.equals("lsMaxRunningBySameOwner")) {
            this.lsMaxRunningBySameOwner = Integer.parseInt(value);
            return;
        } else if (name.equals("lsRequestRestorePolicy")) {
            if (!value.equalsIgnoreCase(ON_RESTART_FAIL_REQUEST) && !value.equalsIgnoreCase(ON_RESTART_RESTORE_REQUEST) && !value.equalsIgnoreCase(ON_RESTART_RESTORE_REQUEST)) throw new IllegalArgumentException("lsRequestRestorePolicy value must be one of \"fail\", \"restore\" or \"wait-update\"  but received value=" + value);
            this.lsRequestRestorePolicy = value;
            return;
        } else if (name.equals("putReqTQueueSize")) {
            this.putReqTQueueSize = Integer.parseInt(value);
            return;
        } else if (name.equals("putThreadPoolSize")) {
            this.putThreadPoolSize = Integer.parseInt(value);
            return;
        } else if (name.equals("putMaxWaitingRequests")) {
            this.putMaxWaitingRequests = Integer.parseInt(value);
            return;
        } else if (name.equals("putReadyQueueSize")) {
            this.putReadyQueueSize = Integer.parseInt(value);
            return;
        } else if (name.equals("putMaxReadyJobs")) {
            this.putMaxReadyJobs = Integer.parseInt(value);
            return;
        } else if (name.equals("putMaxNumOfRetries")) {
            this.putMaxNumOfRetries = Integer.parseInt(value);
            return;
        } else if (name.equals("putRetryTimeout")) {
            this.putRetryTimeout = Long.parseLong(value);
            return;
        } else if (name.equals("putMaxRunningBySameOwner")) {
            this.putMaxRunningBySameOwner = Integer.parseInt(value);
            return;
        } else if (name.equals("putRequestRestorePolicy")) {
            if (!value.equalsIgnoreCase(ON_RESTART_FAIL_REQUEST) && !value.equalsIgnoreCase(ON_RESTART_RESTORE_REQUEST) && !value.equalsIgnoreCase(ON_RESTART_RESTORE_REQUEST)) throw new IllegalArgumentException("putRequestRestorePolicy value must be one of \"fail\", \"restore\" or \"wait-update\"  but received value=" + value);
            this.putRequestRestorePolicy = value;
            return;
        } else if (name.equals("copyReqTQueueSize")) {
            this.copyReqTQueueSize = Integer.parseInt(value);
            return;
        } else if (name.equals("copyThreadPoolSize")) {
            this.copyThreadPoolSize = Integer.parseInt(value);
            return;
        } else if (name.equals("copyMaxWaitingRequests")) {
            this.copyMaxWaitingRequests = Integer.parseInt(value);
            return;
        } else if (name.equals("copyMaxNumOfRetries")) {
            this.copyMaxNumOfRetries = Integer.parseInt(value);
            return;
        } else if (name.equals("copyRetryTimeout")) {
            this.copyRetryTimeout = Long.parseLong(value);
            return;
        } else if (name.equals("copyMaxRunningBySameOwner")) {
            this.copyMaxRunningBySameOwner = Integer.parseInt(value);
            return;
        } else if (name.equals("copyRequestRestorePolicy")) {
            if (!value.equalsIgnoreCase(ON_RESTART_FAIL_REQUEST) && !value.equalsIgnoreCase(ON_RESTART_RESTORE_REQUEST) && !value.equalsIgnoreCase(ON_RESTART_RESTORE_REQUEST)) throw new IllegalArgumentException("copyRequestRestorePolicy value must be one of \"fail\", \"restore\" or \"wait-update\"  but received value=" + value);
            this.copyRequestRestorePolicy = value;
            return;
        } else if (name.equals("getLifetime")) {
            this.getLifetime = Long.parseLong(value);
            return;
        } else if (name.equals("bringOnlineLifetime")) {
            this.bringOnlineLifetime = Long.parseLong(value);
            return;
        } else if (name.equals("lsLifetime")) {
            this.lsLifetime = Long.parseLong(value);
            return;
        } else if (name.equals("putLifetime")) {
            this.putLifetime = Long.parseLong(value);
            return;
        } else if (name.equals("copyLifetime")) {
            this.copyLifetime = Long.parseLong(value);
            return;
        } else if (name.equals("defaultSpaceLifetime")) {
            this.defaultSpaceLifetime = Long.parseLong(value);
            return;
        } else if (name.equals("x509ServiceKey")) {
            this.x509ServiceKey = value;
            return;
        } else if (name.equals("x509ServiceCert")) {
            this.x509ServiceCert = value;
            return;
        } else if (name.equals("x509TrastedCACerts")) {
            this.x509TrastedCACerts = value;
            return;
        } else if (name.equals("useUrlcopyScript")) {
            this.useUrlcopyScript = Boolean.valueOf(value);
            return;
        } else if (name.equals("useDcapForSrmCopy")) {
            this.useDcapForSrmCopy = Boolean.valueOf(value);
            return;
        } else if (name.equals("useGsiftpForSrmCopy")) {
            this.useGsiftpForSrmCopy = Boolean.valueOf(value);
            return;
        } else if (name.equals("useHttpForSrmCopy")) {
            this.useHttpForSrmCopy = Boolean.valueOf(value);
            return;
        } else if (name.equals("useFtpForSrmCopy")) {
            this.useFtpForSrmCopy = Boolean.valueOf(value);
            return;
        } else if (name.equals("recursiveDirectoryCreation")) {
            this.recursiveDirectoryCreation = Boolean.valueOf(value);
            return;
        } else if (name.equals("advisoryDelete")) {
            this.advisoryDelete = Boolean.valueOf(value);
            return;
        } else if (name.equals("removeFile")) {
            this.removeFile = Boolean.valueOf(value);
            return;
        } else if (name.equals("removeDirectory")) {
            this.removeDirectory = Boolean.valueOf(value);
            return;
        } else if (name.equals("createDirectory")) {
            this.createDirectory = Boolean.valueOf(value);
            return;
        } else if (name.equals("moveEntry")) {
            this.moveEntry = Boolean.valueOf(value);
            return;
        } else if (name.equals("saveMemory")) {
            this.saveMemory = Boolean.valueOf(value);
            return;
        } else if (name.equals("jdbcUrl")) {
            this.jdbcUrl = value;
            return;
        } else if (name.equals("jdbcClass")) {
            this.jdbcClass = value;
            return;
        } else if (name.equals("jdbcUser")) {
            this.jdbcUser = value;
            return;
        } else if (name.equals("jdbcPass")) {
            this.jdbcPass = value;
            return;
        } else if (name.equals("jdbcPwdfile")) {
            this.jdbcPwdfile = value;
            return;
        } else if (name.equals("nextRequestIdStorageTable")) {
            this.nextRequestIdStorageTable = value;
            return;
        } else if (name.equals("reserve_space_implicitely")) {
            this.reserve_space_implicitely = Boolean.valueOf(value);
            return;
        } else if (name.equals("space_reservation_strict")) {
            this.space_reservation_strict = Boolean.valueOf(value);
            return;
        } else if (name.equals("storage_info_update_period")) {
            this.storage_info_update_period = Long.parseLong(value);
            return;
        } else if (name.equals("qosPluginClass")) {
            this.qosPluginClass = value;
            return;
        } else if (name.equals("qosConfigFile")) {
            this.qosConfigFile = value;
            return;
        } else {
            if (!name.equals(XML_LABEL_TRANSPORT_CLIENT)) return;
            this.clientTransport = Transport.transportFor(value).name();
        }
    }

    public String getUrlcopy() {
        return this.urlcopy;
    }

    public void setUrlcopy(String urlcopy) {
        this.urlcopy = urlcopy;
    }

    public String getGsiftpclinet() {
        return this.gsiftpclinet;
    }

    public void setGsiftpclinet(String gsiftpclinet) {
        this.gsiftpclinet = gsiftpclinet;
    }

    public boolean isGsissl() {
        return this.gsissl;
    }

    public void setGsissl(boolean gsissl) {
        this.gsissl = gsissl;
    }

    public String getGlue_mapfile() {
        return this.glue_mapfile;
    }

    public void setGlue_mapfile(String glue_mapfile) {
        this.glue_mapfile = glue_mapfile;
    }

    public String getWebservice_path() {
        return this.webservice_path;
    }

    public void setWebservice_path(String webservice_path) {
        this.webservice_path = webservice_path;
    }

    public boolean isDebug() {
        return this.debug;
    }

    public void setDebug(boolean debug) {
        this.debug = debug;
    }

    public String getwebservice_protocol() {
        return this.webservice_protocol;
    }

    public void setwebservice_protocol(String webservice_protocol) {
        this.webservice_protocol = webservice_protocol;
    }

    public int getBuffer_size() {
        return this.buffer_size;
    }

    public void setBuffer_size(int buffer_size) {
        this.buffer_size = buffer_size;
    }

    public int getTcp_buffer_size() {
        return this.tcp_buffer_size;
    }

    public void setTcp_buffer_size(int tcp_buffer_size) {
        this.tcp_buffer_size = tcp_buffer_size;
    }

    public String getWebservice_protocol() {
        return this.webservice_protocol;
    }

    public void setWebservice_protocol(String webservice_protocol) {
        this.webservice_protocol = webservice_protocol;
    }

    public String[] getProtocols() {
        return this.protocols;
    }

    public void setProtocols(String[] protocols) {
        this.protocols = protocols;
    }

    public int getPort() {
        return this.port;
    }

    public void setPort(int port) {
        this.port = port;
    }

    public String getAuthzCacheLifetime() {
        return this.authzCacheLifetime;
    }

    public void setAuthzCacheLifetime(String authzCacheLifetime) {
        this.authzCacheLifetime = authzCacheLifetime;
    }

    public void setSrm_root(String srm_root) {
        this.srm_root = srm_root;
    }

    public String getSrm_root() {
        return this.srm_root;
    }

    public String getProxies_directory() {
        return this.proxies_directory;
    }

    public void setProxies_directory(String proxies_directory) {
        this.proxies_directory = proxies_directory;
    }

    public int getTimeout() {
        return this.timeout;
    }

    public void setTimeout(int timeout) {
        this.timeout = timeout;
    }

    public String getTimeout_script() {
        return this.timeout_script;
    }

    public void setTimeout_script(String timeout_script) {
        this.timeout_script = timeout_script;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set<String> getSrmHosts() {
        Set<String> set = this.localSrmHosts;
        synchronized (set) {
            HashSet<String> srmhostsCopy = new HashSet<String>(this.localSrmHosts);
            return srmhostsCopy;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addSrmHost(String srmhost) {
        Set<String> set = this.localSrmHosts;
        synchronized (set) {
            this.localSrmHosts.add(srmhost);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setSrmHostsAsArray(String[] hosts) {
        Set<String> set = this.localSrmHosts;
        synchronized (set) {
            this.localSrmHosts.clear();
            this.localSrmHosts.addAll(Arrays.asList(hosts));
        }
    }

    public AbstractStorageElement getStorage() {
        return this.storage;
    }

    public void setStorage(AbstractStorageElement storage) {
        this.storage = storage;
    }

    public SRMAuthorization getAuthorization() {
        return this.authorization;
    }

    public void setAuthorization(SRMAuthorization authorization) {
        this.authorization = authorization;
    }

    public SRM getLocalSRM() {
        return this.localSRM;
    }

    public void setLocalSRM(SRM localSRM) {
        this.localSRM = localSRM;
    }

    private String timeToString(long value) {
        return value == Long.MAX_VALUE ? INFINITY : String.valueOf(value);
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append("SRM Configuration:");
        sb.append("\n\t\"defaultSpaceLifetime\"  request lifetime: ").append(this.defaultSpaceLifetime);
        sb.append("\n\t\"get\"  request lifetime: ").append(this.getLifetime);
        sb.append("\n\t\"bringOnline\"  request lifetime: ").append(this.bringOnlineLifetime);
        sb.append("\n\t\"lsOnline\"  request lifetime: ").append(this.lsLifetime);
        sb.append("\n\t\"put\"  request lifetime: ").append(this.putLifetime);
        sb.append("\n\t\"copy\" request lifetime: ").append(this.copyLifetime);
        sb.append("\n\tdebug=").append(this.debug);
        sb.append("\n\tgsissl=").append(this.gsissl);
        sb.append("\n\tgridftp buffer_size=").append(this.buffer_size);
        sb.append("\n\tgridftp tcp_buffer_size=").append(this.tcp_buffer_size);
        sb.append("\n\tgridftp parallel_streams=").append(this.parallel_streams);
        sb.append("\n\tglue_mapfile=").append(this.glue_mapfile);
        sb.append("\n\twebservice_path=").append(this.webservice_path);
        sb.append("\n\twebservice_protocol=").append(this.webservice_protocol);
        sb.append("\n\tgsiftpclinet=").append(this.gsiftpclinet);
        sb.append("\n\turlcopy=").append(this.urlcopy);
        sb.append("\n\tsrm_root=").append(this.srm_root);
        sb.append("\n\ttimeout_script=").append(this.timeout_script);
        sb.append("\n\turlcopy timeout in seconds=").append(this.timeout);
        sb.append("\n\tproxies directory=").append(this.proxies_directory);
        sb.append("\n\tport=").append(this.port);
        sb.append("\n\tsrmHost=").append(this.getSrmHost());
        sb.append("\n\tlocalSrmHosts=");
        for (String host : this.getSrmHosts()) {
            sb.append(host).append(", ");
        }
        sb.append("\n\twebservice_path=").append(this.webservice_path);
        sb.append("\n\twebservice_protocol=").append(this.webservice_protocol);
        sb.append("\n\tx509ServiceKey=").append(this.x509ServiceKey);
        sb.append("\n\tx509ServiceCert=").append(this.x509ServiceCert);
        sb.append("\n\tx509TrastedCACerts=").append(this.x509TrastedCACerts);
        sb.append("\n\tuseUrlcopyScript=").append(this.useUrlcopyScript);
        sb.append("\n\tuseGsiftpForSrmCopy=").append(this.useGsiftpForSrmCopy);
        sb.append("\n\tuseHttpForSrmCopy=").append(this.useHttpForSrmCopy);
        sb.append("\n\tuseDcapForSrmCopy=").append(this.useDcapForSrmCopy);
        sb.append("\n\tuseFtpForSrmCopy=").append(this.useFtpForSrmCopy);
        sb.append("\n\tjdbcUrl=").append(this.jdbcUrl);
        sb.append("\n\tjdbcClass=").append(this.jdbcClass);
        sb.append("\n\tjdbcUser=").append(this.jdbcUser);
        for (int i = 0; i < this.protocols.length; ++i) {
            sb.append("\n\tprotocols[" + i + "]=").append(this.protocols[i]);
        }
        sb.append("\n\t\t *** GetRequests Scheduler  Parameters **");
        sb.append("\n\t\t request Lifetime in miliseconds =").append(this.getLifetime);
        sb.append("\n\t\t max thread queue size =").append(this.getReqTQueueSize);
        sb.append("\n\t\t max number of threads =").append(this.getThreadPoolSize);
        sb.append("\n\t\t max number of waiting file requests =").append(this.getMaxWaitingRequests);
        sb.append("\n\t\t max ready queue size =").append(this.getReadyQueueSize);
        sb.append("\n\t\t max number of ready file requests =").append(this.getMaxReadyJobs);
        sb.append("\n\t\t maximum number of retries = ").append(this.getMaxNumOfRetries);
        sb.append("\n\t\t retry timeout in miliseconds =").append(this.getRetryTimeout);
        sb.append("\n\t\t maximum number of jobs running created");
        sb.append("\n\t\t by the same owner if other jobs are queued =").append(this.getMaxRunningBySameOwner);
        sb.append("\n\t\t getRequestRestorePolicy=").append(this.getRequestRestorePolicy);
        sb.append("\n\t\t switch to async mode delay=").append(this.timeToString(this.getSwitchToAsynchronousModeDelay));
        sb.append("\n\t\t *** BringOnlineRequests Scheduler  Parameters **");
        sb.append("\n\t\t request Lifetime in miliseconds =").append(this.bringOnlineLifetime);
        sb.append("\n\t\t max thread queue size =").append(this.bringOnlineReqTQueueSize);
        sb.append("\n\t\t max number of threads =").append(this.bringOnlineThreadPoolSize);
        sb.append("\n\t\t max number of waiting file requests =").append(this.bringOnlineMaxWaitingRequests);
        sb.append("\n\t\t max ready queue size =").append(this.bringOnlineReadyQueueSize);
        sb.append("\n\t\t max number of ready file requests =").append(this.bringOnlineMaxReadyJobs);
        sb.append("\n\t\t maximum number of retries = ").append(this.bringOnlineMaxNumOfRetries);
        sb.append("\n\t\t retry timeout in miliseconds =").append(this.bringOnlineRetryTimeout);
        sb.append("\n\t\t maximum number of jobs running created");
        sb.append("\n\t\t by the same owner if other jobs are queued =").append(this.bringOnlineMaxRunningBySameOwner);
        sb.append("\n\t\t bringOnlineRequestRestorePolicy=").append(this.bringOnlineRequestRestorePolicy);
        sb.append("\n\t\t switch to async mode delay=").append(this.timeToString(this.bringOnlineSwitchToAsynchronousModeDelay));
        sb.append("\n\t\t *** LsRequests Scheduler  Parameters **");
        sb.append("\n\t\t request Lifetime in miliseconds =").append(this.lsLifetime);
        sb.append("\n\t\t max thread queue size =").append(this.lsReqTQueueSize);
        sb.append("\n\t\t max number of threads =").append(this.lsThreadPoolSize);
        sb.append("\n\t\t max number of waiting file requests =").append(this.lsMaxWaitingRequests);
        sb.append("\n\t\t max ready queue size =").append(this.lsReadyQueueSize);
        sb.append("\n\t\t max number of ready file requests =").append(this.lsMaxReadyJobs);
        sb.append("\n\t\t maximum number of retries = ").append(this.lsMaxNumOfRetries);
        sb.append("\n\t\t retry timeout in miliseconds =").append(this.lsRetryTimeout);
        sb.append("\n\t\t maximum number of jobs running created");
        sb.append("\n\t\t by the same owner if other jobs are queued =").append(this.lsMaxRunningBySameOwner);
        sb.append("\n\t\t lsRequestRestorePolicy=").append(this.lsRequestRestorePolicy);
        sb.append("\n\t\t switch to async mode delay=").append(this.timeToString(this.lsSwitchToAsynchronousModeDelay));
        sb.append("\n\t\t *** PutRequests Scheduler  Parameters **");
        sb.append("\n\t\t request Lifetime in miliseconds =").append(this.putLifetime);
        sb.append("\n\t\t max thread queue size =").append(this.putReqTQueueSize);
        sb.append("\n\t\t max number of threads =").append(this.putThreadPoolSize);
        sb.append("\n\t\t max number of waiting file requests =").append(this.putMaxWaitingRequests);
        sb.append("\n\t\t max ready queue size =").append(this.putReadyQueueSize);
        sb.append("\n\t\t max number of ready file requests =").append(this.putMaxReadyJobs);
        sb.append("\n\t\t maximum number of retries = ").append(this.putMaxNumOfRetries);
        sb.append("\n\t\t retry timeout in miliseconds =").append(this.putRetryTimeout);
        sb.append("\n\t\t maximum number of jobs running created");
        sb.append("\n\t\t by the same owner if other jobs are queued =").append(this.putMaxRunningBySameOwner);
        sb.append("\n\t\t putRequestRestorePolicy=").append(this.putRequestRestorePolicy);
        sb.append("\n\t\t switch to async mode delay=").append(this.timeToString(this.putSwitchToAsynchronousModeDelay));
        sb.append("\n\t\t *** CopyRequests Scheduler  Parameters **");
        sb.append("\n\t\t request Lifetime in miliseconds =").append(this.copyLifetime);
        sb.append("\n\t\t max thread queue size =").append(this.copyReqTQueueSize);
        sb.append("\n\t\t max number of threads =").append(this.copyThreadPoolSize);
        sb.append("\n\t\t max number of waiting file requests =").append(this.copyMaxWaitingRequests);
        sb.append("\n\t\t maximum number of retries = ").append(this.copyMaxNumOfRetries);
        sb.append("\n\t\t retry timeout in miliseconds =").append(this.copyRetryTimeout);
        sb.append("\n\t\t maximum number of jobs running created");
        sb.append("\n\t\t by the same owner if other jobs are queued =").append(this.copyMaxRunningBySameOwner);
        sb.append("\n\t\t copyRequestRestorePolicy=").append(this.copyRequestRestorePolicy);
        for (DatabaseParameters parameters : this.databaseParameters.values()) {
            sb.append(parameters);
        }
        sb.append("\n\treserve_space_implicitely=").append(this.reserve_space_implicitely);
        sb.append("\n\tspace_reservation_strict=").append(this.space_reservation_strict);
        sb.append("\n\tstorage_info_update_period=").append(this.storage_info_update_period);
        sb.append("\n\tqosPluginClass=").append(this.qosPluginClass);
        sb.append("\n\tqosConfigFile=").append(this.qosConfigFile);
        sb.append("\n\tclientDNSLookup=").append(this.clientDNSLookup);
        sb.append("\n\tclientTransport=").append(this.clientTransport);
        return sb.toString();
    }

    public int getParallel_streams() {
        return this.parallel_streams;
    }

    public void setParallel_streams(int parallel_streams) {
        this.parallel_streams = parallel_streams;
    }

    public String getX509ServiceKey() {
        return this.x509ServiceKey;
    }

    public void setX509ServiceKey(String x509ServiceKey) {
        this.x509ServiceKey = x509ServiceKey;
    }

    public String getX509ServiceCert() {
        return this.x509ServiceCert;
    }

    public void setX509ServiceCert(String x509ServiceCert) {
        this.x509ServiceCert = x509ServiceCert;
    }

    public String getX509TrastedCACerts() {
        return this.x509TrastedCACerts;
    }

    public void setX509TrastedCACerts(String x509TrastedCACerts) {
        this.x509TrastedCACerts = x509TrastedCACerts;
    }

    public long getGetLifetime() {
        return this.getLifetime;
    }

    public void setGetLifetime(long getLifetime) {
        this.getLifetime = getLifetime;
    }

    public long getPutLifetime() {
        return this.putLifetime;
    }

    public void setPutLifetime(long putLifetime) {
        this.putLifetime = putLifetime;
    }

    public long getCopyLifetime() {
        return this.copyLifetime;
    }

    public void setCopyLifetime(long copyLifetime) {
        this.copyLifetime = copyLifetime;
    }

    public boolean isUseUrlcopyScript() {
        return this.useUrlcopyScript;
    }

    public void setUseUrlcopyScript(boolean useUrlcopyScript) {
        this.useUrlcopyScript = useUrlcopyScript;
    }

    public boolean isUseDcapForSrmCopy() {
        return this.useDcapForSrmCopy;
    }

    public void setUseDcapForSrmCopy(boolean useDcapForSrmCopy) {
        this.useDcapForSrmCopy = useDcapForSrmCopy;
    }

    public boolean isUseGsiftpForSrmCopy() {
        return this.useGsiftpForSrmCopy;
    }

    public void setUseGsiftpForSrmCopy(boolean useGsiftpForSrmCopy) {
        this.useGsiftpForSrmCopy = useGsiftpForSrmCopy;
    }

    public boolean isUseHttpForSrmCopy() {
        return this.useHttpForSrmCopy;
    }

    public void setUseHttpForSrmCopy(boolean useHttpForSrmCopy) {
        this.useHttpForSrmCopy = useHttpForSrmCopy;
    }

    public boolean isUseFtpForSrmCopy() {
        return this.useFtpForSrmCopy;
    }

    public void setUseFtpForSrmCopy(boolean useFtpForSrmCopy) {
        this.useFtpForSrmCopy = useFtpForSrmCopy;
    }

    public boolean isRecursiveDirectoryCreation() {
        return this.recursiveDirectoryCreation;
    }

    public void setRecursiveDirectoryCreation(boolean recursiveDirectoryCreation) {
        this.recursiveDirectoryCreation = recursiveDirectoryCreation;
    }

    public boolean isAdvisoryDelete() {
        return this.advisoryDelete;
    }

    public void setAdvisoryDelete(boolean advisoryDelete) {
        this.advisoryDelete = advisoryDelete;
    }

    public boolean isRemoveFile() {
        return this.removeFile;
    }

    public void setRemoveFile(boolean removeFile) {
        this.removeFile = removeFile;
    }

    public boolean isRemoveDirectory() {
        return this.removeDirectory;
    }

    public void setRemoveDirectory(boolean removeDirectory) {
        this.removeDirectory = removeDirectory;
    }

    public boolean isCreateDirectory() {
        return this.createDirectory;
    }

    public void setCreateDirectory(boolean createDirectory) {
        this.createDirectory = createDirectory;
    }

    public boolean isMoveEntry() {
        return this.moveEntry;
    }

    public void setMoveEntry(boolean moveEntry) {
        this.moveEntry = moveEntry;
    }

    public boolean isSaveMemory() {
        return this.saveMemory;
    }

    public void setSaveMemory(boolean saveMemory) {
        this.saveMemory = saveMemory;
    }

    public String getJdbcUrl() {
        return this.jdbcUrl;
    }

    public void setJdbcUrl(String jdbcUrl) {
        this.jdbcUrl = jdbcUrl;
    }

    public String getJdbcClass() {
        return this.jdbcClass;
    }

    public void setJdbcClass(String jdbcClass) {
        this.jdbcClass = jdbcClass;
    }

    public String getJdbcUser() {
        return this.jdbcUser;
    }

    public void setJdbcUser(String user) {
        this.jdbcUser = user;
    }

    public String getJdbcPass() throws SQLException {
        if (this.jdbcPwdfile == null) {
            return this.jdbcPass;
        }
        if (this.jdbcPwdfile.equals("")) {
            return this.jdbcPass;
        }
        Pgpass pgpass = new Pgpass(this.jdbcPwdfile);
        return pgpass.getPgpass(this.jdbcUrl, this.jdbcUser);
    }

    public void setJdbcPass(String pass) {
        this.jdbcPass = pass;
    }

    public String getJdbcPwdfile() {
        return this.jdbcPwdfile;
    }

    public void setJdbcPwdfile(String name) {
        this.jdbcPwdfile = name;
    }

    public String getNextRequestIdStorageTable() {
        return this.nextRequestIdStorageTable;
    }

    public void setNextRequestIdStorageTable(String nextRequestIdStorageTable) {
        this.nextRequestIdStorageTable = nextRequestIdStorageTable;
    }

    public int getGetReqTQueueSize() {
        return this.getReqTQueueSize;
    }

    public void setGetReqTQueueSize(int getReqTQueueSize) {
        this.getReqTQueueSize = getReqTQueueSize;
    }

    public int getGetThreadPoolSize() {
        return this.getThreadPoolSize;
    }

    public void setGetThreadPoolSize(int getThreadPoolSize) {
        this.getThreadPoolSize = getThreadPoolSize;
    }

    public int getGetMaxWaitingRequests() {
        return this.getMaxWaitingRequests;
    }

    public void setGetMaxWaitingRequests(int getMaxWaitingRequests) {
        this.getMaxWaitingRequests = getMaxWaitingRequests;
    }

    public int getGetReadyQueueSize() {
        return this.getReadyQueueSize;
    }

    public void setGetReadyQueueSize(int getReadyQueueSize) {
        this.getReadyQueueSize = getReadyQueueSize;
    }

    public int getGetMaxReadyJobs() {
        return this.getMaxReadyJobs;
    }

    public void setGetMaxReadyJobs(int getMaxReadyJobs) {
        this.getMaxReadyJobs = getMaxReadyJobs;
    }

    public int getGetMaxNumOfRetries() {
        return this.getMaxNumOfRetries;
    }

    public void setGetMaxNumOfRetries(int getMaxNumOfRetries) {
        this.getMaxNumOfRetries = getMaxNumOfRetries;
    }

    public long getGetRetryTimeout() {
        return this.getRetryTimeout;
    }

    public void setGetRetryTimeout(long getRetryTimeout) {
        this.getRetryTimeout = getRetryTimeout;
    }

    public int getGetMaxRunningBySameOwner() {
        return this.getMaxRunningBySameOwner;
    }

    public void setGetMaxRunningBySameOwner(int getMaxRunningBySameOwner) {
        this.getMaxRunningBySameOwner = getMaxRunningBySameOwner;
    }

    public int getPutReqTQueueSize() {
        return this.putReqTQueueSize;
    }

    public void setPutReqTQueueSize(int putReqTQueueSize) {
        this.putReqTQueueSize = putReqTQueueSize;
    }

    public int getPutThreadPoolSize() {
        return this.putThreadPoolSize;
    }

    public void setPutThreadPoolSize(int putThreadPoolSize) {
        this.putThreadPoolSize = putThreadPoolSize;
    }

    public int getPutMaxWaitingRequests() {
        return this.putMaxWaitingRequests;
    }

    public void setPutMaxWaitingRequests(int putMaxWaitingRequests) {
        this.putMaxWaitingRequests = putMaxWaitingRequests;
    }

    public int getPutReadyQueueSize() {
        return this.putReadyQueueSize;
    }

    public void setPutReadyQueueSize(int putReadyQueueSize) {
        this.putReadyQueueSize = putReadyQueueSize;
    }

    public int getPutMaxReadyJobs() {
        return this.putMaxReadyJobs;
    }

    public void setPutMaxReadyJobs(int putMaxReadyJobs) {
        this.putMaxReadyJobs = putMaxReadyJobs;
    }

    public int getPutMaxNumOfRetries() {
        return this.putMaxNumOfRetries;
    }

    public void setPutMaxNumOfRetries(int putMaxNumOfRetries) {
        this.putMaxNumOfRetries = putMaxNumOfRetries;
    }

    public long getPutRetryTimeout() {
        return this.putRetryTimeout;
    }

    public void setPutRetryTimeout(long putRetryTimeout) {
        this.putRetryTimeout = putRetryTimeout;
    }

    public int getPutMaxRunningBySameOwner() {
        return this.putMaxRunningBySameOwner;
    }

    public void setPutMaxRunningBySameOwner(int putMaxRunningBySameOwner) {
        this.putMaxRunningBySameOwner = putMaxRunningBySameOwner;
    }

    public int getCopyReqTQueueSize() {
        return this.copyReqTQueueSize;
    }

    public void setCopyReqTQueueSize(int copyReqTQueueSize) {
        this.copyReqTQueueSize = copyReqTQueueSize;
    }

    public int getCopyThreadPoolSize() {
        return this.copyThreadPoolSize;
    }

    public void setCopyThreadPoolSize(int copyThreadPoolSize) {
        this.copyThreadPoolSize = copyThreadPoolSize;
    }

    public int getCopyMaxWaitingRequests() {
        return this.copyMaxWaitingRequests;
    }

    public void setCopyMaxWaitingRequests(int copyMaxWaitingRequests) {
        this.copyMaxWaitingRequests = copyMaxWaitingRequests;
    }

    public int getCopyMaxNumOfRetries() {
        return this.copyMaxNumOfRetries;
    }

    public void setCopyMaxNumOfRetries(int copyMaxNumOfRetries) {
        this.copyMaxNumOfRetries = copyMaxNumOfRetries;
    }

    public long getCopyRetryTimeout() {
        return this.copyRetryTimeout;
    }

    public void setCopyRetryTimeout(long copyRetryTimeout) {
        this.copyRetryTimeout = copyRetryTimeout;
    }

    public int getCopyMaxRunningBySameOwner() {
        return this.copyMaxRunningBySameOwner;
    }

    public void setCopyMaxRunningBySameOwner(int copyMaxRunningBySameOwner) {
        this.copyMaxRunningBySameOwner = copyMaxRunningBySameOwner;
    }

    public static final void main(String[] args) throws Exception {
        if (args == null || args.length != 2 || args[0].equalsIgnoreCase("-h") || args[0].equalsIgnoreCase("-help") || args[0].equalsIgnoreCase("--h") || args[0].equalsIgnoreCase("--help")) {
            System.err.println("Usage: Configuration load <file>\n or Configuration save <file>");
            return;
        }
        String command = args[0];
        String file = args[1];
        if (command.equals("load")) {
            System.out.println("reading configuration from file " + file);
            Configuration config = new Configuration(file);
            System.out.println("read configuration successfully:");
            System.out.print(config.toString());
        } else if (command.equals("save")) {
            Configuration config = new Configuration();
            System.out.print(config.toString());
            System.out.println("writing configuration to a file " + file);
            config.write(file);
            System.out.println("done");
        } else {
            System.err.println("Usage: Co<nfiguration load <file>\n or Configuration save <file>");
            return;
        }
    }

    public boolean isReserve_space_implicitely() {
        return this.reserve_space_implicitely;
    }

    public void setReserve_space_implicitely(boolean reserve_space_implicitely) {
        this.reserve_space_implicitely = reserve_space_implicitely;
    }

    public boolean isSpace_reservation_strict() {
        return this.space_reservation_strict;
    }

    public void setSpace_reservation_strict(boolean space_reservation_strict) {
        this.space_reservation_strict = space_reservation_strict;
    }

    public long getStorage_info_update_period() {
        return this.storage_info_update_period;
    }

    public void setStorage_info_update_period(long storage_info_update_period) {
        this.storage_info_update_period = storage_info_update_period;
    }

    public String getPutRequestRestorePolicy() {
        return this.putRequestRestorePolicy;
    }

    public void setPutRequestRestorePolicy(String putRequestRestorePolicy) {
        if (!(putRequestRestorePolicy.equalsIgnoreCase(ON_RESTART_FAIL_REQUEST) || putRequestRestorePolicy.equalsIgnoreCase(ON_RESTART_RESTORE_REQUEST) || putRequestRestorePolicy.equalsIgnoreCase(ON_RESTART_WAIT_FOR_UPDATE_REQUEST))) {
            throw new IllegalArgumentException("putRequestRestorePolicy value must be one of \"fail\", \"restore\" or \"wait-update\"  but received value=" + putRequestRestorePolicy);
        }
        this.putRequestRestorePolicy = putRequestRestorePolicy;
    }

    public String getGetRequestRestorePolicy() {
        return this.getRequestRestorePolicy;
    }

    public void setGetRequestRestorePolicy(String getRequestRestorePolicy) {
        if (!(getRequestRestorePolicy.equalsIgnoreCase(ON_RESTART_FAIL_REQUEST) || getRequestRestorePolicy.equalsIgnoreCase(ON_RESTART_RESTORE_REQUEST) || getRequestRestorePolicy.equalsIgnoreCase(ON_RESTART_WAIT_FOR_UPDATE_REQUEST))) {
            throw new IllegalArgumentException("getRequestRestorePolicy value must be one of \"fail\", \"restore\" or \"wait-update\"  but received value=" + getRequestRestorePolicy);
        }
        this.getRequestRestorePolicy = getRequestRestorePolicy;
    }

    public String getCopyRequestRestorePolicy() {
        return this.copyRequestRestorePolicy;
    }

    public void setCopyRequestRestorePolicy(String copyRequestRestorePolicy) {
        if (!(copyRequestRestorePolicy.equalsIgnoreCase(ON_RESTART_FAIL_REQUEST) || copyRequestRestorePolicy.equalsIgnoreCase(ON_RESTART_RESTORE_REQUEST) || copyRequestRestorePolicy.equalsIgnoreCase(ON_RESTART_WAIT_FOR_UPDATE_REQUEST))) {
            throw new IllegalArgumentException("copyRequestRestorePolicy value must be one of \"fail\", \"restore\" or \"wait-update\"  but received value=" + copyRequestRestorePolicy);
        }
        this.copyRequestRestorePolicy = copyRequestRestorePolicy;
    }

    public String getQosPluginClass() {
        return this.qosPluginClass;
    }

    public void setQosPluginClass(String qosPluginClass) {
        this.qosPluginClass = Strings.emptyToNull((String)qosPluginClass);
    }

    public String getQosConfigFile() {
        return this.qosConfigFile;
    }

    public void setQosConfigFile(String qosConfigFile) {
        this.qosConfigFile = Strings.emptyToNull((String)qosConfigFile);
    }

    public long getDefaultSpaceLifetime() {
        return this.defaultSpaceLifetime;
    }

    public void setDefaultSpaceLifetime(long defaultSpaceLifetime) {
        this.defaultSpaceLifetime = defaultSpaceLifetime;
    }

    public void setGetPriorityPolicyPlugin(String txt) {
        this.getPriorityPolicyPlugin = txt;
    }

    public String getGetPriorityPolicyPlugin() {
        return this.getPriorityPolicyPlugin;
    }

    public void setPutPriorityPolicyPlugin(String txt) {
        this.putPriorityPolicyPlugin = txt;
    }

    public String getPutPriorityPolicyPlugin() {
        return this.putPriorityPolicyPlugin;
    }

    public void setCopyPriorityPolicyPlugin(String txt) {
        this.putPriorityPolicyPlugin = txt;
    }

    public String getCopyPriorityPolicyPlugin() {
        return this.putPriorityPolicyPlugin;
    }

    public Integer getJdbcExecutionThreadNum() {
        return this.jdbcExecutionThreadNum;
    }

    public void setJdbcExecutionThreadNum(Integer jdbcExecutionThreadNum) {
        this.jdbcExecutionThreadNum = jdbcExecutionThreadNum;
    }

    public Integer getMaxQueuedJdbcTasksNum() {
        return this.maxQueuedJdbcTasksNum;
    }

    public void setMaxQueuedJdbcTasksNum(Integer maxQueuedJdbcTasksNum) {
        this.maxQueuedJdbcTasksNum = maxQueuedJdbcTasksNum;
    }

    public String getCredentialsDirectory() {
        return this.credentialsDirectory;
    }

    public void setCredentialsDirectory(String credentialsDirectory) {
        this.credentialsDirectory = credentialsDirectory;
    }

    public boolean isOverwrite() {
        return this.overwrite;
    }

    public void setOverwrite(boolean overwrite) {
        this.overwrite = overwrite;
    }

    public int getSizeOfSingleRemoveBatch() {
        return this.sizeOfSingleRemoveBatch;
    }

    public void setSizeOfSingleRemoveBatch(int size) {
        this.sizeOfSingleRemoveBatch = size;
    }

    public long getGetSwitchToAsynchronousModeDelay() {
        return this.getSwitchToAsynchronousModeDelay;
    }

    public void setGetSwitchToAsynchronousModeDelay(long time) {
        this.getSwitchToAsynchronousModeDelay = time;
    }

    public long getPutSwitchToAsynchronousModeDelay() {
        return this.putSwitchToAsynchronousModeDelay;
    }

    public void setPutSwitchToAsynchronousModeDelay(long time) {
        this.putSwitchToAsynchronousModeDelay = time;
    }

    public long getLsSwitchToAsynchronousModeDelay() {
        return this.lsSwitchToAsynchronousModeDelay;
    }

    public void setLsSwitchToAsynchronousModeDelay(long time) {
        this.lsSwitchToAsynchronousModeDelay = time;
    }

    public long getBringOnlineSwitchToAsynchronousModeDelay() {
        return this.bringOnlineSwitchToAsynchronousModeDelay;
    }

    public void setBringOnlineSwitchToAsynchronousModeDelay(long time) {
        this.bringOnlineSwitchToAsynchronousModeDelay = time;
    }

    public int getMaxNumberOfLsLevels() {
        return this.maxNumberOfLsLevels;
    }

    public void setMaxNumberOfLsLevels(int max_ls_levels) {
        this.maxNumberOfLsLevels = max_ls_levels;
    }

    public int getMaxNumberOfLsEntries() {
        return this.maxNumberOfLsEntries;
    }

    public void setMaxNumberOfLsEntries(int max_ls_entries) {
        this.maxNumberOfLsEntries = max_ls_entries;
    }

    public boolean isOverwrite_by_default() {
        return this.overwrite_by_default;
    }

    public void setOverwrite_by_default(boolean overwrite_by_default) {
        this.overwrite_by_default = overwrite_by_default;
    }

    public SRMUserPersistenceManager getSrmUserPersistenceManager() {
        return this.srmUserPersistenceManager;
    }

    public void setSrmUserPersistenceManager(SRMUserPersistenceManager srmUserPersistenceManager) {
        this.srmUserPersistenceManager = srmUserPersistenceManager;
    }

    public int getBringOnlineReqTQueueSize() {
        return this.bringOnlineReqTQueueSize;
    }

    public void setBringOnlineReqTQueueSize(int bringOnlineReqTQueueSize) {
        this.bringOnlineReqTQueueSize = bringOnlineReqTQueueSize;
    }

    public int getBringOnlineThreadPoolSize() {
        return this.bringOnlineThreadPoolSize;
    }

    public void setBringOnlineThreadPoolSize(int bringOnlineThreadPoolSize) {
        this.bringOnlineThreadPoolSize = bringOnlineThreadPoolSize;
    }

    public int getBringOnlineMaxWaitingRequests() {
        return this.bringOnlineMaxWaitingRequests;
    }

    public void setBringOnlineMaxWaitingRequests(int bringOnlineMaxWaitingRequests) {
        this.bringOnlineMaxWaitingRequests = bringOnlineMaxWaitingRequests;
    }

    public int getBringOnlineReadyQueueSize() {
        return this.bringOnlineReadyQueueSize;
    }

    public void setBringOnlineReadyQueueSize(int bringOnlineReadyQueueSize) {
        this.bringOnlineReadyQueueSize = bringOnlineReadyQueueSize;
    }

    public int getBringOnlineMaxReadyJobs() {
        return this.bringOnlineMaxReadyJobs;
    }

    public void setBringOnlineMaxReadyJobs(int bringOnlineMaxReadyJobs) {
        this.bringOnlineMaxReadyJobs = bringOnlineMaxReadyJobs;
    }

    public int getBringOnlineMaxNumOfRetries() {
        return this.bringOnlineMaxNumOfRetries;
    }

    public void setBringOnlineMaxNumOfRetries(int bringOnlineMaxNumOfRetries) {
        this.bringOnlineMaxNumOfRetries = bringOnlineMaxNumOfRetries;
    }

    public long getBringOnlineRetryTimeout() {
        return this.bringOnlineRetryTimeout;
    }

    public void setBringOnlineRetryTimeout(long bringOnlineRetryTimeout) {
        this.bringOnlineRetryTimeout = bringOnlineRetryTimeout;
    }

    public int getBringOnlineMaxRunningBySameOwner() {
        return this.bringOnlineMaxRunningBySameOwner;
    }

    public void setBringOnlineMaxRunningBySameOwner(int bringOnlineMaxRunningBySameOwner) {
        this.bringOnlineMaxRunningBySameOwner = bringOnlineMaxRunningBySameOwner;
    }

    public String getBringOnlineRequestRestorePolicy() {
        return this.bringOnlineRequestRestorePolicy;
    }

    public void setBringOnlineRequestRestorePolicy(String bringOnlineRequestRestorePolicy) {
        this.bringOnlineRequestRestorePolicy = bringOnlineRequestRestorePolicy;
    }

    public long getBringOnlineLifetime() {
        return this.bringOnlineLifetime;
    }

    public void setBringOnlineLifetime(long bringOnlineLifetime) {
        this.bringOnlineLifetime = bringOnlineLifetime;
    }

    public String getBringOnlinePriorityPolicyPlugin() {
        return this.bringOnlinePriorityPolicyPlugin;
    }

    public void setBringOnlinePriorityPolicyPlugin(String bringOnlinePriorityPolicyPlugin) {
        this.bringOnlinePriorityPolicyPlugin = bringOnlinePriorityPolicyPlugin;
    }

    public int getLsReqTQueueSize() {
        return this.lsReqTQueueSize;
    }

    public void setLsReqTQueueSize(int lsReqTQueueSize) {
        this.lsReqTQueueSize = lsReqTQueueSize;
    }

    public int getLsThreadPoolSize() {
        return this.lsThreadPoolSize;
    }

    public void setLsThreadPoolSize(int lsThreadPoolSize) {
        this.lsThreadPoolSize = lsThreadPoolSize;
    }

    public int getLsMaxWaitingRequests() {
        return this.lsMaxWaitingRequests;
    }

    public void setLsMaxWaitingRequests(int lsMaxWaitingRequests) {
        this.lsMaxWaitingRequests = lsMaxWaitingRequests;
    }

    public int getLsReadyQueueSize() {
        return this.lsReadyQueueSize;
    }

    public void setLsReadyQueueSize(int lsReadyQueueSize) {
        this.lsReadyQueueSize = lsReadyQueueSize;
    }

    public int getLsMaxReadyJobs() {
        return this.lsMaxReadyJobs;
    }

    public void setLsMaxReadyJobs(int lsMaxReadyJobs) {
        this.lsMaxReadyJobs = lsMaxReadyJobs;
    }

    public int getLsMaxNumOfRetries() {
        return this.lsMaxNumOfRetries;
    }

    public void setLsMaxNumOfRetries(int lsMaxNumOfRetries) {
        this.lsMaxNumOfRetries = lsMaxNumOfRetries;
    }

    public long getLsRetryTimeout() {
        return this.lsRetryTimeout;
    }

    public void setLsRetryTimeout(long lsRetryTimeout) {
        this.lsRetryTimeout = lsRetryTimeout;
    }

    public int getLsMaxRunningBySameOwner() {
        return this.lsMaxRunningBySameOwner;
    }

    public void setLsMaxRunningBySameOwner(int lsMaxRunningBySameOwner) {
        this.lsMaxRunningBySameOwner = lsMaxRunningBySameOwner;
    }

    public String getLsRequestRestorePolicy() {
        return this.lsRequestRestorePolicy;
    }

    public void setLsRequestRestorePolicy(String lsRequestRestorePolicy) {
        this.lsRequestRestorePolicy = lsRequestRestorePolicy;
    }

    public long getLsLifetime() {
        return this.lsLifetime;
    }

    public void setLsLifetime(long lsLifetime) {
        this.lsLifetime = lsLifetime;
    }

    public String getLsPriorityPolicyPlugin() {
        return this.lsPriorityPolicyPlugin;
    }

    public void setLsPriorityPolicyPlugin(String lsPriorityPolicyPlugin) {
        this.lsPriorityPolicyPlugin = lsPriorityPolicyPlugin;
    }

    public boolean isClientDNSLookup() {
        return this.clientDNSLookup;
    }

    public void setClientDNSLookup(boolean clientDNSLookup) {
        this.clientDNSLookup = clientDNSLookup;
    }

    public String getCounterRrdDirectory() {
        return this.counterRrdDirectory;
    }

    public void setCounterRrdDirectory(String rrdDirectory) {
        this.counterRrdDirectory = rrdDirectory;
    }

    public String getGaugeRrdDirectory() {
        return this.gaugeRrdDirectory;
    }

    public void setGaugeRrdDirectory(String gaugeRrdDirectory) {
        this.gaugeRrdDirectory = gaugeRrdDirectory;
    }

    public String getSrmCounterRrdDirectory() {
        return this.srmCounterRrdDirectory;
    }

    public void setSrmCounterRrdDirectory(String srmCounterRrdDirectory) {
        this.srmCounterRrdDirectory = srmCounterRrdDirectory;
    }

    public String getSrmGaugeRrdDirectory() {
        return this.srmGaugeRrdDirectory;
    }

    public void setSrmGaugeRrdDirectory(String srmGaugeRrdDirectory) {
        this.srmGaugeRrdDirectory = srmGaugeRrdDirectory;
    }

    public String getSrmHost() {
        return this.srmHost;
    }

    public void setSrmHost(String srmHost) {
        this.srmHost = srmHost;
    }

    public Transport getClientTransport() {
        return Transport.transportFor(this.clientTransport);
    }

    public void setClientTransport(Transport transport) {
        this.clientTransport = transport.name();
    }

    public void setClientTransportByName(String name) {
        this.clientTransport = Transport.transportFor(name).name();
    }

    public DatabaseParameters getDatabaseParametersForList() {
        return this.databaseParameters.get(LS_PARAMETERS);
    }

    public DatabaseParameters getDatabaseParametersForGet() {
        return this.databaseParameters.get(GET_PARAMETERS);
    }

    public DatabaseParameters getDatabaseParametersForPut() {
        return this.databaseParameters.get(PUT_PARAMETERS);
    }

    public DatabaseParameters getDatabaseParametersForBringOnline() {
        return this.databaseParameters.get(BRINGONLINE_PARAMETERS);
    }

    public DatabaseParameters getDatabaseParametersForCopy() {
        return this.databaseParameters.get(COPY_PARAMETERS);
    }

    public DatabaseParameters getDatabaseParametersForReserve() {
        return this.databaseParameters.get(RESERVE_PARAMETERS);
    }

    public DatabaseParameters getDatabaseParameters(String name) {
        return this.databaseParameters.get(name);
    }

    public class DatabaseParameters {
        private final String name;
        private boolean databaseEnabled = true;
        private boolean requestHistoryDatabaseEnabled = false;
        private boolean storeCompletedRequestsOnly = false;
        private int keepRequestHistoryPeriod = 30;
        private long expiredRequestRemovalPeriod = 3600L;
        private boolean cleanPendingRequestsOnRestart = false;

        public DatabaseParameters(String name) {
            this.name = name;
        }

        public boolean isDatabaseEnabled() {
            return this.databaseEnabled;
        }

        public void setDatabaseEnabled(boolean value) {
            this.databaseEnabled = value;
        }

        public boolean getStoreCompletedRequestsOnly() {
            return this.storeCompletedRequestsOnly;
        }

        public void setStoreCompletedRequestsOnly(boolean value) {
            this.storeCompletedRequestsOnly = value;
        }

        public boolean isRequestHistoryDatabaseEnabled() {
            return this.requestHistoryDatabaseEnabled;
        }

        public void setRequestHistoryDatabaseEnabled(boolean value) {
            this.requestHistoryDatabaseEnabled = value;
        }

        public int getKeepRequestHistoryPeriod() {
            return this.keepRequestHistoryPeriod;
        }

        public void setKeepRequestHistoryPeriod(int value) {
            this.keepRequestHistoryPeriod = value;
        }

        public long getExpiredRequestRemovalPeriod() {
            return this.expiredRequestRemovalPeriod;
        }

        public void setExpiredRequestRemovalPeriod(long value) {
            this.expiredRequestRemovalPeriod = value;
        }

        public boolean isCleanPendingRequestsOnRestart() {
            return this.cleanPendingRequestsOnRestart;
        }

        public void setCleanPendingRequestsOnRestart(boolean value) {
            this.cleanPendingRequestsOnRestart = value;
        }

        public String getJdbcPass() throws SQLException {
            return Configuration.this.getJdbcPass();
        }

        public String getJdbcUser() {
            return Configuration.this.getJdbcUser();
        }

        public String getJdbcClass() {
            return Configuration.this.getJdbcClass();
        }

        public String getJdbcUrl() {
            return Configuration.this.getJdbcUrl();
        }

        public SRMUserPersistenceManager getSrmUserPersistenceManager() {
            return Configuration.this.getSrmUserPersistenceManager();
        }

        public String toString() {
            StringBuilder sb = new StringBuilder();
            sb.append("\n\t\t*** ").append(this.name).append(" Store Parameters ***");
            sb.append("\n\t\tdatabaseEnabled=").append(this.databaseEnabled);
            sb.append("\n\t\tstoreCompletedRequestsOnly=").append(this.storeCompletedRequestsOnly);
            sb.append("\n\t\trequestHistoryDatabaseEnabled=").append(this.requestHistoryDatabaseEnabled);
            sb.append("\n\t\tcleanPendingRequestsOnRestart=").append(this.cleanPendingRequestsOnRestart);
            sb.append("\n\t\tkeepRequestHistoryPeriod=").append(this.keepRequestHistoryPeriod).append(" days");
            sb.append("\n\t\texpiredRequestRemovalPeriod=").append(this.expiredRequestRemovalPeriod).append(" seconds");
            return sb.toString();
        }
    }
}

