/*
 * Decompiled with CFR 0.152.
 */
package org.dcache.srm.unixfs;

import java.util.StringTokenizer;
import org.dcache.srm.FileMetaData;
import org.dcache.srm.SRMUser;
import org.dcache.srm.unixfs.UnixfsUser;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UnixfsFileMetaData
extends FileMetaData {
    private Logger logger = LoggerFactory.getLogger((String)UnixfsFileMetaData.class.getName());
    public boolean filo;
    public boolean character_device;
    public boolean directory;
    public boolean block_device;
    public boolean regular_file;
    public boolean symbolic_link;
    public boolean socket;
    public static final int S_IFMT = 61440;
    public static final int S_IFSOCK = 49152;
    public static final int S_IFLNK = 40960;
    public static final int S_IFREG = 32768;
    public static final int S_IFBLK = 24576;
    public static final int S_IFDIR = 16384;
    public static final int S_IFCHR = 8192;
    public static final int S_IFIFO = 4096;
    public static final int S_ISUID = 2048;
    public static final int S_ISGID = 1024;
    public static final int S_ISVTX = 512;
    public static final int S_IRWXU = 448;
    public static final int S_IRUSR = 256;
    public static final int S_IWUSR = 128;
    public static final int S_IXUSR = 64;
    public static final int S_IRWXG = 56;
    public static final int S_IRGRP = 32;
    public static final int S_IWGRP = 16;
    public static final int S_IXGRP = 8;
    public static final int S_IRWXO = 7;
    public static final int S_IROTH = 4;
    public static final int S_IWOTH = 2;
    public static final int S_IXOTH = 1;

    public UnixfsFileMetaData(String path, String srm_host, int srm_port, String addler32, String stat_desh_t_output) {
        int permissions;
        StringTokenizer st = new StringTokenizer(stat_desh_t_output);
        if (st.countTokens() < 6) {
            throw new IllegalArgumentException("bad \"stat -t\" output, can not parse:\n" + stat_desh_t_output);
        }
        this.SURL = "srm://" + srm_host + ":" + srm_port + "/" + path;
        String name = st.nextToken();
        this.size = new Long(st.nextToken()).intValue();
        long blocks = Long.parseLong(st.nextToken());
        int mode = Integer.parseInt(st.nextToken(), 16);
        this.owner = st.nextToken();
        this.group = st.nextToken();
        int file_type = mode & 0xF000;
        this.filo = (mode & 0x1000) != 0;
        this.character_device = (mode & 0x2000) != 0;
        this.directory = (mode & 0x4000) != 0;
        this.block_device = (mode & 0x6000) != 0;
        this.regular_file = (mode & 0x1000) != 0;
        this.symbolic_link = (mode & 0xA000) != 0;
        this.socket = (mode & 0xC000) != 0;
        this.permMode = permissions = mode & 0x1FF;
        if (addler32 != null) {
            this.checksumType = "adler32";
            this.checksumValue = addler32;
        }
    }

    @Override
    public boolean isOwner(SRMUser user) {
        try {
            return Integer.parseInt(this.owner) == ((UnixfsUser)user).getUid();
        }
        catch (NumberFormatException nfe) {
            this.logger.debug("owner is not a number: " + this.owner, (Throwable)nfe);
            throw nfe;
        }
        catch (ClassCastException cce) {
            this.logger.error("user is not a UnixfsUser: " + user, (Throwable)cce);
            throw cce;
        }
    }

    @Override
    public boolean isGroupMember(SRMUser user) {
        try {
            return Integer.parseInt(this.group) == ((UnixfsUser)user).getUid();
        }
        catch (NumberFormatException nfe) {
            this.logger.debug("group is not a number: " + this.group, (Throwable)nfe);
            throw nfe;
        }
        catch (ClassCastException cce) {
            this.logger.error("user is not a UnixfsUser: " + user, (Throwable)cce);
            throw cce;
        }
    }
}

