/*
 * Decompiled with CFR 0.152.
 */
package org.dcache.srm.unixfs;

import java.io.IOException;
import org.dcache.srm.SRMAuthorization;
import org.dcache.srm.SRMAuthorizationException;
import org.dcache.srm.SRMUser;
import org.dcache.srm.unixfs.KAuthFile;
import org.dcache.srm.unixfs.UnixfsUser;
import org.dcache.srm.unixfs.UserAuthRecord;
import org.ietf.jgss.GSSContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class UnixfsAuthorization
implements SRMAuthorization {
    private static UnixfsAuthorization srmauthorization;
    private static Logger logger;
    private String kAuthFileName;

    private UnixfsAuthorization(String kAuthFileName) {
        this.kAuthFileName = kAuthFileName;
    }

    @Override
    public SRMUser authorize(Long requestCredentialId, String secureId, String name, GSSContext context, String remoteIP) throws SRMAuthorizationException {
        UserAuthRecord user_rec = this.authorize(secureId, name);
        logger.debug("Received authorization request from remote IP {}", (Object)remoteIP);
        String username = user_rec.Username;
        String root = user_rec.Root;
        int uid = user_rec.UID;
        int gid = user_rec.GID;
        UnixfsUser user = new UnixfsUser(username, root, uid, gid);
        return user;
    }

    private UserAuthRecord authorize(String secureId, String name) throws SRMAuthorizationException {
        if (name == null) {
            name = this.getUserNameByGlobusId(secureId);
        }
        UserAuthRecord userRecord = this.getUserRecord(name, secureId);
        return userRecord;
    }

    private String getUserNameByGlobusId(String globusId) throws SRMAuthorizationException {
        KAuthFile authf = null;
        try {
            authf = new KAuthFile(this.kAuthFileName);
        }
        catch (IOException ioe) {
            ioe.printStackTrace();
            throw new SRMAuthorizationException(ioe.toString());
        }
        String username = authf.getIdMapping(globusId);
        if (username == null) {
            throw new SRMAuthorizationException(" can not determine username from GlobusId=" + globusId);
        }
        return username;
    }

    private UserAuthRecord getUserRecord(String username, String globusId) throws SRMAuthorizationException {
        KAuthFile authf = null;
        try {
            authf = new KAuthFile(this.kAuthFileName);
        }
        catch (IOException ioe) {
            ioe.printStackTrace();
            throw new SRMAuthorizationException(ioe.toString());
        }
        UserAuthRecord userRecord = authf.getUserRecord(username);
        if (userRecord == null) {
            throw new SRMAuthorizationException("user " + username + " not found");
        }
        if (!userRecord.hasSecureIdentity(globusId)) {
            throw new SRMAuthorizationException("srm authorization failed for user " + username + " with GlobusId=" + globusId);
        }
        return userRecord;
    }

    public static SRMAuthorization getAuthorization(String kAuthFileName) {
        if (srmauthorization == null) {
            srmauthorization = new UnixfsAuthorization(kAuthFileName);
        }
        if (!UnixfsAuthorization.srmauthorization.kAuthFileName.equals(kAuthFileName)) {
            srmauthorization = new UnixfsAuthorization(kAuthFileName);
        }
        return srmauthorization;
    }

    static {
        logger = LoggerFactory.getLogger(UnixfsAuthorization.class);
    }
}

