/*
 * Decompiled with CFR 0.152.
 */
package org.dcache.srm.unixfs;

import diskCacheV111.srm.StorageElementInfo;
import java.io.File;
import java.io.IOException;
import java.io.PrintStream;
import java.io.StringWriter;
import java.io.Writer;
import java.net.InetAddress;
import java.net.URI;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.dcache.srm.AbstractStorageElement;
import org.dcache.srm.AdvisoryDeleteCallbacks;
import org.dcache.srm.CopyCallbacks;
import org.dcache.srm.FileMetaData;
import org.dcache.srm.PinCallbacks;
import org.dcache.srm.PrepareToPutCallbacks;
import org.dcache.srm.PrepareToPutInSpaceCallbacks;
import org.dcache.srm.ReleaseSpaceCallbacks;
import org.dcache.srm.RemoveFileCallbacks;
import org.dcache.srm.ReserveSpaceCallbacks;
import org.dcache.srm.SRMAuthorizationException;
import org.dcache.srm.SRMException;
import org.dcache.srm.SRMInvalidPathException;
import org.dcache.srm.SRMUser;
import org.dcache.srm.SrmCancelUseOfSpaceCallbacks;
import org.dcache.srm.SrmReleaseSpaceCallbacks;
import org.dcache.srm.SrmReserveSpaceCallbacks;
import org.dcache.srm.SrmUseSpaceCallbacks;
import org.dcache.srm.UnpinCallbacks;
import org.dcache.srm.request.RequestCredential;
import org.dcache.srm.unixfs.UnixfsFileMetaData;
import org.dcache.srm.unixfs.UnixfsUser;
import org.dcache.srm.util.Configuration;
import org.dcache.srm.util.GridftpClient;
import org.dcache.srm.util.Permissions;
import org.dcache.srm.util.ShellCommandExecuter;
import org.dcache.srm.util.Tools;
import org.dcache.srm.v2_2.TMetaDataSpace;
import org.ietf.jgss.GSSCredential;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Storage
implements AbstractStorageElement {
    private static final Logger logger = LoggerFactory.getLogger(Storage.class);
    private static final String cvsId = "$Id:";
    private static final String SFN_STRING = "?SFN=";
    private boolean debug = true;
    private String gridftphost;
    private int gridftpport;
    private String[] putProtocols = new String[]{"gsiftp", "enstore"};
    private String[] getProtocols = new String[]{"gsiftp", "enstore"};
    private InetAddress myInetAddr = null;
    private Configuration config;
    private String stat_cmd;
    private String chown_cmd;
    private PrintStream out;
    private PrintStream err;
    private static final String localCopyCommand = "/bin/cp";
    private static long unique_id = 0L;
    private Map copyThreads = new HashMap();

    public Storage(String gridftphost, int gridftpport, Configuration configuration, String stat_cmd, String chown_cmd) {
        this(gridftphost, gridftpport, configuration, stat_cmd, chown_cmd, System.out, System.err);
    }

    public Storage(String gridftphost, int gridftpport, Configuration configuration, String stat_cmd, String chown_cmd, PrintStream out, PrintStream err) {
        this.config = configuration;
        if (gridftphost == null) {
            throw new IllegalArgumentException("gridftphost is null");
        }
        if (gridftpport <= 0 || gridftpport > 65535) {
            throw new IllegalArgumentException("illeagal gridftpport=" + gridftpport + "should be in a range [1,0xFFFF]");
        }
        this.gridftphost = gridftphost;
        this.gridftpport = gridftpport;
        try {
            this.myInetAddr = InetAddress.getByName(gridftphost);
        }
        catch (UnknownHostException ex) {
            this.myInetAddr = null;
        }
        this.out = out;
        this.err = err;
        StringWriter shell_out = new StringWriter();
        StringWriter shell_err = new StringWriter();
        int return_code = ShellCommandExecuter.execute(stat_cmd + " --help", (Writer)shell_out, (Writer)shell_err);
        if (return_code != 0) {
            logger.debug(stat_cmd + " --help output:");
            logger.debug(shell_out.getBuffer().toString());
            logger.error(stat_cmd + " --help error output:");
            logger.error(shell_err.getBuffer().toString());
            logger.error("can not find or run stat command, needed to this Storage Element implementation");
            throw new IllegalArgumentException("stat_cmd=\"" + stat_cmd + "\" execution failed with rc = " + return_code);
        }
        this.stat_cmd = stat_cmd;
        shell_out = new StringWriter();
        shell_err = new StringWriter();
        return_code = ShellCommandExecuter.execute(chown_cmd + " --help", (Writer)shell_out, (Writer)shell_err);
        if (return_code != 0) {
            logger.debug(chown_cmd + " --help output:");
            logger.debug(shell_out.getBuffer().toString());
            logger.error(chown_cmd + " --help error output:");
            logger.error(shell_err.getBuffer().toString());
            logger.error("can not find or run chown command, needed to this Storage Element implementation");
            throw new IllegalArgumentException("chown_cmd=\"" + chown_cmd + "\" execution failed with rc = " + return_code);
        }
        this.chown_cmd = chown_cmd;
    }

    public static void main(String[] args) {
    }

    @Override
    public String[] supportedGetProtocols() throws SRMException {
        for (String protocol : this.getProtocols) {
            logger.debug("supportedGetProtocols: " + protocol);
        }
        return this.getProtocols;
    }

    @Override
    public String[] supportedPutProtocols() throws SRMException {
        for (String protocol : this.putProtocols) {
            logger.debug("supportedPutProtocols: " + protocol);
        }
        return this.putProtocols;
    }

    @Override
    public URI getPutTurl(SRMUser user, URI surl, String[] protocols) throws SRMException {
        String filePath = this.getPath(surl);
        for (int i = 0; i < protocols.length; ++i) {
            if (protocols[i].equals("gridftp") || protocols[i].equals("gsiftp")) {
                return URI.create("gsiftp://" + this.gridftphost + ":" + this.gridftpport + "/" + filePath);
            }
            if (!protocols[i].equals("enstore")) continue;
            return URI.create("enstore://" + this.gridftphost + ":" + this.gridftpport + "/" + filePath);
        }
        throw new SRMException("no sutable protocol found");
    }

    @Override
    public URI getPutTurl(SRMUser user, URI surl, URI previous_turl) throws SRMException {
        return this.getPutTurl(user, surl, new String[]{previous_turl.getScheme()});
    }

    @Override
    public URI getGetTurl(SRMUser user, URI surl, String[] protocols) throws SRMException {
        String filePath = this.getPath(surl);
        for (int i = 0; i < protocols.length; ++i) {
            if (protocols[i].equals("gridftp") || protocols[i].equals("gsiftp")) {
                return URI.create("gsiftp://" + this.gridftphost + ":" + this.gridftpport + "/" + filePath);
            }
            if (!protocols[i].equals("enstore")) continue;
            return URI.create("enstore://" + this.gridftphost + ":" + this.gridftpport + "/" + filePath);
        }
        throw new SRMException("no sutable protocol found");
    }

    @Override
    public URI getGetTurl(SRMUser user, URI surl, URI previous_turl) throws SRMException {
        return this.getPutTurl(user, surl, new String[]{previous_turl.getScheme()});
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void getFromRemoteTURL(SRMUser user, URI remoteTURL, URI surl, SRMUser remoteUser, Long remoteCredentialId) throws SRMException {
        if (!(user instanceof UnixfsUser)) {
            throw new SRMException("user is not instance of UnixfsUser");
        }
        UnixfsUser duser = (UnixfsUser)user;
        String path = this.getPath(surl);
        try {
            if (!remoteTURL.getScheme().equalsIgnoreCase("gsiftp") && !remoteTURL.getScheme().equalsIgnoreCase("gridftp")) {
                throw new SRMException("unsupported protocol : " + remoteTURL.getScheme());
            }
            GSSCredential remoteCredential = RequestCredential.getRequestCredential(remoteCredentialId).getDelegatedCredential();
            GridftpClient client = new GridftpClient(remoteTURL.getHost(), remoteTURL.getPort(), this.config.getTcp_buffer_size(), remoteCredential);
            client.setStreamsNum(this.config.getParallel_streams());
            try {
                client.gridFTPRead(remoteTURL.getPath(), path, true, true);
            }
            finally {
                client.close();
                client = null;
            }
            this.changeOwnership(path, duser.getUid(), duser.getGid());
        }
        catch (Exception e) {
            logger.error(e.toString());
            throw new SRMException("remote turl " + remoteTURL + " to local file " + surl + " transfer failed", e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void putToRemoteTURL(SRMUser user, URI surl, URI remoteTURL, SRMUser remoteUser, Long remoteCredentialId) throws SRMException {
        String path = this.getPath(surl);
        try {
            if (!remoteTURL.getScheme().equalsIgnoreCase("gsiftp") && !remoteTURL.getScheme().equalsIgnoreCase("gridftp")) {
                throw new SRMException("unsupported protocol : " + remoteTURL.getScheme());
            }
            GSSCredential remoteCredential = RequestCredential.getRequestCredential(remoteCredentialId).getDelegatedCredential();
            GridftpClient client = new GridftpClient(remoteTURL.getHost(), remoteTURL.getPort(), this.config.getTcp_buffer_size(), remoteCredential);
            client.setStreamsNum(this.config.getParallel_streams());
            try {
                client.gridFTPWrite(path, remoteTURL.getPath(), true, true, true);
            }
            finally {
                client.close();
                client = null;
            }
        }
        catch (Exception e) {
            logger.error(e.toString());
            throw new SRMException("remote turl " + remoteTURL + " to local file " + surl + " transfer failed", e);
        }
    }

    @Override
    public void localCopy(SRMUser user, URI fromSurl, URI toSurl) throws SRMException {
        Process proc;
        String[] cmd = new String[]{localCopyCommand, this.getPath(fromSurl), this.getPath(toSurl)};
        try {
            logger.debug("Execute command in the main thread: " + cmd[0] + " " + cmd[1] + " " + cmd[2]);
            proc = Runtime.getRuntime().exec(cmd);
            proc.waitFor();
        }
        catch (IOException ex) {
            logger.error("IOException in localCopy(): " + cmd[0] + " " + cmd[1] + " " + cmd[2]);
            logger.error(ex.toString());
            throw new SRMException(ex);
        }
        catch (InterruptedException ex) {
            logger.error("InterruptedException in localCopy(): " + cmd[0] + " " + cmd[1] + " " + cmd[2]);
            logger.error(ex.toString());
            throw new SRMException(ex);
        }
        int rc = proc.exitValue();
        if (rc != 0) {
            SRMException ex = new SRMException("localCopy() filed, rc=" + rc + ", command: " + cmd[0] + " " + cmd[1] + " " + cmd[2]);
            throw ex;
        }
    }

    @Override
    public boolean isLocalTransferUrl(URI url) throws SRMException {
        InetAddress transInetAddr2;
        if (this.myInetAddr == null) {
            throw new SRMException("InetAddress.getLocalHost(), host name is unknown");
        }
        String host = url.getHost();
        try {
            transInetAddr2 = InetAddress.getByName(host);
        }
        catch (UnknownHostException ex) {
            Object transInetAddr2 = null;
            throw new SRMException("InetAddress.getByName(), Unknown host name for " + host);
        }
        return this.myInetAddr.equals(transInetAddr2) && this.gridftpport == url.getPort();
    }

    @Override
    public void setFileMetaData(SRMUser user, FileMetaData fmd) throws SRMException {
    }

    private FileMetaData _getFileMetaData(SRMUser user, String filePath) throws SRMException {
        StringWriter outWriter = new StringWriter();
        StringWriter errWriter = new StringWriter();
        try {
            File file = new File(filePath);
            if (!file.exists()) {
                throw new IOException("file does not exist");
            }
            String command = this.stat_cmd + " -t " + file.getCanonicalPath();
            logger.debug("executing command " + command);
            int return_code = ShellCommandExecuter.execute(command, (Writer)outWriter, (Writer)errWriter);
            logger.debug("command standard output:" + outWriter.getBuffer().toString());
            if (return_code != 0) {
                logger.debug("command error    output:" + errWriter.getBuffer().toString());
                throw new IOException("command failed with return_code=" + return_code);
            }
        }
        catch (IOException ioe) {
            logger.error(ioe.toString());
            throw new SRMException("can't get the FileMetaData", ioe);
        }
        UnixfsFileMetaData fmd = new UnixfsFileMetaData(filePath, this.config.getSrmHost(), this.config.getPort(), null, outWriter.getBuffer().toString());
        return fmd;
    }

    @Override
    public FileMetaData getFileMetaData(SRMUser user, URI surl, boolean read) throws SRMException {
        return this._getFileMetaData(user, this.getPath(surl));
    }

    private File _getFile(String fileId) {
        return new File(fileId);
    }

    private File _getFile(String fileId, FileMetaData fmd) {
        logger.debug("_getFile(" + fileId);
        return new File(fileId);
    }

    private File _getFile(String fileId, FileMetaData fmd, String parentFileId, FileMetaData parentFmd) {
        return new File(fileId);
    }

    @Override
    public StorageElementInfo getStorageElementInfo(SRMUser user) throws SRMException {
        SRMException srmEx = new SRMException("Method getStorageElementInfo() not yet implemented.");
        logger.error(srmEx.toString());
        throw srmEx;
    }

    @Override
    public void pinFile(SRMUser user, URI surl, String clientHost, long pinLifetime, long requestId, PinCallbacks callbacks) {
        FileMetaData fmd;
        boolean pinned = false;
        String reason = null;
        String pinId = null;
        try {
            fmd = this.getFileMetaData(user, surl, true);
        }
        catch (SRMInvalidPathException e) {
            callbacks.FileNotFound(e.getMessage());
            return;
        }
        catch (SRMException ex) {
            logger.error(ex.toString());
            callbacks.PinningFailed("Got exception for " + surl);
            return;
        }
        if (fmd.isDirectory) {
            callbacks.FileNotFound("Path is a directory");
            return;
        }
        try {
            File file = this._getFile(fmd.fileId, fmd);
            pinned = file.exists();
            logger.debug("file exists is " + pinned);
            if (pinned) {
                pinId = fmd.fileId;
            } else {
                reason = "file does not exist";
            }
        }
        catch (Exception ex) {
            reason = "got exception " + ex;
            logger.error(ex.toString());
        }
        if (pinned) {
            callbacks.Pinned(fmd, pinId);
        } else {
            callbacks.PinningFailed(reason);
        }
    }

    @Override
    public void unPinFile(SRMUser user, String fileId, UnpinCallbacks callbacks, String pinId) {
        if (!(callbacks instanceof UnpinCallbacks)) {
            throw new IllegalArgumentException("Method unPinFile() has wrong callback argument type.");
        }
        boolean unpinned = false;
        String reason = null;
        try {
            File file = this._getFile(fileId);
            unpinned = file.exists();
            if (unpinned) {
                pinId = fileId;
            } else {
                reason = "file does not exist";
            }
        }
        catch (Exception ex) {
            reason = "got exception " + ex;
            logger.error(ex.toString());
        }
        if (unpinned) {
            callbacks.Unpinned(pinId);
        } else {
            callbacks.UnpinningFailed(reason);
        }
    }

    @Override
    public void advisoryDelete(SRMUser user, URI surl, AdvisoryDeleteCallbacks callbacks) {
        if (!(callbacks instanceof AdvisoryDeleteCallbacks)) {
            throw new IllegalArgumentException("Method advisoryDelete() has wrong callback argument type.");
        }
        boolean deleted = false;
        String reason = null;
        try {
            File file = this._getFile(this.getPath(surl));
            deleted = file.delete();
            if (!deleted) {
                reason = "delete file operation failed";
            }
        }
        catch (Exception ex) {
            reason = "got exception " + ex;
            logger.error(ex.toString());
        }
        if (deleted) {
            callbacks.AdvisoryDeleteSuccesseded();
        } else {
            callbacks.AdvisoryDeleteFailed(reason);
        }
    }

    private boolean _installPath(SRMUser user, String path) {
        logger.debug("_installPath(" + user + "," + path + ")");
        File file = new File(path);
        if (file.exists()) {
            logger.debug("_installPath: file exists, returning " + (file.isDirectory() && file.canWrite()));
            return file.isDirectory() && file.canWrite();
        }
        String pPath = file.getParent();
        if (pPath == null) {
            return false;
        }
        if (!this._installPath(user, pPath)) {
            return false;
        }
        return file.mkdir();
    }

    @Override
    public void prepareToPut(SRMUser user, URI surl, PrepareToPutCallbacks callbacks, boolean overwrite) {
        FileMetaData parentFmd;
        String parentFileId;
        FileMetaData fmd;
        String fileId;
        block7: {
            String filePath;
            try {
                filePath = this.getPath(surl);
            }
            catch (SRMInvalidPathException e) {
                callbacks.InvalidPathError(e.getMessage());
                return;
            }
            File file = null;
            Object parent = null;
            fileId = null;
            fmd = null;
            parentFileId = null;
            parentFmd = null;
            String path = null;
            try {
                String parentPath;
                path = filePath;
                file = new File(filePath);
                if (file.exists()) {
                    if (overwrite) {
                        fmd = this._getFileMetaData(user, filePath);
                        fileId = filePath;
                        parentFmd = null;
                        parentFileId = null;
                        break block7;
                    }
                    String erStr = "file exists, can't overwrite";
                    callbacks.GetStorageInfoFailed(erStr);
                    return;
                }
                path = parentPath = file.getParent();
                if (this._installPath(user, parentPath)) {
                    fileId = null;
                    fmd = null;
                    parentFmd = this._getFileMetaData(user, parentPath);
                    parentFileId = parentPath;
                    break block7;
                }
                String erStr = "prepareToPut() can not get or create parent for the filePath=" + filePath + ".";
                callbacks.GetStorageInfoFailed(erStr);
                return;
            }
            catch (Exception ex) {
                logger.error(ex.toString());
                String erStr = "prepareToPut() got exception for the filePath=" + path + ".";
                callbacks.GetStorageInfoFailed(erStr);
                return;
            }
        }
        logger.debug("prepareToPut(): StorageInfoArrived, fileId=" + fileId + "fmd=" + fmd);
        callbacks.StorageInfoArrived(fileId, fmd, parentFileId, parentFmd);
    }

    @Override
    public void prepareToPutInReservedSpace(SRMUser user, String path, long size, long spaceReservationToken, PrepareToPutInSpaceCallbacks callbacks) {
        if (!(callbacks instanceof PrepareToPutInSpaceCallbacks)) {
            throw new IllegalArgumentException("Method prepareToPutInReservedSpace() has wrong callback argument type.");
        }
        UnsupportedOperationException eex = new UnsupportedOperationException("Method prepareToPutInReservedSpace() not yet implemented, this is the feature of SRM interface v2.0.");
        logger.error(eex.toString());
        callbacks.Exception(eex);
    }

    public void reserveSpace(SRMUser user, long spaceSize, long reservationLifetime, ReserveSpaceCallbacks callbacks) {
        callbacks.SpaceReserved("dummy", spaceSize);
    }

    public void releaseSpace(SRMUser user, String spaceToken, ReleaseSpaceCallbacks callbacks) {
        callbacks.SpaceReleased();
    }

    public void releaseSpace(SRMUser user, long spaceSize, String spaceToken, ReleaseSpaceCallbacks callbacks) {
        callbacks.SpaceReleased();
    }

    private void changeOwnership(String filePath, int uid, int gid) throws IOException {
        StringWriter outWriter = new StringWriter();
        StringWriter errWriter = new StringWriter();
        File file = new File(filePath);
        if (!file.exists()) {
            throw new IOException("file does not exist");
        }
        String command = this.chown_cmd + " " + uid + "." + gid + " " + file.getCanonicalPath();
        logger.debug("executing command " + command);
        int return_code = ShellCommandExecuter.execute(command, (Writer)outWriter, (Writer)errWriter);
        logger.debug("command standard output:" + outWriter.getBuffer().toString());
        if (return_code != 0) {
            logger.debug("command error    output:" + errWriter.getBuffer().toString());
            throw new IOException("command failed with return_code=" + return_code);
        }
    }

    private static final synchronized String getUniqueId() {
        return Long.toHexString(unique_id++);
    }

    @Override
    public String getFromRemoteTURL(SRMUser user, URI remoteTURL, URI surl, SRMUser remoteUser, Long remoteCredentialId, CopyCallbacks callbacks) throws SRMException {
        return this.getFromRemoteTURL(user, remoteTURL, surl, remoteUser, remoteCredentialId, null, 0L, callbacks);
    }

    @Override
    public String getFromRemoteTURL(final SRMUser user, final URI remoteTURL, final URI surl, final SRMUser remoteUser, final Long remoteCredentialId, String spaceReservationId, long size, final CopyCallbacks callbacks) throws SRMException {
        Thread t = new Thread(){

            @Override
            public void run() {
                try {
                    logger.debug("calling getFromRemoteTURL from a copy thread");
                    Storage.this.getFromRemoteTURL(user, remoteTURL, surl, remoteUser, remoteCredentialId);
                    logger.debug("calling callbacks.copyComplete for path=" + surl);
                    callbacks.copyComplete(Storage.this.getFileMetaData(user, surl, false));
                }
                catch (Exception e) {
                    callbacks.copyFailed(new SRMException(e));
                }
            }
        };
        String id = Storage.getUniqueId();
        logger.debug("getFromRemoteTURL assigned id =" + id + "for transfer from " + remoteTURL + " to " + surl);
        this.copyThreads.put(id, t);
        t.start();
        return id;
    }

    @Override
    public String putToRemoteTURL(final SRMUser user, final URI surl, final URI remoteTURL, final SRMUser remoteUser, final Long remoteCredentialId, final CopyCallbacks callbacks) throws SRMException {
        Thread t = new Thread(){

            @Override
            public void run() {
                try {
                    logger.debug("calling putToRemoteTURL from a copy thread");
                    Storage.this.putToRemoteTURL(user, surl, remoteTURL, remoteUser, remoteCredentialId);
                    logger.debug("calling callbacks.copyComplete for path=" + surl);
                    callbacks.copyComplete(Storage.this.getFileMetaData(user, surl, true));
                }
                catch (Exception e) {
                    callbacks.copyFailed(new SRMException(e));
                }
            }
        };
        String id = Storage.getUniqueId();
        logger.debug("putToRemoteTURL assigned id =" + id + "for transfer from " + surl + " to " + remoteTURL);
        this.copyThreads.put(id, t);
        t.start();
        return id;
    }

    @Override
    public void killRemoteTransfer(String transferId) {
        Thread t = (Thread)this.copyThreads.get(transferId);
        if (t == null) {
            logger.debug("killRemoteTransfer: cannot find thread for transfer with id=" + transferId);
        } else {
            logger.debug("killRemoteTransfer: found thread for transfer with id=" + transferId + ", killing");
            t.interrupt();
        }
    }

    public void reserveSpace(SRMUser user, long spaceSize, long reservationLifetime, String filename, String host, ReserveSpaceCallbacks callbacks) {
        callbacks.SpaceReserved("dummy", spaceSize);
    }

    @Override
    public void removeFile(SRMUser user, URI path, RemoveFileCallbacks callbacks) {
    }

    @Override
    public void removeDirectory(SRMUser user, List<URI> surls) throws SRMException {
    }

    @Override
    public void createDirectory(SRMUser user, URI directory) throws SRMException {
    }

    @Override
    public List<URI> listNonLinkedDirectory(SRMUser user, URI surl) throws SRMException {
        String directoryName = this.getPath(surl);
        FileMetaData fmd = this._getFileMetaData(user, directoryName);
        int uid = Integer.parseInt(fmd.owner);
        int gid = Integer.parseInt(fmd.group);
        int permissions = fmd.permMode;
        if (permissions == 0) {
            throw new SRMException("permission denied");
        }
        if (!Permissions.worldCanRead(permissions)) {
            throw new SRMException("permission denied");
        }
        if (uid == -1 || gid == -1) {
            throw new SRMException("permission denied");
        }
        if (user == null) {
            throw new SRMException("permission denied");
        }
        if (!fmd.isGroupMember(user) || !Permissions.groupCanRead(permissions)) {
            throw new SRMException("permission denied");
        }
        if (!fmd.isOwner(user) || !Permissions.userCanRead(permissions)) {
            throw new SRMException("permission denied");
        }
        File f = new File(directoryName);
        if (!f.isDirectory()) {
            throw new SRMException("not a directory");
        }
        String base = this.addTrailingSlash(surl.toString());
        ArrayList<URI> result = new ArrayList<URI>();
        for (String file : f.list()) {
            result.add(URI.create(base + file));
        }
        return result;
    }

    @Override
    public List<URI> listDirectory(SRMUser user, URI surl, FileMetaData fileMetaData) throws SRMException {
        String directoryName = this.getPath(surl);
        FileMetaData fmd = this._getFileMetaData(user, directoryName);
        int uid = Integer.parseInt(fmd.owner);
        int gid = Integer.parseInt(fmd.group);
        int permissions = fmd.permMode;
        if (permissions == 0) {
            throw new SRMException("permission denied");
        }
        if (Permissions.worldCanRead(permissions)) {
            throw new SRMException("permission denied");
        }
        if (uid == -1 || gid == -1) {
            throw new SRMException("permission denied");
        }
        if (user == null) {
            throw new SRMException("permission denied");
        }
        if (fmd.isGroupMember(user) && Permissions.groupCanRead(permissions)) {
            throw new SRMException("permission denied");
        }
        if (fmd.isOwner(user) && Permissions.userCanRead(permissions)) {
            throw new SRMException("permission denied");
        }
        File f = new File(directoryName);
        if (!f.isDirectory()) {
            throw new SRMException("not a directory");
        }
        String base = this.addTrailingSlash(surl.toString());
        ArrayList<URI> result = new ArrayList<URI>();
        for (String file : f.list()) {
            result.add(URI.create(base + file));
        }
        return result;
    }

    @Override
    public List<FileMetaData> listDirectory(SRMUser user, URI surl, boolean verbose, int offset, int count) throws SRMException {
        List<URI> list = this.listDirectory(user, surl, null);
        ArrayList<FileMetaData> result = new ArrayList<FileMetaData>();
        for (int i = offset; i < list.size() && i < offset + count; ++i) {
            result.add(this.getFileMetaData(user, list.get(i), false));
        }
        return result;
    }

    @Override
    public void moveEntry(SRMUser user, URI from, URI to) throws SRMException {
    }

    @Override
    public void srmReserveSpace(SRMUser user, long sizeInBytes, long spaceReservationLifetime, String retentionPolicy, String accessLatency, String description, SrmReserveSpaceCallbacks callbacks) {
    }

    @Override
    public void srmUnmarkSpaceAsBeingUsed(SRMUser user, String spaceToken, URI surl, SrmCancelUseOfSpaceCallbacks callbacks) {
    }

    @Override
    public void srmReleaseSpace(SRMUser user, String spaceToken, Long sizeInBytes, SrmReleaseSpaceCallbacks callbacks) {
    }

    @Override
    public void srmMarkSpaceAsBeingUsed(SRMUser user, String spaceToken, URI surl, long sizeInBytes, long useLifetime, boolean overwrite, SrmUseSpaceCallbacks callbacks) {
    }

    @Override
    public TMetaDataSpace[] srmGetSpaceMetaData(SRMUser user, String[] spaceTokens) throws SRMException {
        return null;
    }

    @Override
    public String[] srmGetSpaceTokens(SRMUser user, String description) throws SRMException {
        return null;
    }

    @Override
    public String[] srmGetRequestTokens(SRMUser user, String description) throws SRMException {
        return null;
    }

    @Override
    public int srmExtendSurlLifetime(SRMUser user, URI surl, int newLifetime) throws SRMException {
        FileMetaData fmd = this.getFileMetaData(user, surl, true);
        int uid = Integer.parseInt(fmd.owner);
        int gid = Integer.parseInt(fmd.group);
        int permissions = fmd.permMode;
        if (Permissions.worldCanWrite(permissions)) {
            return -1;
        }
        if (uid == -1 || gid == -1) {
            throw new SRMAuthorizationException("User is not authorized to modify this file");
        }
        if (user == null || !(user instanceof UnixfsUser)) {
            throw new SRMAuthorizationException("User is not authorized to modify this file");
        }
        UnixfsUser duser = (UnixfsUser)user;
        if (duser.getGid() == gid && Permissions.groupCanWrite(permissions)) {
            return -1;
        }
        if (duser.getUid() == uid && Permissions.userCanWrite(permissions)) {
            return -1;
        }
        throw new SRMAuthorizationException("User is not authorized to modify this file");
    }

    @Override
    public long extendPinLifetime(SRMUser user, String fileId, String pinId, long newPinLifetime) throws SRMException {
        return newPinLifetime;
    }

    @Override
    public long srmExtendReservationLifetime(SRMUser user, String spaceToken, long newReservationLifetime) throws SRMException {
        return newReservationLifetime;
    }

    @Override
    public String getStorageBackendVersion() {
        return "$Revision: 1.35 $";
    }

    @Override
    public void unPinFileBySrmRequestId(SRMUser user, String fileId, UnpinCallbacks callbacks, long srmRequestId) {
        callbacks.Unpinned(fileId);
    }

    @Override
    public void unPinFile(SRMUser user, String fileId, UnpinCallbacks callbacks) {
        callbacks.Unpinned(fileId);
    }

    @Override
    public boolean exists(SRMUser user, URI surl) throws SRMException {
        return true;
    }

    private String addTrailingSlash(String s) {
        if (!s.endsWith("/")) {
            s = s + "/";
        }
        return s;
    }

    private String getPath(URI surl) throws SRMInvalidPathException {
        try {
            String path = surl.getPath();
            String scheme = surl.getScheme();
            if (scheme != null) {
                if (!scheme.equalsIgnoreCase("srm")) {
                    throw new SRMInvalidPathException("Invalid scheme: " + scheme);
                }
                if (!Tools.sameHost(this.config.getSrmHosts(), surl.getHost())) {
                    throw new SRMInvalidPathException("SURL is not local: " + surl);
                }
                int i = path.indexOf(SFN_STRING);
                if (i != -1) {
                    path = path.substring(i + SFN_STRING.length());
                }
            }
            return path;
        }
        catch (UnknownHostException e) {
            throw new SRMInvalidPathException(e.getMessage());
        }
    }
}

