/*
 * Decompiled with CFR 0.152.
 */
package org.dcache.srm.unixfs;

import dmg.util.Args;
import dmg.util.CommandInterpreter;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileOutputStream;
import java.io.InputStreamReader;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.sql.SQLException;
import org.dcache.srm.SRM;
import org.dcache.srm.SRMAuthorization;
import org.dcache.srm.unixfs.Configuration;
import org.dcache.srm.unixfs.Storage;
import org.dcache.srm.unixfs.UnixfsAuthorization;

public class Main
extends CommandInterpreter
implements Runnable {
    private Configuration config;
    private SRMAuthorization authorization;
    private SRM srm;
    private String name;
    public String fh_cancel = " Syntax: cancel <id> ";
    public String hh_cancel = " <id> ";
    public String fh_ls = " Syntax: ls [-get] [-put] [-copy] [-l] [<id>] #will list all requests";
    public String hh_ls = " [-get] [-put] [-copy] [-l] [<id>]";
    public String fh_ls_queues = " Syntax: ls queues [-get] [-put] [-copy] [-l]  #will list schedule queues";
    public String hh_ls_queues = " [-get] [-put] [-copy] [-l] ";
    public String fh_ls_completed = " Syntax: ls completed [-get] [-put] [-copy] [-l] [max_count] #will list completed (done, failed or canceled) requests, if max_count is not specified, it is set to 50";
    public String hh_ls_completed = " [-get] [-put] [-copy] [-l] [max_count]";
    public String hh_info = "[-l|-a]";
    public String fh_exit = " Syntax: exit  #will stop the server and exit the shell";
    public String hh_exit = " ";

    public Main(String[] args) throws Exception {
        PrintStream err;
        PrintStream out;
        String config_file = args[0];
        this.name = args[1];
        File f = new File(config_file);
        if (!f.exists()) {
            Configuration configuration = new Configuration();
            configuration.write(config_file);
            System.out.println("configuration written to a file: " + config_file);
            return;
        }
        String gridftphost = args[2];
        int gridftpport = Integer.parseInt(args[3]);
        String stat = args[4];
        String chown = args[5];
        System.out.println("reading configuration from " + config_file);
        this.config = new Configuration(config_file);
        if (args.length > 6) {
            String logfile = args[6];
            System.out.println("Logging to " + logfile);
            err = out = new PrintStream(new FileOutputStream(logfile));
        } else {
            System.out.println("Logging to stdout and stderr");
            out = System.out;
            err = System.err;
        }
        this.authorization = UnixfsAuthorization.getAuthorization(this.config.getKpwdfile());
        this.config.setAuthorization(this.authorization);
        Storage storage = new Storage(gridftphost, gridftpport, this.config, stat, chown, out, err);
        this.config.setStorage(storage);
        this.srm = SRM.getSRM(this.config, this.name);
        new Thread(this).start();
    }

    @Override
    public void run() {
        for (int failures = 0; failures < 100; ++failures) {
            try {
                BufferedReader br = new BufferedReader(new InputStreamReader(System.in));
                String nextCommand = null;
                System.out.println("<<<<Welcome to srm server admin shell>>>");
                System.out.println("type help to begin");
                System.out.print("[srm server " + this.name + " ]# ");
                while ((nextCommand = br.readLine()) != null) {
                    System.out.println("Interpeting command : " + nextCommand);
                    try {
                        System.out.println(this.command(nextCommand));
                    }
                    catch (Throwable t) {
                        t.printStackTrace();
                    }
                    System.out.print("[srm server " + this.name + " ]# ");
                }
                return;
            }
            catch (Exception e) {
                e.printStackTrace();
                continue;
            }
        }
        System.err.println("too many falures, exiting command interpreter loop");
    }

    public static void main(String[] args) throws Exception {
        if (args == null || args.length < 6 || args[0].equalsIgnoreCase("-h") || args[0].equalsIgnoreCase("-help") || args[0].equalsIgnoreCase("--h") || args[0].equalsIgnoreCase("--help")) {
            System.err.println("Usage: java [-classpath <CLASSPATH to all srm jars>] org.dcache.srm.unixfs  <configuration file> <instance_name> <gridftp server host> <gridftp server port> <stat command path> <chown path> [logfile] \n      if configuration file does not exist it will be created and program will exit \n       you can then review the configuration file and restart the program ");
            return;
        }
        new Main(args);
    }

    public void getInfo(PrintWriter printWriter) {
        StringBuilder sb = new StringBuilder();
        sb.append("SRM Cell");
        sb.append(" storage info ");
        sb.append('\n');
        sb.append(this.config.toString()).append('\n');
        try {
            this.srm.printGetSchedulerInfo(sb);
            this.srm.printPutSchedulerInfo(sb);
            this.srm.printCopySchedulerInfo(sb);
        }
        catch (SQLException sqle) {
            sqle.printStackTrace(printWriter);
        }
        printWriter.println(sb.toString());
    }

    public String getInfo() {
        StringWriter stringWriter = new StringWriter();
        PrintWriter printWriter = new PrintWriter(stringWriter);
        this.getInfo(printWriter);
        printWriter.flush();
        return stringWriter.getBuffer().toString();
    }

    public String ac_cancel_$_1(Args args) {
        try {
            Long id = new Long(args.argv(0));
            StringBuilder sb = new StringBuilder();
            this.srm.cancelRequest(sb, id);
            return sb.toString();
        }
        catch (Exception e) {
            return e.toString();
        }
    }

    public String ac_ls_$_0_1(Args args) {
        try {
            boolean get = args.hasOption("get");
            boolean put = args.hasOption("put");
            boolean copy = args.hasOption("copy");
            boolean longformat = args.hasOption("l");
            StringBuilder sb = new StringBuilder();
            if (args.argc() == 1) {
                try {
                    Long reqId = new Long(args.argv(0));
                    this.srm.listRequest(sb, reqId, longformat);
                }
                catch (NumberFormatException nfe) {
                    return "id must be a nonnegative integer, you gave id=" + args.argv(0);
                }
            } else {
                if (!(get || put || copy)) {
                    get = true;
                    put = true;
                    copy = true;
                }
                if (get) {
                    sb.append("Get Requests:\n");
                    this.srm.listGetRequests(sb);
                    sb.append('\n');
                }
                if (put) {
                    sb.append("Put Requests:\n");
                    this.srm.listPutRequests(sb);
                    sb.append('\n');
                }
                if (copy) {
                    sb.append("Copy Requests:\n");
                    this.srm.listCopyRequests(sb);
                    sb.append('\n');
                }
            }
            return sb.toString();
        }
        catch (Throwable t) {
            t.printStackTrace();
            return t.toString();
        }
    }

    public String ac_ls_queues_$_0(Args args) {
        try {
            boolean get = args.hasOption("get");
            boolean put = args.hasOption("put");
            boolean copy = args.hasOption("copy");
            boolean longformat = args.hasOption("l");
            StringBuilder sb = new StringBuilder();
            if (!(get || put || copy)) {
                get = true;
                put = true;
                copy = true;
            }
            if (get) {
                sb.append("Get Request Scheduler:\n");
                this.srm.printGetSchedulerThreadQueue(sb);
                this.srm.printGetSchedulerPriorityThreadQueue(sb);
                this.srm.printCopySchedulerReadyThreadQueue(sb);
                sb.append('\n');
            }
            if (put) {
                sb.append("Put Request Scheduler:\n");
                this.srm.printPutSchedulerThreadQueue(sb);
                this.srm.printPutSchedulerPriorityThreadQueue(sb);
                this.srm.printPutSchedulerReadyThreadQueue(sb);
                sb.append('\n');
            }
            if (copy) {
                sb.append("Copy Request Scheduler:\n");
                this.srm.printCopySchedulerThreadQueue(sb);
                this.srm.printCopySchedulerPriorityThreadQueue(sb);
                this.srm.printCopySchedulerReadyThreadQueue(sb);
                sb.append('\n');
            }
            return sb.toString();
        }
        catch (Throwable t) {
            t.printStackTrace();
            return t.toString();
        }
    }

    public String ac_ls_completed_$_0_1(Args args) throws Exception {
        boolean get = args.hasOption("get");
        boolean put = args.hasOption("put");
        boolean copy = args.hasOption("copy");
        boolean longformat = args.hasOption("l");
        int max_count = 50;
        if (args.argc() == 1) {
            max_count = Integer.parseInt(args.argv(0));
        }
        if (!(get || put || copy)) {
            get = true;
            put = true;
            copy = true;
        }
        StringBuilder sb = new StringBuilder();
        if (get) {
            sb.append("Get Requests:\n");
            this.srm.listLatestCompletedGetRequests(sb, max_count);
            sb.append('\n');
        }
        if (put) {
            sb.append("Put Requests:\n");
            this.srm.listLatestCompletedPutRequests(sb, max_count);
            sb.append('\n');
        }
        if (copy) {
            sb.append("Copy Requests:\n");
            this.srm.listLatestCompletedCopyRequests(sb, max_count);
            sb.append('\n');
        }
        return sb.toString();
    }

    public String ac_info(Args args) throws Exception {
        return this.getInfo();
    }

    public String ac_exit_$_0_1(Args args) throws Exception {
        System.exit(0);
        return "exiting";
    }
}

