/*
 * Decompiled with CFR 0.152.
 */
package org.dcache.srm.server;

import java.io.File;
import java.lang.reflect.Method;
import java.util.List;
import org.dcache.srm.SRM;
import org.dcache.srm.util.Configuration;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.input.SAXBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SrmDCacheConnector {
    private static final Logger _log = LoggerFactory.getLogger(SrmDCacheConnector.class);
    private static final String ERROR_WEB_XML_PREFIX = "Please insert following into your axis' web.xml:\n <env-entry>\n   <env-entry-name> ";
    private static final String ERROR_WEB_XML_POSTFIX = " </env-entry-name>\n     <env-entry-value> ACTUAL VALUE OR FILE NAME GOES HERE </env-entry-value>\n   <env-entry-type>java.lang.String</env-entry-type>\n </env-entry>";
    private SRM srm = null;
    private String logFile;
    static Configuration configuration;
    private Logger log = LoggerFactory.getLogger((String)this.getClass().getName());
    private static SrmDCacheConnector instance;

    public static synchronized SrmDCacheConnector getInstance(String srmConfigFile) throws Exception {
        if (instance != null) {
            return instance;
        }
        instance = new SrmDCacheConnector(srmConfigFile);
        return instance;
    }

    private SrmDCacheConnector(String configFileName) throws Exception {
        String[] dCacheParams;
        SAXBuilder builder = new SAXBuilder();
        _log.debug("srmConfigFile is {}", (Object)configFileName);
        File srmConfigFile = new File(configFileName);
        if (!srmConfigFile.exists() || !srmConfigFile.canRead()) {
            String msg = "can't find srmConfigFile at " + configFileName;
            _log.error(msg);
            throw new IllegalArgumentException(msg);
        }
        Document doc = builder.build(srmConfigFile);
        Element root = doc.getRootElement();
        this.logFile = root.getChildText("logFile");
        if (this.logFile == null) {
            _log.error("logFile value not specified");
            _log.error("Please insert following into {}:", (Object)configFileName);
            _log.error("<SRMConfigInfo>);");
            _log.error("  <dCacheParameter> ACTUAL LOCATION OF DCACHE PARAMS XML GOES HERE, example: /opt/d-cache/libexec/apache-tomcat-5.5.20/webapps/axis/WEB-INF/dCacheParams.xml </dCacheParameter>");
            _log.error("  <logFile> ACTUAL LOCATION OF SRM LOG FILE GOES HERE, example:  /opt/d-cache/libexec/apache-tomcat-5.5.20/webapps/axis/WEB-INF/logconfig </logFile>");
            _log.error("  </SRMConfigInfo>");
            throw new IllegalArgumentException("logFile value not specified");
        }
        this.logFile = this.logFile.trim();
        _log.debug("logFile: " + this.logFile);
        String storageClassName = root.getChildText("storageClassName");
        if (storageClassName == null) {
            _log.error("storageClassName value (diskCacheV111.srm.dcache.Storage or org.dcache.fnal.unixfs.Storage) not specified");
            _log.error("Please insert following into your axis' web.xml:\n <env-entry>\n   <env-entry-name> storageClassName </env-entry-name>\n     <env-entry-value> ACTUAL VALUE OR FILE NAME GOES HERE </env-entry-value>\n   <env-entry-type>java.lang.String</env-entry-type>\n </env-entry>");
            throw new IllegalArgumentException("storageClassName value not specified");
        }
        storageClassName = storageClassName.trim();
        _log.debug("storageClassName: " + storageClassName);
        String dCacheParamFileName = root.getChildText("dCacheParametersFileName");
        if (storageClassName == null) {
            _log.error("dCacheParametersFileName  value not specified");
            _log.error("Please insert following into your axis' web.xml:\n <env-entry>\n   <env-entry-name> dCacheParametersFileName </env-entry-name>\n     <env-entry-value> ACTUAL VALUE OR FILE NAME GOES HERE </env-entry-value>\n   <env-entry-type>java.lang.String</env-entry-type>\n </env-entry>");
            throw new IllegalArgumentException("dCacheParametersFileName value not specified");
        }
        if ((dCacheParamFileName = dCacheParamFileName.trim()).length() == 0) {
            dCacheParams = new String[]{};
        } else {
            _log.debug("dCacheParamFileName: {}", (Object)dCacheParamFileName);
            File dCacheParamFile = new File(dCacheParamFileName);
            if (!dCacheParamFile.exists() || !dCacheParamFile.canRead()) {
                String msg = "can't find dCacheParamFile at " + dCacheParamFileName;
                _log.error(msg);
                throw new IllegalArgumentException(msg);
            }
            builder = new SAXBuilder();
            doc = builder.build(dCacheParamFile);
            root = doc.getRootElement();
            List children = root.getChildren();
            int numChildren = children.size();
            dCacheParams = new String[numChildren];
            int aPos = 0;
            for (Element te : children) {
                _log.debug("dCacheParams Element name: {}; Element value: {}", (Object)te.getName(), (Object)te.getText());
                dCacheParams[aPos++] = te.getText();
            }
        }
        try {
            Class<?> clazz = Class.forName(storageClassName);
            Method tm = clazz.getMethod("getSRMInstance", String[].class, Long.TYPE);
            this.srm = (SRM)tm.invoke(null, dCacheParams, 600000L);
            _log.debug("Got instance of srm.");
            configuration = this.srm.getConfiguration();
        }
        catch (Exception e) {
            _log.error("Problem", (Throwable)e);
            throw e;
        }
    }

    public SRM getSrm() {
        return this.srm;
    }

    public String getLogFile() {
        return this.logFile;
    }

    static {
        instance = null;
    }
}

