/*
 * Decompiled with CFR 0.152.
 */
package org.dcache.srm.server;

import java.net.InetAddress;
import java.util.Collection;
import javax.servlet.http.HttpServletRequest;
import org.apache.axis.MessageContext;
import org.apache.axis.transport.http.HTTPConstants;
import org.dcache.gplazma.util.CertificateUtils;
import org.dcache.srm.SRMAuthorization;
import org.dcache.srm.SRMAuthorizationException;
import org.dcache.srm.SRMUser;
import org.dcache.srm.request.RequestCredential;
import org.dcache.srm.request.RequestCredentialStorage;
import org.dcache.srm.server.SrmDCacheConnector;
import org.dcache.srm.server.UserCredential;
import org.dcache.srm.util.Configuration;
import org.globus.gsi.gssapi.auth.AuthorizationException;
import org.gridforum.jgss.ExtendedGSSContext;
import org.ietf.jgss.GSSContext;
import org.ietf.jgss.GSSCredential;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SrmAuthorizer {
    String storageName;
    String pathToConfigurationXml;
    Object syncObject = new Object();
    public static final String REMOTE_ADDR = "REMOTE_ADDR";
    private SRMAuthorization authorization;
    private RequestCredentialStorage credential_storage;
    private static final Logger log = LoggerFactory.getLogger(SrmAuthorizer.class);
    private Configuration config;

    public SrmAuthorizer(SrmDCacheConnector srmConn) {
        this.initialize(srmConn);
    }

    private synchronized void initialize(SrmDCacheConnector srmConn) {
        try {
            this.config = SrmDCacheConnector.configuration;
            this.authorization = this.config.getAuthorization();
            this.credential_storage = srmConn.getSrm().getRequestCredentialStorage();
            log.debug("Successfully initialized");
        }
        catch (Exception e) {
            e.printStackTrace();
            log.error("Failed to initialize: exception is " + e);
            throw new RuntimeException(e);
        }
    }

    public UserCredential getUserCredentials() throws SRMAuthorizationException {
        try {
            MessageContext mctx = MessageContext.getCurrentContext();
            this.setUpEnv(mctx);
            GSSContext gsscontext = (GSSContext)mctx.getProperty("org.globus.gsi.context");
            if (gsscontext == null) {
                throw new SRMAuthorizationException("cant extract gsscontext from MessageContext, gsscontext is null");
            }
            String secureId = gsscontext.getSrcName().toString();
            log.debug("User ID (secureId) is: " + secureId);
            GSSCredential delegcred = gsscontext.getDelegCred();
            if (delegcred != null) {
                try {
                    log.debug("User credential (delegcred) is: " + delegcred.getName());
                }
                catch (Exception e) {
                    log.debug("Caught occasional (usually harmless) exception when calling delegcred.getName()): ", (Throwable)e);
                }
            }
            UserCredential userCredential = new UserCredential();
            userCredential.secureId = secureId;
            userCredential.context = gsscontext;
            userCredential.credential = delegcred;
            String remote_addr = (String)mctx.getProperty(REMOTE_ADDR);
            userCredential.clientHost = this.config.isClientDNSLookup() ? InetAddress.getByName(remote_addr).getCanonicalHostName() : remote_addr;
            return userCredential;
        }
        catch (SRMAuthorizationException srme) {
            throw srme;
        }
        catch (Exception e) {
            log.error("getUserCredentials failed with exception", (Throwable)e);
            throw new SRMAuthorizationException(e.toString());
        }
    }

    public SRMUser getRequestUser(RequestCredential requestCredential, String role, GSSContext context) throws SRMAuthorizationException {
        MessageContext mctx = MessageContext.getCurrentContext();
        String remoteIP = (String)mctx.getProperty(REMOTE_ADDR);
        SRMUser requestUser = this.authorization.authorize(requestCredential.getId(), requestCredential.getCredentialName(), role, context, remoteIP);
        return requestUser;
    }

    public RequestCredential getRequestCredential(UserCredential userCredential, String role) {
        try {
            log.debug("About to call RequestCredential.getRequestCredential(" + userCredential.secureId + "," + role + ")");
            RequestCredential rc = RequestCredential.getRequestCredential(userCredential.secureId, role);
            log.debug("Received RequestCredential: " + rc);
            if (rc != null) {
                rc.keepBestDelegatedCredential(userCredential.credential);
            } else {
                log.debug("About to create new RequestCredential");
                rc = new RequestCredential(userCredential.secureId, role, userCredential.credential, this.credential_storage);
            }
            rc.saveCredential();
            log.debug("About to return RequestCredential = " + rc);
            return rc;
        }
        catch (Exception e) {
            log.error(e.toString());
            RuntimeException re = new RuntimeException(e.toString());
            log.error("About to throw runtime exception" + re + "generated from " + e);
            throw re;
        }
    }

    private void setUpEnv(MessageContext msgContext) {
        Object tmp = msgContext.getProperty(HTTPConstants.MC_HTTP_SERVLETREQUEST);
        if (tmp == null || !(tmp instanceof HttpServletRequest)) {
            return;
        }
        HttpServletRequest req = (HttpServletRequest)tmp;
        if ((tmp = req.getAttribute("org.globus.gsi.context")) != null) {
            msgContext.setProperty("org.globus.gsi.context", tmp);
        }
        if ((tmp = req.getRemoteAddr()) != null) {
            msgContext.setProperty(REMOTE_ADDR, tmp);
        }
    }

    public static Collection<String> getFQANsFromContext(ExtendedGSSContext gssContext) throws SRMAuthorizationException {
        try {
            return CertificateUtils.getFQANsFromGSSContext((ExtendedGSSContext)gssContext);
        }
        catch (AuthorizationException ae) {
            log.error("Could not extract FQANs from context", (Throwable)ae);
            throw new SRMAuthorizationException("Could not extract FQANs from context " + ae.getMessage());
        }
    }

    public static String getFormattedAuthRequestID(long id) {
        String idstr = String.valueOf(id);
        while (idstr.length() < 10) {
            idstr = " " + idstr;
        }
        return idstr;
    }
}

