/*
 * Decompiled with CFR 0.152.
 */
package org.dcache.srm.security;

import java.net.InetAddress;
import java.net.Socket;
import org.globus.gsi.GSIConstants;
import org.globus.gsi.GlobusCredential;
import org.globus.gsi.GlobusCredentialException;
import org.globus.gsi.TrustedCertificates;
import org.globus.gsi.gssapi.GSSConstants;
import org.globus.gsi.gssapi.GlobusGSSCredentialImpl;
import org.globus.gsi.gssapi.auth.Authorization;
import org.globus.gsi.gssapi.auth.HostAuthorization;
import org.globus.gsi.gssapi.net.impl.GSIGssSocket;
import org.gridforum.jgss.ExtendedGSSContext;
import org.gridforum.jgss.ExtendedGSSManager;
import org.ietf.jgss.GSSContext;
import org.ietf.jgss.GSSCredential;
import org.ietf.jgss.GSSException;
import org.ietf.jgss.GSSManager;
import org.ietf.jgss.GSSName;

public class SslGsiSocketFactory {
    private static GlobusCredential service_cred;
    private static TrustedCertificates trusted_certs;

    public static GSSCredential getServiceCredential(String x509ServiceCert, String x509ServiceKey, int usage) throws GSSException {
        try {
            if (service_cred != null) {
                service_cred.verify();
            }
        }
        catch (GlobusCredentialException gce) {
            service_cred = null;
        }
        if (service_cred == null) {
            try {
                service_cred = new GlobusCredential(x509ServiceCert, x509ServiceKey);
            }
            catch (GlobusCredentialException gce) {
                throw new GSSException(13, 0, "could not load host globus credentials " + gce.toString());
            }
        }
        GlobusGSSCredentialImpl cred = new GlobusGSSCredentialImpl(service_cred, usage);
        return cred;
    }

    public static GSSContext getServiceContext(String x509ServiceCert, String x509ServiceKey, String x509TrastedCACerts) throws GSSException {
        GSSCredential cred = SslGsiSocketFactory.getServiceCredential(x509ServiceCert, x509ServiceKey, 2);
        if (trusted_certs == null) {
            trusted_certs = TrustedCertificates.load((String)x509TrastedCACerts);
        }
        GSSManager manager = ExtendedGSSManager.getInstance();
        ExtendedGSSContext context = (ExtendedGSSContext)manager.createContext(cred);
        context.setOption(GSSConstants.GSS_MODE, (Object)GSIConstants.MODE_GSI);
        context.setOption(GSSConstants.TRUSTED_CERTIFICATES, (Object)trusted_certs);
        return context;
    }

    public static GSSCredential createUserCredential(String x509UserProxy) throws GlobusCredentialException, GSSException {
        if (x509UserProxy != null) {
            GlobusCredential gcred = new GlobusCredential(x509UserProxy);
            GlobusGSSCredentialImpl cred = new GlobusGSSCredentialImpl(gcred, 1);
            return cred;
        }
        GlobusCredential gcred = GlobusCredential.getDefaultCredential();
        GlobusGSSCredentialImpl cred = new GlobusGSSCredentialImpl(gcred, 1);
        return cred;
    }

    public static GSSCredential createUserCredential(String x509ServiceCert, String x509ServiceKey) throws GlobusCredentialException, GSSException {
        if (x509ServiceCert != null && x509ServiceKey != null) {
            GlobusCredential gcred = new GlobusCredential(x509ServiceCert, x509ServiceKey);
            GlobusGSSCredentialImpl cred = new GlobusGSSCredentialImpl(gcred, 1);
            return cred;
        }
        GlobusCredential gcred = GlobusCredential.getDefaultCredential();
        GlobusGSSCredentialImpl cred = new GlobusGSSCredentialImpl(gcred, 1);
        return cred;
    }

    public static GSSCredential createUserCredential(String x509UserProxy, String x509ServiceCert, String x509ServiceKey) throws GlobusCredentialException, GSSException {
        if (x509UserProxy != null) {
            return SslGsiSocketFactory.createUserCredential(x509UserProxy);
        }
        if (x509ServiceCert != null && x509ServiceKey != null) {
            return SslGsiSocketFactory.createUserCredential(x509ServiceCert, x509ServiceKey);
        }
        GlobusCredential gcred = GlobusCredential.getDefaultCredential();
        GlobusGSSCredentialImpl cred = new GlobusGSSCredentialImpl(gcred, 1);
        return cred;
    }

    public static GSIGssSocket delegateCredential(InetAddress inetAddress, int port, GSSCredential credential, boolean fulldelegation) throws Exception {
        Socket s = null;
        GSIGssSocket gsiSocket = null;
        try {
            GSSManager manager = ExtendedGSSManager.getInstance();
            HostAuthorization gssAuth = HostAuthorization.getInstance();
            GSSName targetName = gssAuth.getExpectedName(null, inetAddress.getCanonicalHostName());
            ExtendedGSSContext context = (ExtendedGSSContext)manager.createContext(targetName, GSSConstants.MECH_OID, credential, 0);
            context.setOption(GSSConstants.GSS_MODE, (Object)GSIConstants.MODE_GSI);
            context.requestCredDeleg(true);
            if (fulldelegation) {
                context.setOption(GSSConstants.DELEGATION_TYPE, (Object)GSIConstants.DELEGATION_TYPE_FULL);
            } else {
                context.setOption(GSSConstants.DELEGATION_TYPE, (Object)GSIConstants.DELEGATION_TYPE_LIMITED);
            }
            s = new Socket(inetAddress, port);
            gsiSocket = new GSIGssSocket(s, (GSSContext)context);
            gsiSocket.setUseClientMode(true);
            gsiSocket.setAuthorization((Authorization)gssAuth);
            gsiSocket.setWrapMode(1);
            gsiSocket.startHandshake();
        }
        catch (Exception e) {
            if (s != null) {
                try {
                    s.close();
                }
                catch (Exception e1) {
                    // empty catch block
                }
            }
            throw e;
        }
        return gsiSocket;
    }
}

