/*
 * Decompiled with CFR 0.152.
 */
package org.dcache.srm.scheduler;

public enum State {
    PENDING("Pending", 0),
    PRIORITYTQUEUED("PriorityTQueued", 1),
    TQUEUED("TQueued", 2),
    RUNNING("Running", 3),
    RETRYWAIT("RetryWait", 4),
    ASYNCWAIT("AsyncWait", 5),
    RQUEUED("RQueued", 6),
    READY("Ready", 7),
    TRANSFERRING("Transferring", 8),
    DONE("Done", 9, true),
    CANCELED("Canceled", 10, true),
    FAILED("Failed", 11, true),
    RESTORED("Restored", 12),
    RUNNINGWITHOUTTHREAD("RunningWithoutThread", 13);

    private final String name;
    private final int stateId;
    private final boolean isFinal;
    private static final long serialVersionUID = 4561665427863772427L;

    private State(String name, int stateId) {
        this(name, stateId, false);
    }

    private State(String name, int stateId, boolean isFinal) {
        this.name = name;
        this.stateId = stateId;
        this.isFinal = isFinal;
    }

    public String toString() {
        return this.name;
    }

    public int getStateId() {
        return this.stateId;
    }

    public static State getState(String state) throws IllegalArgumentException {
        if (state == null || state.equalsIgnoreCase("null")) {
            throw new NullPointerException(" null state ");
        }
        for (State aState : State.values()) {
            if (!aState.name.equalsIgnoreCase(state)) continue;
            return aState;
        }
        try {
            int stateId = Integer.parseInt(state);
            return State.getState(stateId);
        }
        catch (NumberFormatException nfe) {
            throw new IllegalArgumentException("Unknown State:" + state);
        }
    }

    public static State getState(int stateId) throws IllegalArgumentException {
        for (State aState : State.values()) {
            if (aState.stateId != stateId) continue;
            return aState;
        }
        throw new IllegalArgumentException("Unknown State Id:" + stateId);
    }

    public static boolean isFinalState(State state) {
        return state.isFinal;
    }

    public boolean isFinalState() {
        return this.isFinal;
    }
}

