/*
 * Decompiled with CFR 0.152.
 */
package org.dcache.srm.scheduler;

import java.sql.Connection;
import java.sql.SQLException;
import java.util.Set;
import org.dcache.srm.scheduler.Job;
import org.dcache.srm.scheduler.JobStorage;
import org.dcache.srm.scheduler.State;

public class FinalStateOnlyJobStorageDecorator
implements JobStorage {
    private final JobStorage jobStorage;

    public FinalStateOnlyJobStorageDecorator(JobStorage jobStorage) {
        this.jobStorage = jobStorage;
    }

    @Override
    public Job getJob(Long jobId) throws SQLException {
        return this.jobStorage.getJob(jobId);
    }

    @Override
    public Job getJob(Long jobId, Connection connection) throws SQLException {
        return this.jobStorage.getJob(jobId, connection);
    }

    @Override
    public Set getJobs(String scheduler) throws SQLException {
        return this.jobStorage.getJobs(scheduler);
    }

    @Override
    public Set getJobs(String scheduler, State state) throws SQLException {
        return this.jobStorage.getJobs(scheduler, state);
    }

    @Override
    public void saveJob(Job job, boolean saveIfMonitoringDisabled) throws SQLException {
        if (job == null) {
            throw new NullPointerException("job is null");
        }
        if (job.getState().isFinalState()) {
            this.jobStorage.saveJob(job, saveIfMonitoringDisabled);
        }
    }

    @Override
    public boolean isJdbcLogRequestHistoryInDBEnabled() {
        return this.jobStorage.isJdbcLogRequestHistoryInDBEnabled();
    }
}

