/*
 * Decompiled with CFR 0.152.
 */
package org.dcache.srm.request.sql;

import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.HashSet;
import org.dcache.srm.SRMUser;
import org.dcache.srm.request.ContainerRequest;
import org.dcache.srm.request.FileRequest;
import org.dcache.srm.request.PutRequest;
import org.dcache.srm.request.sql.DatabaseContainerRequestStorage;
import org.dcache.srm.scheduler.Job;
import org.dcache.srm.util.Configuration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PutRequestStorage
extends DatabaseContainerRequestStorage {
    private static final Logger logger = LoggerFactory.getLogger(PutRequestStorage.class);
    public static final String TABLE_NAME = "putrequests";
    private static final String UPDATE_PREFIX = "UPDATE putrequests SET NEXTJOBID=?, CREATIONTIME=?,  LIFETIME=?, STATE=?, ERRORMESSAGE=?, SCHEDULERID=?, SCHEDULERTIMESTAMP=?,NUMOFRETR=?,MAXNUMOFRETR=?,LASTSTATETRANSITIONTIME=? ";
    private static final String INSERT_SQL = "INSERT INTO putrequests(    ID ,NEXTJOBID ,CREATIONTIME ,LIFETIME ,STATE ,ERRORMESSAGE ,SCHEDULERID ,SCHEDULERTIMESTAMP ,NUMOFRETR ,MAXNUMOFRETR ,LASTSTATETRANSITIONTIME,CREDENTIALID , RETRYDELTATIME , SHOULDUPDATERETRYDELTATIME ,DESCRIPTION ,CLIENTHOST ,STATUSCODE ,USERID  ) VALUES (?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?)";
    private static final String UPDATE_REQUEST_SQL = "UPDATE putrequests SET NEXTJOBID=?, CREATIONTIME=?,  LIFETIME=?, STATE=?, ERRORMESSAGE=?, SCHEDULERID=?, SCHEDULERTIMESTAMP=?,NUMOFRETR=?,MAXNUMOFRETR=?,LASTSTATETRANSITIONTIME=? , CREDENTIALID=?, RETRYDELTATIME=?, SHOULDUPDATERETRYDELTATIME=?, DESCRIPTION=?, CLIENTHOST=?, STATUSCODE=?, USERID=? WHERE ID=?";
    private static int ADDITIONAL_FIELDS = 0;
    private final String insertProtocols = "INSERT INTO " + this.getProtocolsTableName() + " (PROTOCOL, RequestID) " + " VALUES (?,?)";

    @Override
    public PreparedStatement getCreateStatement(Connection connection, Job job) throws SQLException {
        PutRequest pr = (PutRequest)job;
        PreparedStatement stmt = this.getPreparedStatement(connection, INSERT_SQL, pr.getId(), pr.getNextJobId(), pr.getCreationTime(), pr.getLifetime(), pr.getState().getStateId(), pr.getErrorMessage(), pr.getSchedulerId(), pr.getSchedulerTimeStamp(), pr.getNumberOfRetries(), pr.getMaxNumberOfRetries(), pr.getLastStateTransitionTime(), pr.getCredentialId(), pr.getRetryDeltaTime(), pr.isShould_updateretryDeltaTime() ? 0 : 1, pr.getDescription(), pr.getClient_host(), pr.getStatusCodeString(), pr.getUser().getId());
        return stmt;
    }

    @Override
    public PreparedStatement getUpdateStatement(Connection connection, Job job) throws SQLException {
        PutRequest pr = (PutRequest)job;
        PreparedStatement stmt = this.getPreparedStatement(connection, UPDATE_REQUEST_SQL, pr.getNextJobId(), pr.getCreationTime(), pr.getLifetime(), pr.getState().getStateId(), pr.getErrorMessage(), pr.getSchedulerId(), pr.getSchedulerTimeStamp(), pr.getNumberOfRetries(), pr.getMaxNumberOfRetries(), pr.getLastStateTransitionTime(), pr.getCredentialId(), pr.getRetryDeltaTime(), pr.isShould_updateretryDeltaTime() ? 0 : 1, pr.getDescription(), pr.getClient_host(), pr.getStatusCodeString(), pr.getUser().getId(), pr.getId());
        return stmt;
    }

    public PutRequestStorage(Configuration.DatabaseParameters configuration) throws SQLException {
        super(configuration);
    }

    private String getProtocolsTableName() {
        return this.getTableName() + "_protocols";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void dbInit1() throws SQLException {
        boolean should_reanamed_old_table = this.reanamed_old_table;
        String protocolsTableName = this.getProtocolsTableName().toLowerCase();
        Connection _con = null;
        try {
            _con = this.pool.getConnection();
            _con.setAutoCommit(true);
            DatabaseMetaData md = _con.getMetaData();
            ResultSet columns = md.getColumns(null, null, protocolsTableName, null);
            if (columns.next()) {
                String columnName = columns.getString("COLUMN_NAME");
                int columnDataType = columns.getInt("DATA_TYPE");
                this.verifyStringType("PROTOCOL", 1, protocolsTableName, columnName, columnDataType);
                if (columns.next()) {
                    columnName = columns.getString("COLUMN_NAME");
                    columnDataType = columns.getInt("DATA_TYPE");
                    this.verifyLongType("RequestID", 2, protocolsTableName, columnName, columnDataType);
                } else {
                    should_reanamed_old_table = true;
                }
            }
            _con.setAutoCommit(false);
            this.pool.returnConnection(_con);
            _con = null;
        }
        catch (SQLException sqe) {
            logger.error(sqe.toString());
            should_reanamed_old_table = true;
            if (_con != null) {
                this.pool.returnFailedConnection(_con);
                _con = null;
            }
        }
        catch (Exception ex) {
            logger.error(ex.toString());
            should_reanamed_old_table = true;
            if (_con != null) {
                this.pool.returnFailedConnection(_con);
                _con = null;
            }
        }
        finally {
            if (_con != null) {
                _con.setAutoCommit(false);
                this.pool.returnConnection(_con);
            }
        }
        try {
            if (should_reanamed_old_table) {
                this.renameTable(protocolsTableName);
            }
        }
        catch (SQLException sqle) {
            logger.error("renameTable  " + protocolsTableName + " failed, might have been removed already, ignoring");
        }
        String createProtocolsTable = "CREATE TABLE " + protocolsTableName + " ( " + " PROTOCOL " + " VARCHAR(32672) " + "," + " RequestID " + " BIGINT " + ", " + " CONSTRAINT fk_" + this.getTableName() + "_PP FOREIGN KEY (RequestID) REFERENCES " + this.getTableName() + " (ID) " + " ON DELETE CASCADE" + " )";
        logger.debug("calling createTable for " + protocolsTableName);
        this.createTable(protocolsTableName, createProtocolsTable);
        String[] protocols_columns = new String[]{"RequestID"};
        this.createIndex(protocols_columns, protocolsTableName);
    }

    @Override
    public void getCreateList(ContainerRequest r, StringBuffer sb) {
    }

    @Override
    protected ContainerRequest getContainerRequest(Connection _con, Long ID, Long NEXTJOBID, long CREATIONTIME, long LIFETIME, int STATE, String ERRORMESSAGE, SRMUser user, String SCHEDULERID, long SCHEDULER_TIMESTAMP, int NUMOFRETR, int MAXNUMOFRETR, long LASTSTATETRANSITIONTIME, Long CREDENTIALID, int RETRYDELTATIME, boolean SHOULDUPDATERETRYDELTATIME, String DESCRIPTION, String CLIENTHOST, String STATUSCODE, FileRequest[] fileRequests, ResultSet set, int next_index) throws SQLException {
        String sqlStatementString = "SELECT PROTOCOL FROM " + this.getProtocolsTableName() + " WHERE RequestID=" + ID;
        Statement sqlStatement = _con.createStatement();
        logger.debug("executing statement: " + sqlStatementString);
        ResultSet fileIdsSet = sqlStatement.executeQuery(sqlStatementString);
        HashSet<String> utilset = new HashSet<String>();
        while (fileIdsSet.next()) {
            utilset.add(fileIdsSet.getString(1));
        }
        String[] protocols = utilset.toArray(new String[0]);
        sqlStatement.close();
        Job.JobHistory[] jobHistoryArray = this.getJobHistory(ID, _con);
        return new PutRequest(ID, NEXTJOBID, CREATIONTIME, LIFETIME, STATE, ERRORMESSAGE, user, SCHEDULERID, SCHEDULER_TIMESTAMP, NUMOFRETR, MAXNUMOFRETR, LASTSTATETRANSITIONTIME, jobHistoryArray, CREDENTIALID, fileRequests, RETRYDELTATIME, SHOULDUPDATERETRYDELTATIME, DESCRIPTION, CLIENTHOST, STATUSCODE, protocols);
    }

    @Override
    public String getRequestCreateTableFields() {
        return "";
    }

    @Override
    public String getTableName() {
        return TABLE_NAME;
    }

    public void getUpdateAssignements(ContainerRequest r, StringBuffer sb) {
    }

    @Override
    public PreparedStatement[] getAdditionalCreateStatements(Connection connection, Job job) throws SQLException {
        if (job == null || !(job instanceof PutRequest)) {
            throw new IllegalArgumentException("Request is not PutRequest");
        }
        PutRequest pr = (PutRequest)job;
        String[] protocols = pr.getProtocols();
        if (protocols == null) {
            return null;
        }
        PreparedStatement[] statements = new PreparedStatement[protocols.length];
        for (int i = 0; i < protocols.length; ++i) {
            statements[i] = this.getPreparedStatement(connection, this.insertProtocols, protocols[i], pr.getId());
        }
        return statements;
    }

    @Override
    public String getFileRequestsTableName() {
        return "putfilerequests";
    }

    @Override
    protected void __verify(int nextIndex, int columnIndex, String tableName, String columnName, int columnType) throws SQLException {
    }

    @Override
    protected int getMoreCollumnsNum() {
        return ADDITIONAL_FIELDS;
    }
}

