/*
 * Decompiled with CFR 0.152.
 */
package org.dcache.srm.request.sql;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStreamWriter;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import org.dcache.srm.request.RequestCredential;
import org.dcache.srm.request.RequestCredentialStorage;
import org.dcache.srm.request.sql.JdbcConnectionPool;
import org.dcache.srm.util.Configuration;
import org.globus.gsi.GlobusCredential;
import org.globus.gsi.gssapi.GlobusGSSCredentialImpl;
import org.gridforum.jgss.ExtendedGSSCredential;
import org.ietf.jgss.GSSCredential;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DatabaseRequestCredentialStorage
implements RequestCredentialStorage {
    private static final Logger logger = LoggerFactory.getLogger(DatabaseRequestCredentialStorage.class);
    private final String jdbcUrl;
    private final String jdbcClass;
    private final String user;
    private final String pass;
    private final Configuration configuration;
    protected static final String stringType = " VARCHAR(32672)  ";
    protected static final String longType = " BIGINT ";
    protected static final String intType = " INTEGER ";
    protected static final String dateTimeType = " TIMESTAMP ";
    protected static final String booleanType = " INT ";
    private final String credentialsDirectory;
    public static final String requestCredentialTableName = "srmrequestcredentials";
    public static final String createRequestCredentialTable = "CREATE TABLE srmrequestcredentials ( id  BIGINT  NOT NULL PRIMARY KEY,creationtime  BIGINT ,credentialname  VARCHAR(32672)  ,role  VARCHAR(32672)  ,numberofusers  INTEGER ,delegatedcredentials  VARCHAR(32672)  ,credentialexpiration  BIGINT  )";
    JdbcConnectionPool pool;
    public static final String INSERT = "INSERT INTO srmrequestcredentials (id, creationtime, credentialname, role, numberofusers, delegatedcredentials, credentialexpiration)  VALUES ( ?,?,?,?,?,?,?) ";
    public static final String SELECT = "SELECT * FROM srmrequestcredentials WHERE ";
    public static final String SELECT_BY_ID = "SELECT * FROM srmrequestcredentials WHERE id=?";
    public static final String SELECT_BY_NAME = "SELECT * FROM srmrequestcredentials WHERE credentialname=? and role is null";
    public static final String SELECT_BY_NAME_AND_ROLE = "SELECT * FROM srmrequestcredentials WHERE credentialname=? and role=?";
    private static final String UPDATE = "UPDATE srmrequestcredentials SET creationtime=?, credentialname=?, role=?,  numberofusers=?, delegatedcredentials=?, credentialexpiration=? where id=? ";

    public DatabaseRequestCredentialStorage(Configuration configuration) throws SQLException {
        this.jdbcUrl = configuration.getJdbcUrl();
        this.jdbcClass = configuration.getJdbcClass();
        this.user = configuration.getJdbcUser();
        this.pass = configuration.getJdbcPass();
        this.configuration = configuration;
        this.credentialsDirectory = configuration.getCredentialsDirectory();
        File dir = new File(this.credentialsDirectory);
        if (!dir.exists() && !dir.mkdir()) {
            logger.error("failed to create directory " + this.credentialsDirectory);
        }
        if (!dir.isDirectory() || !dir.canWrite()) {
            logger.error("credential directory " + this.credentialsDirectory + " does not exist or is not writable");
        }
        this.dbInit();
    }

    public String getTableName() {
        return requestCredentialTableName;
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void dbInit() throws SQLException {
        Connection _con = null;
        try {
            this.pool = JdbcConnectionPool.getPool(this.jdbcUrl, this.jdbcClass, this.user, this.pass);
            _con = this.pool.getConnection();
            _con.setAutoCommit(true);
            DatabaseMetaData md = _con.getMetaData();
            ResultSet tableRs = md.getTables(null, null, this.getTableName(), null);
            if (!tableRs.next()) {
                try {
                    Statement s = _con.createStatement();
                    logger.debug("dbInit trying CREATE TABLE srmrequestcredentials ( id  BIGINT  NOT NULL PRIMARY KEY,creationtime  BIGINT ,credentialname  VARCHAR(32672)  ,role  VARCHAR(32672)  ,numberofusers  INTEGER ,delegatedcredentials  VARCHAR(32672)  ,credentialexpiration  BIGINT  )");
                    int result = s.executeUpdate(createRequestCredentialTable);
                    s.close();
                }
                catch (SQLException sqle) {
                    logger.error(sqle.toString());
                    logger.error("relation could already exist");
                }
            }
            _con.setAutoCommit(false);
            this.pool.returnConnection(_con);
            return;
        }
        catch (SQLException sqe) {
            try {
                if (_con != null) {
                    this.pool.returnFailedConnection(_con);
                    _con = null;
                }
                throw sqe;
                catch (Exception ex) {
                    if (_con != null) {
                        this.pool.returnFailedConnection(_con);
                        _con = null;
                    }
                    logger.error(ex.toString());
                    throw new SQLException(ex.toString());
                }
            }
            catch (Throwable throwable) {
                if (_con != null) {
                    this.pool.returnFailedConnection(_con);
                }
                throw throwable;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void createRequestCredential(RequestCredential requestCredential) {
        block9: {
            Object sqlStatement = null;
            Connection _con = null;
            try {
                GSSCredential credential = requestCredential.getDelegatedCredential();
                String credentialFileName = null;
                if (credential != null) {
                    credentialFileName = this.credentialsDirectory + "/" + requestCredential.getId();
                    this.writeCredentialInFile(credential, credentialFileName);
                }
                _con = this.pool.getConnection();
                int result = DatabaseRequestCredentialStorage.insert(_con, INSERT, requestCredential.getId(), requestCredential.getCreationtime(), requestCredential.getCredentialName(), requestCredential.getRole(), requestCredential.getCredential_users(), credentialFileName, requestCredential.getDelegatedCredentialExpiration());
                _con.commit();
            }
            catch (SQLException e) {
                if (_con == null) break block9;
                try {
                    _con.rollback();
                }
                catch (SQLException e1) {
                    // empty catch block
                }
                this.pool.returnFailedConnection(_con);
                _con = null;
            }
            finally {
                if (_con != null) {
                    this.pool.returnConnection(_con);
                    _con = null;
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private RequestCredential getRequestCredentialByCondition(String query, Object ... args) {
        RequestCredential credential;
        block33: {
            Connection _con = null;
            credential = null;
            ResultSet set = null;
            PreparedStatement stmt = null;
            try {
                _con = this.pool.getConnection();
                stmt = DatabaseRequestCredentialStorage.prepare(_con, query, args);
                set = stmt.executeQuery();
                if (set.next()) {
                    credential = new RequestCredential(set.getLong("id"), set.getLong("creationtime"), set.getString("credentialname"), set.getString("role"), this.fileNameToGSSCredentilal(set.getString("delegatedcredentials")), set.getLong("credentialexpiration"), this);
                    credential.setSaved(true);
                }
            }
            catch (SQLException e) {
                if (_con == null) break block33;
                if (set != null) {
                    try {
                        set.close();
                    }
                    catch (SQLException e1) {
                        logger.debug("Failed to close ResultSet " + e1.getMessage());
                    }
                }
                if (stmt != null) {
                    try {
                        stmt.close();
                    }
                    catch (SQLException e1) {
                        logger.debug("Failed to close ResultSet " + e1.getMessage());
                    }
                }
                this.pool.returnFailedConnection(_con);
                _con = null;
            }
            catch (Exception e) {
                logger.error(e.toString());
            }
            finally {
                if (_con != null) {
                    if (set != null) {
                        try {
                            set.close();
                        }
                        catch (SQLException e1) {
                            logger.debug("Failed to close ResultSet " + e1.getMessage());
                        }
                    }
                    if (stmt != null) {
                        try {
                            stmt.close();
                        }
                        catch (SQLException e1) {
                            logger.debug("Failed to close ResultSet " + e1.getMessage());
                        }
                    }
                    this.pool.returnConnection(_con);
                    _con = null;
                }
            }
        }
        return credential;
    }

    @Override
    public RequestCredential getRequestCredential(Long requestCredentialId) {
        return this.getRequestCredentialByCondition(SELECT_BY_ID, (long)requestCredentialId);
    }

    @Override
    public RequestCredential getRequestCredential(String credentialName, String role) {
        if (role == null || role.equalsIgnoreCase("null")) {
            return this.getRequestCredentialByCondition(SELECT_BY_NAME, credentialName);
        }
        return this.getRequestCredentialByCondition(SELECT_BY_NAME_AND_ROLE, credentialName, role);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void saveRequestCredential(RequestCredential requestCredential) {
        Object sqlStatement = null;
        int result = 0;
        Connection _con = null;
        try {
            GSSCredential credential = requestCredential.getDelegatedCredential();
            String credentialFileName = null;
            if (credential != null) {
                credentialFileName = this.credentialsDirectory + "/" + requestCredential.getId();
                this.writeCredentialInFile(credential, credentialFileName);
            }
            _con = this.pool.getConnection();
            result = DatabaseRequestCredentialStorage.update(_con, UPDATE, requestCredential.getCreationtime(), requestCredential.getCredentialName(), requestCredential.getRole(), requestCredential.getCredential_users(), credentialFileName, requestCredential.getDelegatedCredentialExpiration(), requestCredential.getId());
            _con.commit();
            if (_con != null) {
                this.pool.returnConnection(_con);
                _con = null;
            }
        }
        catch (SQLException e) {
            try {
                logger.error(e.toString());
                if (_con != null) {
                    try {
                        _con.rollback();
                    }
                    catch (SQLException e1) {
                        logger.debug("Failed rollback connection " + e1.getMessage());
                    }
                    this.pool.returnFailedConnection(_con);
                    _con = null;
                }
                if (_con != null) {
                    this.pool.returnConnection(_con);
                    _con = null;
                }
            }
            catch (Throwable throwable) {
                if (_con != null) {
                    this.pool.returnConnection(_con);
                    _con = null;
                }
                throw throwable;
            }
        }
        if (result == 0) {
            this.createRequestCredential(requestCredential);
        }
    }

    private void writeCredentialInFile(GSSCredential credential, String credentialFileName) {
        OutputStreamWriter writer = null;
        try {
            String credentialString = DatabaseRequestCredentialStorage.gssCredentialToString(credential);
            writer = new FileWriter(credentialFileName, false);
            writer.write(credentialString);
            writer.close();
        }
        catch (IOException ioe) {
            if (writer != null) {
                try {
                    writer.close();
                }
                catch (IOException ioe1) {
                    // empty catch block
                }
            }
            logger.error(ioe.toString());
        }
    }

    private static String gssCredentialToString(GSSCredential credential) {
        try {
            if (credential != null && credential instanceof ExtendedGSSCredential) {
                byte[] data = ((ExtendedGSSCredential)credential).export(0);
                return new String(data);
            }
        }
        catch (Exception e) {
            System.err.println("conversion of credential to string failed with exception");
            e.printStackTrace();
        }
        return null;
    }

    private GSSCredential fileNameToGSSCredentilal(String fileName) {
        if (fileName == null) {
            return null;
        }
        FileReader reader = null;
        try {
            int len;
            reader = new FileReader(fileName);
            StringBuffer sb = new StringBuffer();
            char[] cbuf = new char[1024];
            while ((len = reader.read(cbuf)) != -1) {
                sb.append(cbuf, 0, len);
            }
            reader.close();
            return this.stringToGSSCredential(sb.toString());
        }
        catch (IOException ioe) {
            if (reader != null) {
                try {
                    reader.close();
                }
                catch (IOException ioe1) {
                    // empty catch block
                }
            }
            logger.debug("fileNameToGSSCredentilal(" + fileName + ") failed with " + ioe);
            return null;
        }
    }

    private GSSCredential stringToGSSCredential(String credential_string) {
        if (credential_string != null) {
            ByteArrayInputStream in = new ByteArrayInputStream(credential_string.getBytes());
            try {
                GlobusCredential gc = new GlobusCredential((InputStream)in);
                GlobusGSSCredentialImpl cred = new GlobusGSSCredentialImpl(gc, 1);
                return cred;
            }
            catch (Exception e) {
                logger.error("error reading the credentials from database");
                logger.error(e.toString());
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int update(Connection connection, String query, Object ... args) throws SQLException {
        PreparedStatement stmt = null;
        try {
            stmt = connection.prepareStatement(query);
            for (int i = 0; i < args.length; ++i) {
                stmt.setObject(i + 1, args[i]);
            }
            int n = stmt.executeUpdate();
            return n;
        }
        finally {
            if (stmt != null) {
                stmt.close();
            }
        }
    }

    public static int delete(Connection connection, String query, Object ... args) throws SQLException {
        return DatabaseRequestCredentialStorage.update(connection, query, args);
    }

    public static int insert(Connection connection, String query, Object ... args) throws SQLException {
        return DatabaseRequestCredentialStorage.update(connection, query, args);
    }

    public static PreparedStatement prepare(Connection connection, String query, Object ... args) throws SQLException {
        PreparedStatement stmt = connection.prepareStatement(query);
        for (int i = 0; i < args.length; ++i) {
            stmt.setObject(i + 1, args[i]);
        }
        return stmt;
    }
}

