/*
 * Decompiled with CFR 0.152.
 */
package org.dcache.srm.request.sql;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.HashSet;
import org.dcache.srm.SRMInvalidRequestException;
import org.dcache.srm.SRMUser;
import org.dcache.srm.request.ContainerRequest;
import org.dcache.srm.request.FileRequest;
import org.dcache.srm.request.Request;
import org.dcache.srm.request.sql.DatabaseRequestStorage;
import org.dcache.srm.scheduler.Job;
import org.dcache.srm.util.Configuration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class DatabaseContainerRequestStorage
extends DatabaseRequestStorage {
    private static final Logger logger = LoggerFactory.getLogger(DatabaseContainerRequestStorage.class);

    public DatabaseContainerRequestStorage(Configuration.DatabaseParameters configuration) throws SQLException {
        super(configuration);
    }

    public abstract String getFileRequestsTableName();

    public abstract void dbInit1() throws SQLException;

    @Override
    protected void _dbInit() throws SQLException {
        this.dbInit1();
    }

    protected abstract ContainerRequest getContainerRequest(Connection var1, Long var2, Long var3, long var4, long var6, int var8, String var9, SRMUser var10, String var11, long var12, int var14, int var15, long var16, Long var18, int var19, boolean var20, String var21, String var22, String var23, FileRequest[] var24, ResultSet var25, int var26) throws SQLException;

    @Override
    protected Request getRequest(Connection _con, Long ID, Long NEXTJOBID, long CREATIONTIME, long LIFETIME, int STATE, String ERRORMESSAGE, SRMUser user, String SCHEDULERID, long SCHEDULER_TIMESTAMP, int NUMOFRETR, int MAXNUMOFRETR, long LASTSTATETRANSITIONTIME, Long CREDENTIALID, int RETRYDELTATIME, boolean SHOULDUPDATERETRYDELTATIME, String DESCRIPTION, String CLIENTHOST, String STATUSCODE, ResultSet set, int next_index) throws SQLException {
        String sqlStatementString = "SELECT ID FROM " + this.getFileRequestsTableName() + " WHERE RequestID=" + ID;
        Statement sqlStatement = _con.createStatement();
        logger.debug("executing statement: " + sqlStatementString);
        ResultSet fileIdsSet = sqlStatement.executeQuery(sqlStatementString);
        HashSet<Long> utilset = new HashSet<Long>();
        while (fileIdsSet.next()) {
            utilset.add(fileIdsSet.getLong(1));
        }
        fileIdsSet.close();
        sqlStatement.close();
        Long[] fileIds = utilset.toArray(new Long[0]);
        sqlStatement.close();
        FileRequest[] fileRequests = new FileRequest[fileIds.length];
        for (int i = 0; i < fileRequests.length; ++i) {
            try {
                fileRequests[i] = Job.getJob(fileIds[i], FileRequest.class, _con);
                continue;
            }
            catch (SRMInvalidRequestException ire) {
                logger.error(ire.toString());
            }
        }
        return this.getContainerRequest(_con, ID, NEXTJOBID, CREATIONTIME, LIFETIME, STATE, ERRORMESSAGE, user, SCHEDULERID, SCHEDULER_TIMESTAMP, NUMOFRETR, MAXNUMOFRETR, LASTSTATETRANSITIONTIME, CREDENTIALID, RETRYDELTATIME, SHOULDUPDATERETRYDELTATIME, DESCRIPTION, CLIENTHOST, STATUSCODE, fileRequests, set, next_index);
    }

    @Override
    public abstract String getTableName();

    public abstract void getCreateList(ContainerRequest var1, StringBuffer var2);

    @Override
    public void getCreateList(Request r, StringBuffer sb) {
        if (r == null || !(r instanceof ContainerRequest)) {
            throw new IllegalArgumentException("Request is not ContainerRequest");
        }
        ContainerRequest cr = (ContainerRequest)r;
        this.getCreateList(cr, sb);
    }
}

