/*
 * Decompiled with CFR 0.152.
 */
package org.dcache.srm.request.sql;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import org.dcache.srm.SRMUser;
import org.dcache.srm.request.ContainerRequest;
import org.dcache.srm.request.CopyRequest;
import org.dcache.srm.request.FileRequest;
import org.dcache.srm.request.sql.DatabaseContainerRequestStorage;
import org.dcache.srm.scheduler.Job;
import org.dcache.srm.util.Configuration;
import org.dcache.srm.v2_2.TAccessLatency;
import org.dcache.srm.v2_2.TFileStorageType;
import org.dcache.srm.v2_2.TRetentionPolicy;

public class CopyRequestStorage
extends DatabaseContainerRequestStorage {
    public static final String TABLE_NAME = "copyrequests";
    private static final String UPDATE_PREFIX = "UPDATE copyrequests SET NEXTJOBID=?, CREATIONTIME=?,  LIFETIME=?, STATE=?, ERRORMESSAGE=?, SCHEDULERID=?, SCHEDULERTIMESTAMP=?,NUMOFRETR=?,MAXNUMOFRETR=?,LASTSTATETRANSITIONTIME=? ";
    private static final String INSERT_SQL = "INSERT INTO copyrequests(    ID ,NEXTJOBID ,CREATIONTIME ,LIFETIME ,STATE ,ERRORMESSAGE ,SCHEDULERID ,SCHEDULERTIMESTAMP ,NUMOFRETR ,MAXNUMOFRETR ,LASTSTATETRANSITIONTIME,CREDENTIALID , RETRYDELTATIME , SHOULDUPDATERETRYDELTATIME ,DESCRIPTION ,CLIENTHOST ,STATUSCODE ,USERID ,STORAGETYPE, RETENTIONPOLICY, ACCESSLATENCY ) VALUES (?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?)";
    private static final String UPDATE_REQUEST_SQL = "UPDATE copyrequests SET NEXTJOBID=?, CREATIONTIME=?,  LIFETIME=?, STATE=?, ERRORMESSAGE=?, SCHEDULERID=?, SCHEDULERTIMESTAMP=?,NUMOFRETR=?,MAXNUMOFRETR=?,LASTSTATETRANSITIONTIME=? , CREDENTIALID=?, RETRYDELTATIME=?, SHOULDUPDATERETRYDELTATIME=?, DESCRIPTION=?, CLIENTHOST=?, STATUSCODE=?, USERID=?, STORAGETYPE=?,  RETENTIONPOLICY=?, ACCESSLATENCY=? WHERE ID=?";
    private static int ADDITIONAL_FIELDS = 3;

    @Override
    public PreparedStatement getCreateStatement(Connection connection, Job job) throws SQLException {
        CopyRequest cr = (CopyRequest)job;
        String storageTypeValue = null;
        if (cr.getStorageType() != null) {
            storageTypeValue = cr.getStorageType().getValue();
        }
        String retentionPolicyValue = null;
        if (cr.getTargetRetentionPolicy() != null) {
            retentionPolicyValue = cr.getTargetRetentionPolicy().getValue();
        }
        String accessLatencyValue = null;
        if (cr.getTargetAccessLatency() != null) {
            accessLatencyValue = cr.getTargetAccessLatency().getValue();
        }
        PreparedStatement stmt = this.getPreparedStatement(connection, INSERT_SQL, cr.getId(), cr.getNextJobId(), cr.getCreationTime(), cr.getLifetime(), cr.getState().getStateId(), cr.getErrorMessage(), cr.getSchedulerId(), cr.getSchedulerTimeStamp(), cr.getNumberOfRetries(), cr.getMaxNumberOfRetries(), cr.getLastStateTransitionTime(), cr.getCredentialId(), cr.getRetryDeltaTime(), cr.isShould_updateretryDeltaTime() ? 0 : 1, cr.getDescription(), cr.getClient_host(), cr.getStatusCodeString(), cr.getUser().getId(), storageTypeValue, retentionPolicyValue, accessLatencyValue);
        return stmt;
    }

    @Override
    public PreparedStatement getUpdateStatement(Connection connection, Job job) throws SQLException {
        CopyRequest cr = (CopyRequest)job;
        String storageTypeValue = null;
        if (cr.getStorageType() != null) {
            storageTypeValue = cr.getStorageType().getValue();
        }
        String retentionPolicyValue = null;
        if (cr.getTargetRetentionPolicy() != null) {
            retentionPolicyValue = cr.getTargetRetentionPolicy().getValue();
        }
        String accessLatencyValue = null;
        if (cr.getTargetAccessLatency() != null) {
            accessLatencyValue = cr.getTargetAccessLatency().getValue();
        }
        PreparedStatement stmt = this.getPreparedStatement(connection, UPDATE_REQUEST_SQL, cr.getNextJobId(), cr.getCreationTime(), cr.getLifetime(), cr.getState().getStateId(), cr.getErrorMessage(), cr.getSchedulerId(), cr.getSchedulerTimeStamp(), cr.getNumberOfRetries(), cr.getMaxNumberOfRetries(), cr.getLastStateTransitionTime(), cr.getCredentialId(), cr.getRetryDeltaTime(), cr.isShould_updateretryDeltaTime() ? 0 : 1, cr.getDescription(), cr.getClient_host(), cr.getStatusCodeString(), cr.getUser().getId(), storageTypeValue, retentionPolicyValue, accessLatencyValue, cr.getId());
        return stmt;
    }

    public CopyRequestStorage(Configuration.DatabaseParameters configuration) throws SQLException {
        super(configuration);
    }

    @Override
    public void dbInit1() throws SQLException {
    }

    @Override
    public void getCreateList(ContainerRequest r, StringBuffer sb) {
        CopyRequest cr = (CopyRequest)r;
        TFileStorageType storageType = cr.getStorageType();
        if (storageType == null) {
            sb.append(", NULL ");
        } else {
            sb.append(", '").append(storageType.getValue()).append("' ");
        }
        TRetentionPolicy retentionPolicy = cr.getTargetRetentionPolicy();
        if (retentionPolicy == null) {
            sb.append(", NULL ");
        } else {
            sb.append(", '").append(retentionPolicy.getValue()).append("' ");
        }
        TAccessLatency accessLatency = cr.getTargetAccessLatency();
        if (accessLatency == null) {
            sb.append(",NULL ");
        } else {
            sb.append(", '").append(accessLatency.getValue()).append('\'');
        }
    }

    @Override
    protected ContainerRequest getContainerRequest(Connection _con, Long ID, Long NEXTJOBID, long CREATIONTIME, long LIFETIME, int STATE, String ERRORMESSAGE, SRMUser user, String SCHEDULERID, long SCHEDULER_TIMESTAMP, int NUMOFRETR, int MAXNUMOFRETR, long LASTSTATETRANSITIONTIME, Long CREDENTIALID, int RETRYDELTATIME, boolean SHOULDUPDATERETRYDELTATIME, String DESCRIPTION, String CLIENTHOST, String STATUSCODE, FileRequest[] fileRequests, ResultSet set, int next_index) throws SQLException {
        Job.JobHistory[] jobHistoryArray = this.getJobHistory(ID, _con);
        String STORAGETYPE = set.getString(next_index++);
        String RETENTIONPOLICY = set.getString(next_index++);
        String ACCESSLATENCY = set.getString(next_index++);
        TFileStorageType storageType = STORAGETYPE == null || STORAGETYPE.equalsIgnoreCase("null") ? null : TFileStorageType.fromString(STORAGETYPE);
        TRetentionPolicy retentionPolicy = RETENTIONPOLICY == null || RETENTIONPOLICY.equalsIgnoreCase("null") ? null : TRetentionPolicy.fromString(RETENTIONPOLICY);
        TAccessLatency accessLatency = ACCESSLATENCY == null || ACCESSLATENCY.equalsIgnoreCase("null") ? null : TAccessLatency.fromString(ACCESSLATENCY);
        return new CopyRequest(ID, NEXTJOBID, CREATIONTIME, LIFETIME, STATE, ERRORMESSAGE, user, SCHEDULERID, SCHEDULER_TIMESTAMP, NUMOFRETR, MAXNUMOFRETR, LASTSTATETRANSITIONTIME, jobHistoryArray, CREDENTIALID, fileRequests, RETRYDELTATIME, SHOULDUPDATERETRYDELTATIME, DESCRIPTION, CLIENTHOST, STATUSCODE, storageType, retentionPolicy, accessLatency);
    }

    @Override
    public String getRequestCreateTableFields() {
        return ", STORAGETYPE  VARCHAR(32672) , RETENTIONPOLICY  VARCHAR(32672) , ACCESSLATENCY  VARCHAR(32672) ";
    }

    @Override
    public String getTableName() {
        return TABLE_NAME;
    }

    public void getUpdateAssignements(ContainerRequest r, StringBuffer sb) {
        CopyRequest cr = (CopyRequest)r;
        TFileStorageType storageType = cr.getStorageType();
        if (storageType == null) {
            sb.append(", STORAGETYPE=NULL ");
        } else {
            sb.append(", STORAGETYPE='").append(storageType.getValue()).append("' ");
        }
        TRetentionPolicy retentionPolicy = cr.getTargetRetentionPolicy();
        if (retentionPolicy == null) {
            sb.append(", RETENTIONPOLICY=NULL ");
        } else {
            sb.append(", RETENTIONPOLICY='").append(retentionPolicy.getValue()).append("' ");
        }
        TAccessLatency accessLatency = cr.getTargetAccessLatency();
        if (accessLatency == null) {
            sb.append(", ACCESSLATENCY=NULL ");
        } else {
            sb.append(", ACCESSLATENCY='").append(accessLatency.getValue()).append('\'');
        }
    }

    @Override
    public String getFileRequestsTableName() {
        return "copyfilerequests";
    }

    @Override
    protected void __verify(int nextIndex, int columnIndex, String tableName, String columnName, int columnType) throws SQLException {
        if (columnIndex == nextIndex) {
            this.verifyStringType("STORAGETYPE", columnIndex, tableName, columnName, columnType);
        } else if (columnIndex == nextIndex + 1) {
            this.verifyStringType("RETENTIONPOLICY", columnIndex, tableName, columnName, columnType);
        } else if (columnIndex == nextIndex + 2) {
            this.verifyStringType("ACCESSLATENCY", columnIndex, tableName, columnName, columnType);
        } else {
            throw new SQLException("database table schema changed:table named " + tableName + " column #" + columnIndex + " has name \"" + columnName + "\"  has type \"" + this.getTypeName(columnType) + " this column should not be present!!!");
        }
    }

    @Override
    protected int getMoreCollumnsNum() {
        return ADDITIONAL_FIELDS;
    }
}

