/*
 * Decompiled with CFR 0.152.
 */
package org.dcache.srm.request.sql;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import org.dcache.srm.request.CopyFileRequest;
import org.dcache.srm.request.FileRequest;
import org.dcache.srm.request.sql.DatabaseFileRequestStorage;
import org.dcache.srm.scheduler.Job;
import org.dcache.srm.util.Configuration;

public class CopyFileRequestStorage
extends DatabaseFileRequestStorage {
    public static final String TABLE_NAME = "copyfilerequests";
    private static final String UPDATE_PREFIX = "UPDATE copyfilerequests SET NEXTJOBID=?, CREATIONTIME=?,  LIFETIME=?, STATE=?, ERRORMESSAGE=?, SCHEDULERID=?, SCHEDULERTIMESTAMP=?,NUMOFRETR=?,MAXNUMOFRETR=?,LASTSTATETRANSITIONTIME=? ";
    private static final String UPDATE_REQUEST_SQL = "UPDATE copyfilerequests SET NEXTJOBID=?, CREATIONTIME=?,  LIFETIME=?, STATE=?, ERRORMESSAGE=?, SCHEDULERID=?, SCHEDULERTIMESTAMP=?,NUMOFRETR=?,MAXNUMOFRETR=?,LASTSTATETRANSITIONTIME=? , REQUESTID=?, CREDENTIALID=?, STATUSCODE=?, FROMURL=? ,TOURL =?,FROMTURL=? ,TOTURL=? ,FROMLOCALPATH=? ,TOLOCALPATH=? ,SIZE=? ,FROMFILEID=? ,TOFILEID=? ,REMOTEREQUESTID=? ,REMOTEFILEID=? , SPACERESERVATIONID=? , TRANSFERID=?   WHERE ID=? ";
    private static final String INSERT_SQL = "INSERT INTO copyfilerequests(    ID ,NEXTJOBID ,CREATIONTIME ,LIFETIME ,STATE ,ERRORMESSAGE ,SCHEDULERID ,SCHEDULERTIMESTAMP ,NUMOFRETR ,MAXNUMOFRETR ,LASTSTATETRANSITIONTIME,REQUESTID , CREDENTIALID , STATUSCODE , FROMURL ,TOURL ,FROMTURL ,TOTURL ,FROMLOCALPATH ,TOLOCALPATH ,SIZE ,FROMFILEID ,TOFILEID ,REMOTEREQUESTID ,REMOTEFILEID , SPACERESERVATIONID , TRANSFERID )  VALUES (?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?)";
    private static int ADDITIONAL_FIELDS = 13;

    public PreparedStatement getStatement(Connection connection, String query, Job job) throws SQLException {
        CopyFileRequest request = (CopyFileRequest)job;
        PreparedStatement stmt = this.getPreparedStatement(connection, query, request.getNextJobId(), request.getCreationTime(), request.getLifetime(), request.getState().getStateId(), request.getErrorMessage(), request.getSchedulerId(), request.getSchedulerTimeStamp(), request.getNumberOfRetries(), request.getMaxNumberOfRetries(), request.getLastStateTransitionTime(), request.getRequestId(), request.getCredentialId(), request.getStatusCodeString(), request.getFromURL(), request.getToURL(), request.getFrom_turl() != null ? request.getFrom_turl().toString() : null, request.getTo_turl() != null ? request.getTo_turl().toString() : null, request.getLocal_from_path(), request.getLocal_to_path(), request.getSize(), request.getFromFileId(), request.getToFileId(), request.getRemoteRequestId(), request.getRemoteFileId(), request.getSpaceReservationId(), request.getTransferId(), request.getId());
        return stmt;
    }

    @Override
    public PreparedStatement getUpdateStatement(Connection connection, Job job) throws SQLException {
        if (job == null || !(job instanceof CopyFileRequest)) {
            throw new IllegalArgumentException("job is not CopyFileRequest");
        }
        CopyFileRequest request = (CopyFileRequest)job;
        return this.getStatement(connection, UPDATE_REQUEST_SQL, request);
    }

    @Override
    public PreparedStatement getCreateStatement(Connection connection, Job job) throws SQLException {
        if (job == null || !(job instanceof CopyFileRequest)) {
            throw new IllegalArgumentException("fr is not CopyFileRequest");
        }
        CopyFileRequest request = (CopyFileRequest)job;
        PreparedStatement stmt = this.getPreparedStatement(connection, INSERT_SQL, request.getId(), request.getNextJobId(), request.getCreationTime(), request.getLifetime(), request.getState().getStateId(), request.getErrorMessage(), request.getSchedulerId(), request.getSchedulerTimeStamp(), request.getNumberOfRetries(), request.getMaxNumberOfRetries(), request.getLastStateTransitionTime(), request.getRequestId(), request.getCredentialId(), request.getStatusCodeString(), request.getFromURL(), request.getToURL(), request.getFrom_turl() != null ? request.getFrom_turl().toString() : null, request.getTo_turl() != null ? request.getTo_turl().toString() : null, request.getLocal_from_path(), request.getLocal_to_path(), request.getSize(), request.getFromFileId(), request.getToFileId(), request.getRemoteRequestId(), request.getRemoteFileId(), request.getSpaceReservationId(), request.getTransferId());
        return stmt;
    }

    public CopyFileRequestStorage(Configuration.DatabaseParameters configuration) throws SQLException {
        super(configuration);
    }

    @Override
    protected FileRequest getFileRequest(Connection _con, Long ID, Long NEXTJOBID, long CREATIONTIME, long LIFETIME, int STATE, String ERRORMESSAGE, String SCHEDULERID, long SCHEDULER_TIMESTAMP, int NUMOFRETR, int MAXNUMOFRETR, long LASTSTATETRANSITIONTIME, Long REQUESTID, Long CREDENTIALID, String STATUSCODE, ResultSet set, int next_index) throws SQLException {
        String FROMURL = set.getString(next_index++);
        String TOURL = set.getString(next_index++);
        String FROMTURL = set.getString(next_index++);
        String TOTURL = set.getString(next_index++);
        String FROMLOCALPATH = set.getString(next_index++);
        String TOLOCALPATH = set.getString(next_index++);
        long size = set.getLong(next_index++);
        String fromFileId = set.getString(next_index++);
        String toFileId = set.getString(next_index++);
        String REMOTEREQUESTID = set.getString(next_index++);
        String REMOTEFILEID = set.getString(next_index++);
        String SPACERESERVATIONID = set.getString(next_index++);
        String TRANSFERID = set.getString(next_index);
        Job.JobHistory[] jobHistoryArray = this.getJobHistory(ID, _con);
        return new CopyFileRequest(ID, NEXTJOBID, this, CREATIONTIME, LIFETIME, STATE, ERRORMESSAGE, SCHEDULERID, SCHEDULER_TIMESTAMP, NUMOFRETR, MAXNUMOFRETR, LASTSTATETRANSITIONTIME, jobHistoryArray, REQUESTID, CREDENTIALID, STATUSCODE, FROMURL, TOURL, FROMTURL, TOTURL, FROMLOCALPATH, TOLOCALPATH, size, fromFileId, toFileId, REMOTEREQUESTID, REMOTEFILEID, SPACERESERVATIONID, TRANSFERID);
    }

    @Override
    public String getFileRequestCreateTableFields() {
        return ",FROMURL  VARCHAR(32672) ,TOURL  VARCHAR(32672) ,FROMTURL  VARCHAR(32672) ,TOTURL  VARCHAR(32672) ,FROMLOCALPATH  VARCHAR(32672) ,TOLOCALPATH  VARCHAR(32672) ,SIZE  BIGINT ,FROMFILEID  VARCHAR(32672) ,TOFILEID  VARCHAR(32672) ,REMOTEREQUESTID  VARCHAR(32672) ,REMOTEFILEID  VARCHAR(32672) ,SPACERESERVATIONID  VARCHAR(32672) ,TRANSFERID  VARCHAR(32672) ";
    }

    @Override
    public String getTableName() {
        return TABLE_NAME;
    }

    @Override
    public String getRequestTableName() {
        return "copyrequests";
    }

    @Override
    protected void __verify(int nextIndex, int columnIndex, String tableName, String columnName, int columnType) throws SQLException {
        if (columnIndex == nextIndex) {
            this.verifyStringType("FROMURL", columnIndex, tableName, columnName, columnType);
        } else if (columnIndex == nextIndex + 1) {
            this.verifyStringType("TOURL", columnIndex, tableName, columnName, columnType);
        } else if (columnIndex == nextIndex + 2) {
            this.verifyStringType("FROMTURL", columnIndex, tableName, columnName, columnType);
        } else if (columnIndex == nextIndex + 3) {
            this.verifyStringType("TOTURL", columnIndex, tableName, columnName, columnType);
        } else if (columnIndex == nextIndex + 4) {
            this.verifyStringType("FROMLOCALPATH", columnIndex, tableName, columnName, columnType);
        } else if (columnIndex == nextIndex + 5) {
            this.verifyStringType("TOLOCALPATH", columnIndex, tableName, columnName, columnType);
        } else if (columnIndex == nextIndex + 6) {
            this.verifyLongType("SIZE", columnIndex, tableName, columnName, columnType);
        } else if (columnIndex == nextIndex + 7) {
            this.verifyStringType("FROMFILEID", columnIndex, tableName, columnName, columnType);
        } else if (columnIndex == nextIndex + 8) {
            this.verifyStringType("TOFILEID", columnIndex, tableName, columnName, columnType);
        } else if (columnIndex == nextIndex + 9) {
            this.verifyStringType("REMOTEREQUESTID", columnIndex, tableName, columnName, columnType);
        } else if (columnIndex == nextIndex + 10) {
            this.verifyStringType("REMOTEFILEID", columnIndex, tableName, columnName, columnType);
        } else if (columnIndex == nextIndex + 11) {
            this.verifyStringType("SPACERESERVATIONID", columnIndex, tableName, columnName, columnType);
        } else if (columnIndex == nextIndex + 12) {
            this.verifyStringType("TRANSFERID", columnIndex, tableName, columnName, columnType);
        } else {
            throw new SQLException("database table schema changed:table named " + tableName + " column #" + columnIndex + " has name \"" + columnName + "\"  has type \"" + this.getTypeName(columnType) + " this column should not be present!!!");
        }
    }

    @Override
    protected int getMoreCollumnsNum() {
        return ADDITIONAL_FIELDS;
    }
}

