/*
 * Decompiled with CFR 0.152.
 */
package org.dcache.srm.request;

import org.dcache.srm.AbstractStorageElement;
import org.dcache.srm.SRM;
import org.dcache.srm.SRMInvalidRequestException;
import org.dcache.srm.SRMUser;
import org.dcache.srm.request.RequestCredential;
import org.dcache.srm.request.sql.RequestsPropertyStorage;
import org.dcache.srm.scheduler.IllegalStateTransition;
import org.dcache.srm.scheduler.Job;
import org.dcache.srm.scheduler.State;
import org.dcache.srm.util.Configuration;
import org.dcache.srm.v2_2.TStatusCode;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class Request
extends Job {
    private static final Logger logger = LoggerFactory.getLogger(Request.class);
    private final String client_host;
    private final SRMUser user;
    private transient Configuration configuration;
    private final Long credentialId;
    protected int cyclicUpdateCounter = 0;
    protected long max_update_period = 36000L;
    protected static RequestsPropertyStorage requestsproperties = null;
    protected int retryDeltaTime = 1;
    protected boolean should_updateretryDeltaTime = true;
    private transient AbstractStorageElement storage;
    private TStatusCode statusCode;
    private String description;

    public Request(SRMUser user, Long requestCredentalId, int max_number_of_retries, long max_update_period, long lifetime, String description, String client_host) {
        super(lifetime, max_number_of_retries);
        this.credentialId = requestCredentalId;
        this.max_update_period = max_update_period;
        this.description = description;
        this.client_host = client_host;
        this.user = user;
    }

    protected Request(Long id, Long nextJobId, long creationTime, long lifetime, int stateId, String errorMessage, SRMUser user, String scheduelerId, long schedulerTimeStamp, int numberOfRetries, int maxNumberOfRetries, long lastStateTransitionTime, Job.JobHistory[] jobHistoryArray, Long credentialId, int retryDeltaTime, boolean should_updateretryDeltaTime, String description, String client_host, String statusCodeString) {
        super(id, nextJobId, creationTime, lifetime, stateId, errorMessage, scheduelerId, schedulerTimeStamp, numberOfRetries, maxNumberOfRetries, lastStateTransitionTime, jobHistoryArray);
        this.credentialId = credentialId;
        this.retryDeltaTime = retryDeltaTime;
        this.should_updateretryDeltaTime = should_updateretryDeltaTime;
        this.description = description;
        this.client_host = client_host;
        this.statusCode = statusCodeString == null ? null : TStatusCode.fromString(statusCodeString);
        this.user = user;
        logger.debug("restored");
    }

    public RequestCredential getCredential() {
        if (this.credentialId == null) {
            return null;
        }
        return RequestCredential.getRequestCredential(this.credentialId);
    }

    public final Long getCredentialId() {
        return this.credentialId;
    }

    public abstract String getMethod();

    public void addDebugHistoryEvent(String description) {
        if (this.getJobStorage().isJdbcLogRequestHistoryInDBEnabled()) {
            this.addHistoryEvent(description);
        }
    }

    public static Request getRequest(Long requestId) throws SRMInvalidRequestException {
        Job job = Job.getJob(requestId, Job.class);
        if (job == null || !(job instanceof Request)) {
            return null;
        }
        return (Request)job;
    }

    public static Request getRequest(int requestNum) throws SRMInvalidRequestException {
        return Job.getJob(Long.valueOf(requestNum), Request.class);
    }

    public int getRequestNum() {
        return (int)this.getId().longValue();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getRetryDeltaTime() {
        this.rlock();
        try {
            int n = this.retryDeltaTime;
            return n;
        }
        finally {
            this.runlock();
        }
    }

    public SRMUser getUser() {
        return this.user;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isShould_updateretryDeltaTime() {
        this.rlock();
        try {
            boolean bl = this.should_updateretryDeltaTime;
            return bl;
        }
        finally {
            this.runlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void resetRetryDeltaTime() {
        this.wlock();
        try {
            this.retryDeltaTime = 1;
        }
        finally {
            this.wunlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stopUpdating() {
        this.wlock();
        try {
            this.retryDeltaTime = 1;
            this.should_updateretryDeltaTime = false;
        }
        finally {
            this.wunlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void updateRetryDeltaTime() {
        this.wlock();
        try {
            if (this.should_updateretryDeltaTime && this.cyclicUpdateCounter == 0) {
                this.retryDeltaTime = this.retryDeltaTime < 100 ? (this.retryDeltaTime += 3) : (this.retryDeltaTime < 300 ? (this.retryDeltaTime += 6) : (this.retryDeltaTime *= 2));
                if ((long)this.retryDeltaTime > this.max_update_period) {
                    this.retryDeltaTime = (int)this.max_update_period;
                }
            }
            this.cyclicUpdateCounter = (this.cyclicUpdateCounter + 1) % 5;
        }
        finally {
            this.wunlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final String getDescription() {
        this.rlock();
        try {
            String string = this.description;
            return string;
        }
        finally {
            this.runlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void setDescription(String description) {
        this.wlock();
        try {
            this.description = description;
        }
        finally {
            this.wunlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TStatusCode getStatusCode() {
        this.rlock();
        try {
            TStatusCode tStatusCode = this.statusCode;
            return tStatusCode;
        }
        finally {
            this.runlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getStatusCodeString() {
        this.rlock();
        try {
            String string = this.statusCode == null ? null : this.statusCode.getValue();
            return string;
        }
        finally {
            this.runlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void setStateAndStatusCode(State state, String description, TStatusCode statusCode) throws IllegalStateTransition {
        this.wlock();
        try {
            this.setState(state, description);
            this.setStatusCode(statusCode);
        }
        finally {
            this.wunlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setStatusCode(TStatusCode statusCode) {
        this.wlock();
        try {
            this.statusCode = statusCode;
        }
        finally {
            this.wunlock();
        }
    }

    public String getClient_host() {
        return this.client_host;
    }

    @Override
    public String getSubmitterId() {
        return Long.toString(this.user.getId());
    }

    public final AbstractStorageElement getStorage() {
        if (this.storage == null) {
            this.storage = SRM.getSRM().getStorage();
        }
        return this.storage;
    }

    public final Configuration getConfiguration() {
        if (this.configuration == null) {
            this.configuration = SRM.getSRM().getConfiguration();
        }
        return this.configuration;
    }
}

