/*
 * Decompiled with CFR 0.152.
 */
package org.dcache.srm.request;

import diskCacheV111.srm.RequestFileStatus;
import java.net.URI;
import java.sql.SQLException;
import org.apache.axis.types.UnsignedLong;
import org.dcache.srm.FileMetaData;
import org.dcache.srm.PinCallbacks;
import org.dcache.srm.SRMAuthorizationException;
import org.dcache.srm.SRMException;
import org.dcache.srm.SRMInvalidRequestException;
import org.dcache.srm.SRMUser;
import org.dcache.srm.UnpinCallbacks;
import org.dcache.srm.request.FileRequest;
import org.dcache.srm.request.GetRequest;
import org.dcache.srm.scheduler.FatalJobFailure;
import org.dcache.srm.scheduler.IllegalStateTransition;
import org.dcache.srm.scheduler.Job;
import org.dcache.srm.scheduler.NonFatalJobFailure;
import org.dcache.srm.scheduler.Scheduler;
import org.dcache.srm.scheduler.State;
import org.dcache.srm.v2_2.TGetRequestFileStatus;
import org.dcache.srm.v2_2.TReturnStatus;
import org.dcache.srm.v2_2.TSURLReturnStatus;
import org.dcache.srm.v2_2.TStatusCode;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class GetFileRequest
extends FileRequest {
    private static final Logger logger = LoggerFactory.getLogger(GetFileRequest.class);
    private URI surl;
    private URI turl;
    private String pinId;
    private String fileId;
    private transient FileMetaData fileMetaData;
    private static final long serialVersionUID = -9155373723705753177L;

    public GetFileRequest(Long requestId, Long requestCredentalId, String url, long lifetime, int maxNumberOfRetries) throws Exception {
        super(requestId, requestCredentalId, lifetime, maxNumberOfRetries);
        logger.debug("GetFileRequest, requestId=" + requestId + " fileRequestId = " + this.getId());
        this.surl = URI.create(url);
        this.updateMemoryCache();
    }

    public GetFileRequest(Long id, Long nextJobId, long creationTime, long lifetime, int stateId, String errorMessage, String scheduelerId, long schedulerTimeStamp, int numberOfRetries, int maxNumberOfRetries, long lastStateTransitionTime, Job.JobHistory[] jobHistoryArray, Long requestId, Long requestCredentalId, String statusCodeString, String SURL2, String TURL, String fileId, String pinId) throws SQLException {
        super(id, nextJobId, creationTime, lifetime, stateId, errorMessage, scheduelerId, schedulerTimeStamp, numberOfRetries, maxNumberOfRetries, lastStateTransitionTime, jobHistoryArray, requestId, requestCredentalId, statusCodeString);
        this.surl = URI.create(SURL2);
        if (TURL != null && !TURL.equalsIgnoreCase("null")) {
            this.turl = URI.create(TURL);
        }
        if (fileId != null && !fileId.equalsIgnoreCase("null")) {
            this.fileId = fileId;
        }
        if (pinId != null && !pinId.equalsIgnoreCase("null")) {
            this.pinId = pinId;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setPinId(String pinId) {
        this.wlock();
        try {
            this.pinId = pinId;
        }
        finally {
            this.wunlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getPinId() {
        this.rlock();
        try {
            String string = this.pinId;
            return string;
        }
        finally {
            this.runlock();
        }
    }

    public boolean isPinned() {
        return this.getPinId() != null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public URI getSurl() {
        this.rlock();
        try {
            URI uRI = this.surl;
            return uRI;
        }
        finally {
            this.runlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public URI getTurl() {
        this.rlock();
        try {
            URI uRI = this.turl;
            return uRI;
        }
        finally {
            this.runlock();
        }
    }

    public final String getSurlString() {
        return this.getSurl().toASCIIString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getTurlString() {
        this.wlock();
        try {
            State state = this.getState();
            if (this.getTurl() == null && (state == State.READY || state == State.TRANSFERRING)) {
                try {
                    this.setTurl(this.getTURL());
                }
                catch (SRMAuthorizationException srmae) {
                    String error = srmae.getMessage();
                    logger.error(error);
                    try {
                        this.setStateAndStatusCode(State.FAILED, error, TStatusCode.SRM_AUTHORIZATION_FAILURE);
                    }
                    catch (IllegalStateTransition ist) {
                        logger.warn("Illegal State Transition : " + ist.getMessage());
                    }
                }
                catch (Exception srme) {
                    String error = "can not obtain turl for file:" + srme;
                    logger.error(error.toString());
                    try {
                        this.setState(State.FAILED, error);
                    }
                    catch (IllegalStateTransition ist) {
                        logger.warn("Illegal State Transition : " + ist.getMessage());
                    }
                }
            }
            if (this.getTurl() != null) {
                String string = this.getTurl().toASCIIString();
                return string;
            }
        }
        finally {
            this.wunlock();
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getFileId() {
        this.rlock();
        try {
            String string = this.fileId;
            return string;
        }
        finally {
            this.runlock();
        }
    }

    @Override
    public RequestFileStatus getRequestFileStatus() {
        RequestFileStatus rfs = this.getFileMetaData() != null ? new RequestFileStatus(this.getFileMetaData()) : new RequestFileStatus();
        rfs.fileId = this.getId().intValue();
        rfs.SURL = this.getSurlString();
        if (this.isPinned()) {
            rfs.isPinned = true;
            rfs.isCached = true;
        }
        State state = this.getState();
        rfs.TURL = this.getTurlString();
        rfs.state = state == State.DONE ? "Done" : (state == State.READY ? "Ready" : (state == State.TRANSFERRING ? "Running" : (state == State.FAILED || state == State.CANCELED ? "Failed" : "Pending")));
        return rfs;
    }

    public TGetRequestFileStatus getTGetRequestFileStatus() throws SQLException, SRMInvalidRequestException {
        TGetRequestFileStatus fileStatus = new TGetRequestFileStatus();
        if (this.getFileMetaData() != null) {
            fileStatus.setFileSize(new UnsignedLong(this.getFileMetaData().size));
        }
        try {
            fileStatus.setSourceSURL(new org.apache.axis.types.URI(this.getSurlString()));
        }
        catch (Exception e) {
            logger.error(e.toString());
            throw new SQLException("wrong surl format");
        }
        String turlstring = this.getTurlString();
        if (turlstring != null) {
            try {
                fileStatus.setTransferURL(new org.apache.axis.types.URI(turlstring));
            }
            catch (Exception e) {
                logger.error(e.toString());
                throw new SQLException("wrong turl format");
            }
        }
        if (this.isPinned()) {
            fileStatus.setRemainingPinTime((int)(this.getRemainingLifetime() / 1000L));
        }
        fileStatus.setEstimatedWaitTime(this.getRequest().getRetryDeltaTime());
        TReturnStatus returnStatus = this.getReturnStatus();
        fileStatus.setStatus(returnStatus);
        return fileStatus;
    }

    public TSURLReturnStatus getTSURLReturnStatus() throws SQLException {
        TReturnStatus returnStatus = this.getReturnStatus();
        TSURLReturnStatus surlReturnStatus = new TSURLReturnStatus();
        try {
            surlReturnStatus.setSurl(new org.apache.axis.types.URI(this.getSurlString()));
        }
        catch (Exception e) {
            logger.error(e.toString());
            throw new SQLException("wrong surl format");
        }
        surlReturnStatus.setStatus(returnStatus);
        return surlReturnStatus;
    }

    private URI getTURL() throws SRMException, SQLException {
        String firstDcapTurl = null;
        GetRequest request = Job.getJob(this.requestId, GetRequest.class);
        if (request != null && (firstDcapTurl = request.getFirstDcapTurl()) == null) {
            URI turl = this.getStorage().getGetTurl(this.getUser(), this.getSurl(), request.protocols);
            if (turl == null) {
                throw new SRMException("turl is null");
            }
            if (turl.getScheme().equals("dcap")) {
                request.setFirstDcapTurl(turl.toString());
            }
            return turl;
        }
        return this.getStorage().getGetTurl(this.getUser(), this.getSurl(), URI.create(firstDcapTurl));
    }

    @Override
    public void toString(StringBuilder sb, boolean longformat) {
        sb.append(" GetFileRequest ");
        sb.append(" id:").append(this.getId());
        sb.append(" priority:").append(this.getPriority());
        sb.append(" creator priority:");
        try {
            sb.append(this.getUser().getPriority());
        }
        catch (SRMInvalidRequestException ire) {
            sb.append("Unknown");
        }
        State state = this.getState();
        sb.append(" state:").append((Object)state);
        if (longformat) {
            sb.append('\n').append("   SURL: ").append(this.getSurlString());
            sb.append('\n').append("   pinned: ").append(this.isPinned());
            String thePinId = this.getPinId();
            if (thePinId != null) {
                sb.append('\n').append("   pinid: ").append(thePinId);
            }
            sb.append('\n').append("   TURL: ").append(this.getTurlString());
            sb.append('\n').append("   status code:").append(this.getStatusCode());
            sb.append('\n').append("   error message:").append(this.getErrorMessage());
            sb.append('\n').append("   History of State Transitions: \n");
            sb.append(this.getHistory());
        }
    }

    @Override
    public synchronized void run() throws NonFatalJobFailure, FatalJobFailure {
        logger.debug("run()");
        try {
            if (this.getPinId() == null) {
                this.pinFile();
                if (this.getPinId() == null) {
                    this.setState(State.ASYNCWAIT, "pinning file");
                    logger.debug("GetFileRequest: waiting async notification about pinId...");
                    return;
                }
            }
        }
        catch (SRMException e) {
            logger.error(e.getMessage());
            throw new NonFatalJobFailure(e.toString());
        }
        catch (IllegalStateTransition ist) {
            throw new NonFatalJobFailure("Illegal State Transition : " + ist.getMessage());
        }
        logger.info("PinId is " + this.getPinId() + " returning, scheduler should change state to \"Ready\"");
    }

    public void pinFile() throws NonFatalJobFailure, FatalJobFailure, SRMException {
        GetRequest request = Job.getJob(this.requestId, GetRequest.class);
        if (!this.isProtocolSupported(request.protocols)) {
            throw new FatalJobFailure("Transfer protocols not supported");
        }
        URI surl = this.getSurl();
        logger.info("Pinning {}", (Object)surl);
        this.getStorage().pinFile(this.getUser(), surl, this.getRequest().getClient_host(), this.lifetime, this.getRequestId(), new ThePinCallbacks(this.getId()));
    }

    @Override
    protected void stateChanged(State oldState) {
        State state = this.getState();
        logger.debug("State changed from " + (Object)((Object)oldState) + " to " + (Object)((Object)this.getState()));
        if (state == State.READY) {
            try {
                this.getRequest().resetRetryDeltaTime();
            }
            catch (SRMInvalidRequestException ire) {
                logger.error(ire.toString());
            }
        }
        if (State.isFinalState(state) && this.getFileId() != null && this.getPinId() != null) {
            SRMUser user;
            TheUnpinCallbacks callbacks = new TheUnpinCallbacks(this.getId());
            logger.info("state changed to final state, unpinning fileId= " + this.getFileId() + " pinId = " + this.getPinId());
            try {
                user = this.getUser();
            }
            catch (SRMInvalidRequestException ire) {
                logger.error(ire.toString());
                return;
            }
            this.getStorage().unPinFile(user, this.getFileId(), callbacks, this.getPinId());
        }
        super.stateChanged(oldState);
    }

    @Override
    public TReturnStatus getReturnStatus() {
        TReturnStatus returnStatus = new TReturnStatus();
        State state = this.getState();
        returnStatus.setExplanation(state.toString());
        if (this.getStatusCode() != null) {
            returnStatus.setStatusCode(this.getStatusCode());
        } else if (state == State.DONE) {
            returnStatus.setStatusCode(TStatusCode.SRM_RELEASED);
        } else if (state == State.READY) {
            returnStatus.setStatusCode(TStatusCode.SRM_FILE_PINNED);
        } else if (state == State.TRANSFERRING) {
            returnStatus.setStatusCode(TStatusCode.SRM_FILE_PINNED);
        } else if (state == State.FAILED) {
            returnStatus.setStatusCode(TStatusCode.SRM_FAILURE);
            returnStatus.setExplanation("FAILED: " + this.getErrorMessage());
        } else if (state == State.CANCELED) {
            returnStatus.setStatusCode(TStatusCode.SRM_ABORTED);
        } else if (state == State.TQUEUED) {
            returnStatus.setStatusCode(TStatusCode.SRM_REQUEST_QUEUED);
        } else if (state == State.RUNNING || state == State.RQUEUED || state == State.ASYNCWAIT) {
            returnStatus.setStatusCode(TStatusCode.SRM_REQUEST_INPROGRESS);
        } else {
            returnStatus.setStatusCode(TStatusCode.SRM_REQUEST_QUEUED);
        }
        return returnStatus;
    }

    @Override
    public long extendLifetime(long newLifetime) throws SRMException {
        long remainingLifetime = this.getRemainingLifetime();
        if (remainingLifetime >= newLifetime) {
            return remainingLifetime;
        }
        long requestLifetime = this.getRequest().extendLifetimeMillis(newLifetime);
        if (requestLifetime < newLifetime) {
            newLifetime = requestLifetime;
        }
        if (remainingLifetime >= newLifetime) {
            return remainingLifetime;
        }
        if (remainingLifetime >= (newLifetime = this.extendLifetimeMillis(newLifetime))) {
            return remainingLifetime;
        }
        if (this.getPinId() == null) {
            return newLifetime;
        }
        SRMUser user = this.getUser();
        return this.getStorage().extendPinLifetime(user, this.getFileId(), this.getPinId(), newLifetime);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setTurl(URI turl) {
        this.wlock();
        try {
            this.turl = turl;
        }
        finally {
            this.wunlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void setFileId(String fileId) {
        this.wlock();
        try {
            this.fileId = fileId;
        }
        finally {
            this.wunlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final FileMetaData getFileMetaData() {
        this.rlock();
        try {
            FileMetaData fileMetaData = this.fileMetaData;
            return fileMetaData;
        }
        finally {
            this.runlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setFileMetaData(FileMetaData fileMetaData) {
        this.wlock();
        try {
            this.fileMetaData = fileMetaData;
        }
        finally {
            this.wunlock();
        }
    }

    private static class TheUnpinCallbacks
    implements UnpinCallbacks {
        Long fileRequestJobId;

        public TheUnpinCallbacks(Long fileRequestJobId) {
            this.fileRequestJobId = fileRequestJobId;
        }

        public GetFileRequest getGetFileRequest() throws SQLException, SRMInvalidRequestException {
            return Job.getJob(this.fileRequestJobId, GetFileRequest.class);
        }

        @Override
        public void Error(String error) {
            try {
                GetFileRequest fr = this.getGetFileRequest();
                logger.error("TheUnpinCallbacks error: " + error);
            }
            catch (Exception e) {
                logger.error(e.toString());
            }
        }

        @Override
        public void Exception(Exception e) {
            try {
                GetFileRequest fr = this.getGetFileRequest();
                logger.error("TheUnpinCallbacks exception", (Throwable)e);
            }
            catch (Exception e1) {
                logger.error(e1.toString());
            }
        }

        @Override
        public void Timeout() {
            try {
                GetFileRequest fr = this.getGetFileRequest();
                logger.error("TheUnpinCallbacks Timeout");
            }
            catch (Exception e) {
                logger.error(e.toString());
            }
        }

        @Override
        public void Unpinned(String pinId) {
            try {
                GetFileRequest fr = this.getGetFileRequest();
                logger.debug("TheUnpinCallbacks: Unpinned() pinId:" + pinId);
                State state = fr.getState();
                if (state == State.ASYNCWAIT) {
                    fr.setPinId(pinId);
                    Scheduler scheduler = Scheduler.getScheduler(fr.getSchedulerId());
                    try {
                        scheduler.schedule(fr);
                    }
                    catch (Exception ie) {
                        logger.error(ie.toString());
                    }
                }
            }
            catch (Exception e) {
                logger.error(e.toString());
            }
        }

        @Override
        public void UnpinningFailed(String reason) {
            try {
                GetFileRequest fr = this.getGetFileRequest();
                logger.error("TheUnpinCallbacks error: " + reason);
            }
            catch (Exception e) {
                logger.error(e.toString());
            }
        }
    }

    private static class ThePinCallbacks
    implements PinCallbacks {
        Long fileRequestJobId;

        public ThePinCallbacks(Long fileRequestJobId) {
            this.fileRequestJobId = fileRequestJobId;
        }

        public GetFileRequest getGetFileRequest() throws SRMInvalidRequestException {
            return Job.getJob(this.fileRequestJobId, GetFileRequest.class);
        }

        @Override
        public void FileNotFound(String reason) {
            try {
                GetFileRequest fr = this.getGetFileRequest();
                try {
                    fr.setStateAndStatusCode(State.FAILED, reason, TStatusCode.SRM_INVALID_PATH);
                }
                catch (IllegalStateTransition ist) {
                    logger.warn("Illegal State Transition : " + ist.getMessage());
                }
                logger.warn("GetCallbacks error: " + reason);
            }
            catch (Exception e) {
                logger.error(e.toString());
            }
        }

        @Override
        public void Unavailable(String reason) {
            try {
                GetFileRequest fr = this.getGetFileRequest();
                try {
                    fr.setStateAndStatusCode(State.FAILED, reason, TStatusCode.SRM_FILE_UNAVAILABLE);
                }
                catch (IllegalStateTransition ist) {
                    logger.warn("Illegal State Transition : " + ist.getMessage());
                }
                logger.error("GetCallbacks error: " + reason);
            }
            catch (Exception e) {
                logger.error(e.toString());
            }
        }

        @Override
        public void Error(String error) {
            try {
                GetFileRequest fr = this.getGetFileRequest();
                try {
                    fr.setState(State.FAILED, error);
                }
                catch (IllegalStateTransition ist) {
                    logger.warn("Illegal State Transition : " + ist.getMessage());
                }
                logger.error("ThePinCallbacks error: " + error);
            }
            catch (Exception e) {
                logger.error(e.toString());
            }
        }

        @Override
        public void Exception(Exception e) {
            try {
                GetFileRequest fr = this.getGetFileRequest();
                try {
                    fr.setState(State.FAILED, e.toString());
                }
                catch (IllegalStateTransition ist) {
                    logger.warn("Illegal State Transition : " + ist.getMessage());
                }
                logger.error("ThePinCallbacks exception", (Throwable)e);
            }
            catch (Exception e1) {
                logger.error(e1.toString());
            }
        }

        @Override
        public void Timeout() {
            try {
                GetFileRequest fr = this.getGetFileRequest();
                try {
                    fr.setState(State.FAILED, "ThePinCallbacks Timeout");
                }
                catch (IllegalStateTransition ist) {
                    logger.warn("Illegal State Transition : " + ist.getMessage());
                }
                logger.error("GetCallbacks Timeout");
            }
            catch (Exception e) {
                logger.error(e.toString());
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void Pinned(FileMetaData fileMetaData, String pinId) {
            try {
                logger.debug("File pinned (pinId={})", (Object)pinId);
                GetFileRequest fr = this.getGetFileRequest();
                fr.wlock();
                try {
                    State state = fr.getState();
                    if (state == State.ASYNCWAIT || state == State.RUNNING) {
                        fr.setFileId(fileMetaData.fileId);
                        fr.setFileMetaData(fileMetaData);
                        fr.setPinId(pinId);
                        if (state == State.ASYNCWAIT) {
                            Scheduler scheduler = Scheduler.getScheduler(fr.getSchedulerId());
                            scheduler.schedule(fr);
                        }
                    }
                }
                finally {
                    fr.wunlock();
                }
            }
            catch (InterruptedException e) {
                logger.error(e.getMessage());
                Thread.currentThread().interrupt();
            }
            catch (SRMInvalidRequestException e) {
                logger.error("BringOnlineFileRequest failed: {}", (Object)e.getMessage());
            }
            catch (IllegalStateTransition e) {
                logger.warn("Illegal State Transition: {}", (Object)e.getMessage());
            }
        }

        @Override
        public void PinningFailed(String reason) {
            try {
                GetFileRequest fr = this.getGetFileRequest();
                try {
                    fr.setState(State.FAILED, reason);
                }
                catch (IllegalStateTransition ist) {
                    logger.warn("Illegal State Transition : " + ist.getMessage());
                }
                logger.error("ThePinCallbacks error: " + reason);
            }
            catch (Exception e) {
                logger.error(e.toString());
            }
        }
    }
}

