/*
 * Decompiled with CFR 0.152.
 */
package org.dcache.srm.request;

import com.google.common.collect.ImmutableMap;
import org.dcache.srm.v2_2.TFileStorageType;

public enum FileStorageType {
    VOLATILE(TFileStorageType.VOLATILE),
    DURABLE(TFileStorageType.DURABLE),
    PERMANENT(TFileStorageType.PERMANENT);

    private final TFileStorageType _type;
    private static final ImmutableMap<TFileStorageType, FileStorageType> MAP;
    private static final String ERROR_MESSAGE;

    private FileStorageType(TFileStorageType type) {
        this._type = type;
    }

    public TFileStorageType toTFileStorageType() {
        return this._type;
    }

    public static FileStorageType fromTFileStorageType(TFileStorageType type) {
        if (type == null) {
            return null;
        }
        return (FileStorageType)((Object)MAP.get((Object)type));
    }

    public static FileStorageType fromString(String txt) throws IllegalArgumentException {
        try {
            TFileStorageType type = TFileStorageType.fromString(txt);
            return FileStorageType.fromTFileStorageType(type);
        }
        catch (IllegalArgumentException e) {
            throw new IllegalArgumentException(String.format(ERROR_MESSAGE, txt));
        }
    }

    static {
        StringBuilder sb = new StringBuilder();
        sb.append("Unknown FileStorageType: \"%s\".");
        sb.append(" Supported values :");
        ImmutableMap.Builder builder = new ImmutableMap.Builder();
        for (FileStorageType value : FileStorageType.values()) {
            builder.put((Object)value._type, (Object)value);
            sb.append(" \"").append(value._type).append("\"");
        }
        MAP = builder.build();
        ERROR_MESSAGE = sb.toString();
    }
}

