/*
 * Decompiled with CFR 0.152.
 */
package org.dcache.srm.qos.lambdastation;

import java.io.StringWriter;
import java.io.Writer;
import java.util.StringTokenizer;
import org.dcache.srm.qos.QOSTicket;
import org.dcache.srm.qos.lambdastation.LambdaStationMap;
import org.dcache.srm.util.ShellCommandExecuter;

public class LambdaStationTicket
implements QOSTicket {
    public String SrcSite = null;
    public String SrcClient = null;
    public String SrcIP = null;
    public String SrcPort = null;
    public String DstSite = null;
    public String DstClient = null;
    public String DstIP = null;
    public String DstPort = null;
    public String LocalPath = null;
    public String RemotePath = null;
    public String OutBW = null;
    public String InBW = null;
    public String DSCPrqOut = null;
    public String DSCPrqIn = null;
    public String BoardTime = null;
    public String StartTime = null;
    public String EndTime = null;
    public String TravelTime = null;
    public int DSCPin = 0;
    public int DSCPout = 0;
    private String LambdaStationId = null;
    private String credentialSubject;
    private int localTicketID = 0;
    private int remoteTicketID = 0;
    private long actualEndTime = 0L;
    public boolean srcEnabled = true;
    public boolean dstEnabled = true;
    public Long bytes;

    public LambdaStationTicket() {
    }

    public LambdaStationTicket(String credentialSubject) {
        this.credentialSubject = credentialSubject;
    }

    public LambdaStationTicket(String credentialSubject, long bytes, String srcURL, String srcClient, String srcPorts, String dstURL, String dstClient, String dstPorts, LambdaStationMap map) {
        this.credentialSubject = credentialSubject;
        this.SrcSite = map.getName(srcURL);
        this.SrcClient = srcClient;
        this.SrcPort = srcPorts;
        this.DstSite = map.getName(dstURL);
        this.DstClient = dstClient;
        this.DstPort = dstPorts;
        this.srcEnabled = map.enabled(srcURL);
        this.dstEnabled = map.enabled(dstURL);
    }

    public LambdaStationTicket(String credentialSubject, String srcURL, String srcClient, String dstURL, String dstClient, LambdaStationMap map) {
        this.credentialSubject = credentialSubject;
        this.SrcSite = map.getName(srcURL);
        this.SrcClient = srcClient;
        this.DstSite = map.getName(dstURL);
        this.DstClient = dstClient;
        this.srcEnabled = map.enabled(srcURL);
        this.dstEnabled = map.enabled(dstURL);
    }

    public LambdaStationTicket(String credentialSubject, String srcURL, String srcClient, String dstURL, String dstClient, int TravelTime, LambdaStationMap map) {
        this.credentialSubject = credentialSubject;
        this.SrcSite = map.getName(srcURL);
        this.SrcClient = srcClient;
        this.DstSite = map.getName(dstURL);
        this.DstClient = dstClient;
        this.TravelTime = Integer.toString(TravelTime);
        this.srcEnabled = map.enabled(srcURL);
        this.dstEnabled = map.enabled(dstURL);
    }

    public void OpenTicket(String script) {
        String c = null;
        if (System.getProperty("lambda") != null) {
            c = System.getProperty("lambda");
        } else if (script != null) {
            c = script;
        } else {
            this.say("AM: NO LS COMMAND");
            return;
        }
        if (!(this.srcEnabled & this.dstEnabled)) {
            return;
        }
        String[] cmd = new String[2];
        cmd[0] = c;
        String arguments = "";
        if (this.SrcSite != null) {
            arguments = arguments + "--srcSite " + this.SrcSite + " ";
        }
        if (this.SrcClient != null) {
            // empty if block
        }
        if (this.DstSite != null) {
            arguments = arguments + "--dstSite " + this.DstSite + " ";
        }
        if (this.DstClient != null) {
            // empty if block
        }
        if (this.TravelTime != null) {
            arguments = arguments + "--travelTime " + this.TravelTime + " ";
        }
        cmd[1] = "'" + arguments + "'";
        this.say("ARGS=" + arguments);
        StringWriter shell_out = new StringWriter();
        StringWriter shell_err = new StringWriter();
        int return_code = ShellCommandExecuter.execute(cmd, (Writer)shell_out, (Writer)shell_err);
        StringTokenizer responseTokenizer = new StringTokenizer(shell_out.getBuffer().toString(), ":");
        while (responseTokenizer.hasMoreElements()) {
            String tok = (String)responseTokenizer.nextElement();
            if (tok.equals("OK")) {
                tok = (String)responseTokenizer.nextElement();
                tok = (String)responseTokenizer.nextElement();
                StringTokenizer valTokenizer = new StringTokenizer(tok, ",");
                String tok1 = (String)valTokenizer.nextElement();
                if (tok1 == null) break;
                this.localTicketID = Integer.parseInt(tok1);
                tok1 = (String)valTokenizer.nextElement();
                if (tok1 == null) break;
                this.remoteTicketID = Integer.parseInt(tok1);
                tok1 = (String)valTokenizer.nextElement();
                if ((tok1 = tok1.trim()) == null) break;
                this.actualEndTime = Long.parseLong(tok1);
                break;
            }
            if (!tok.equals("ERROR")) continue;
            this.say("Lambda Station returned Error: " + shell_out.getBuffer().toString());
            break;
        }
    }

    public String getLambdaStationId() {
        return this.LambdaStationId;
    }

    public void setLambdaStationId(String lambdaStationId) {
        this.LambdaStationId = lambdaStationId;
    }

    public String toString() {
        return "SrcSite=" + this.SrcSite + " SrcClient=" + this.SrcClient + " SrcIP=" + this.SrcIP + " SrcPort=" + this.SrcPort + " DstSite=" + this.DstSite + " DstClient=" + this.DstClient + " DstIP=" + this.DstIP + " DstPort=" + this.DstPort + " LocalPath=" + this.LocalPath + " RemotePath=" + this.RemotePath + " OutBW=" + this.OutBW + " InBW=" + this.InBW + " DSCPrqOut=" + this.DSCPrqOut + " DSCPrqIn=" + this.DSCPrqIn + " BoardTime=" + this.BoardTime + " TravelTime=" + this.TravelTime + " StartTime=" + this.StartTime + " EndTime=" + this.EndTime + " DSCPin=" + this.DSCPin + " DSCPout=" + this.DSCPout + " credentialSubject=" + this.credentialSubject + " localTicketID=" + this.localTicketID + " remoteTicketID=" + this.remoteTicketID + " actualEndTime=" + this.actualEndTime;
    }

    public void say(String words) {
        System.out.println("LS_Ticket: " + words);
    }

    public String getCredentialSubject() {
        return this.credentialSubject;
    }

    public int getLocalTicketID() {
        return this.localTicketID;
    }

    public void setLocalTicketID(int ID) {
        this.localTicketID = ID;
    }

    public int getRemoteTicketID() {
        return this.remoteTicketID;
    }

    public void setRemoteTicketID(int ID) {
        this.localTicketID = ID;
    }

    public long getActualEndTime() {
        return this.actualEndTime;
    }

    public boolean srcEnabled() {
        return this.srcEnabled;
    }

    public boolean dstEnabled() {
        return this.dstEnabled;
    }

    public long getStartTime() {
        long l = 0L;
        if (this.StartTime != null) {
            l = Long.parseLong(this.StartTime.trim());
        }
        return l;
    }
}

