/*
 * Decompiled with CFR 0.152.
 */
package org.dcache.srm.handler;

import org.apache.axis.types.URI;
import org.dcache.srm.AbstractStorageElement;
import org.dcache.srm.SRM;
import org.dcache.srm.SRMException;
import org.dcache.srm.SRMUser;
import org.dcache.srm.request.RequestCredential;
import org.dcache.srm.request.ReserveSpaceRequest;
import org.dcache.srm.util.Configuration;
import org.dcache.srm.v2_2.SrmStatusOfReserveSpaceRequestRequest;
import org.dcache.srm.v2_2.SrmStatusOfReserveSpaceRequestResponse;
import org.dcache.srm.v2_2.TReturnStatus;
import org.dcache.srm.v2_2.TStatusCode;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SrmStatusOfReserveSpaceRequest {
    private static Logger logger = LoggerFactory.getLogger(SrmStatusOfReserveSpaceRequest.class);
    private static final String SFN_STRING = "?SFN=";
    AbstractStorageElement storage;
    SrmStatusOfReserveSpaceRequestRequest request;
    SrmStatusOfReserveSpaceRequestResponse response;
    SRMUser user;
    RequestCredential credential;
    Configuration configuration;

    public SrmStatusOfReserveSpaceRequest(SRMUser user, RequestCredential credential, SrmStatusOfReserveSpaceRequestRequest request, AbstractStorageElement storage, SRM srm, String client_host) {
        if (request == null) {
            throw new NullPointerException("request is null");
        }
        this.request = request;
        this.user = user;
        this.credential = credential;
        if (storage == null) {
            throw new NullPointerException("storage is null");
        }
        this.storage = storage;
        this.configuration = srm.getConfiguration();
        if (this.configuration == null) {
            throw new NullPointerException("configuration is null");
        }
    }

    public SrmStatusOfReserveSpaceRequestResponse getResponse() {
        if (this.response != null) {
            return this.response;
        }
        try {
            this.response = this.reserveSpaceStatus();
        }
        catch (URI.MalformedURIException mue) {
            logger.debug(" malformed uri : " + mue.getMessage());
            this.response = SrmStatusOfReserveSpaceRequest.getFailedResponse(" malformed uri : " + mue.getMessage(), TStatusCode.SRM_INVALID_REQUEST);
        }
        catch (SRMException srme) {
            logger.error(srme.toString());
            this.response = SrmStatusOfReserveSpaceRequest.getFailedResponse(srme.toString());
        }
        return this.response;
    }

    public static final SrmStatusOfReserveSpaceRequestResponse getFailedResponse(String text) {
        return SrmStatusOfReserveSpaceRequest.getFailedResponse(text, null);
    }

    public static final SrmStatusOfReserveSpaceRequestResponse getFailedResponse(String text, TStatusCode statusCode) {
        if (statusCode == null) {
            statusCode = TStatusCode.SRM_FAILURE;
        }
        SrmStatusOfReserveSpaceRequestResponse response = new SrmStatusOfReserveSpaceRequestResponse();
        TReturnStatus status = new TReturnStatus();
        status.setStatusCode(statusCode);
        status.setExplanation(text);
        response.setReturnStatus(status);
        return response;
    }

    public SrmStatusOfReserveSpaceRequestResponse reserveSpaceStatus() throws SRMException, URI.MalformedURIException {
        try {
            Long requestId;
            if (this.request == null) {
                return SrmStatusOfReserveSpaceRequest.getFailedResponse("srmStatusOfReserveSpaceRequest: null request passed to SrmStatusOfReserveSpaceRequest", TStatusCode.SRM_INVALID_REQUEST);
            }
            String requestIdStr = this.request.getRequestToken();
            if (requestIdStr == null) {
                return SrmStatusOfReserveSpaceRequest.getFailedResponse("srmStatusOfReserveSpaceRequest: null token passed to SrmStatusOfReserveSpaceRequest", TStatusCode.SRM_INVALID_REQUEST);
            }
            try {
                requestId = new Long(requestIdStr);
            }
            catch (Exception e) {
                return SrmStatusOfReserveSpaceRequest.getFailedResponse("srmStatusOfReserveSpaceRequest: invalid token=" + requestIdStr + "passed to SrmStatusOfReserveSpaceRequest", TStatusCode.SRM_INVALID_REQUEST);
            }
            ReserveSpaceRequest request = ReserveSpaceRequest.getRequest(requestId);
            if (request == null) {
                return SrmStatusOfReserveSpaceRequest.getFailedResponse("srmStatusOfReserveSpaceRequest: reserve space request for token=" + requestIdStr + " not found", TStatusCode.SRM_INVALID_REQUEST);
            }
            SrmStatusOfReserveSpaceRequestResponse resp = request.getSrmStatusOfReserveSpaceRequestResponse();
            return resp;
        }
        catch (Exception e) {
            return SrmStatusOfReserveSpaceRequest.getFailedResponse(e.toString(), TStatusCode.SRM_INTERNAL_ERROR);
        }
    }
}

