/*
 * Decompiled with CFR 0.152.
 */
package org.dcache.srm.handler;

import java.net.URI;
import java.net.URISyntaxException;
import java.sql.SQLException;
import org.dcache.srm.AbstractStorageElement;
import org.dcache.srm.SRM;
import org.dcache.srm.SRMException;
import org.dcache.srm.SRMInvalidRequestException;
import org.dcache.srm.SRMUser;
import org.dcache.srm.request.PutRequest;
import org.dcache.srm.request.RequestCredential;
import org.dcache.srm.request.sql.PutFileRequestStorage;
import org.dcache.srm.request.sql.PutRequestStorage;
import org.dcache.srm.scheduler.Job;
import org.dcache.srm.scheduler.Scheduler;
import org.dcache.srm.util.Configuration;
import org.dcache.srm.v2_2.SrmStatusOfPutRequestRequest;
import org.dcache.srm.v2_2.SrmStatusOfPutRequestResponse;
import org.dcache.srm.v2_2.TReturnStatus;
import org.dcache.srm.v2_2.TStatusCode;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SrmStatusOfPutRequest {
    private static Logger logger = LoggerFactory.getLogger(SrmStatusOfPutRequest.class);
    private static final String SFN_STRING = "?SFN=";
    AbstractStorageElement storage;
    SrmStatusOfPutRequestRequest statusOfPutRequestRequest;
    SrmStatusOfPutRequestResponse response;
    Scheduler putScheduler;
    SRMUser user;
    RequestCredential credential;
    PutRequestStorage putStorage;
    PutFileRequestStorage putFileRequestStorage;
    Configuration configuration;
    private int results_num;
    private int max_results_num;
    int numOfLevels = 0;
    boolean longFormat = false;
    String servicePathAndSFNPart = "";
    int port;
    String host;

    public SrmStatusOfPutRequest(SRMUser user, RequestCredential credential, SrmStatusOfPutRequestRequest statusOfPutRequestRequest, AbstractStorageElement storage, SRM srm, String client_host) {
        this.statusOfPutRequestRequest = statusOfPutRequestRequest;
        this.user = user;
        this.credential = credential;
        this.storage = storage;
        this.putScheduler = srm.getPutRequestScheduler();
        this.configuration = srm.getConfiguration();
    }

    public SrmStatusOfPutRequestResponse getResponse() {
        if (this.response != null) {
            return this.response;
        }
        try {
            this.response = this.srmPutStatus();
        }
        catch (URISyntaxException e) {
            logger.debug(" malformed uri : " + e.getMessage());
            this.response = SrmStatusOfPutRequest.getFailedResponse(" malformed uri : " + e.getMessage(), TStatusCode.SRM_INVALID_REQUEST);
        }
        catch (SQLException sqle) {
            logger.error(sqle.toString());
            this.response = SrmStatusOfPutRequest.getFailedResponse("sql error " + sqle.getMessage(), TStatusCode.SRM_INTERNAL_ERROR);
        }
        catch (SRMInvalidRequestException e) {
            logger.error(e.toString());
            this.response = SrmStatusOfPutRequest.getFailedResponse(e.getMessage(), TStatusCode.SRM_INVALID_REQUEST);
        }
        catch (SRMException srme) {
            logger.error(srme.toString());
            this.response = SrmStatusOfPutRequest.getFailedResponse(srme.toString());
        }
        return this.response;
    }

    public static final SrmStatusOfPutRequestResponse getFailedResponse(String error) {
        return SrmStatusOfPutRequest.getFailedResponse(error, null);
    }

    public static final SrmStatusOfPutRequestResponse getFailedResponse(String error, TStatusCode statusCode) {
        if (statusCode == null) {
            statusCode = TStatusCode.SRM_FAILURE;
        }
        TReturnStatus status = new TReturnStatus();
        status.setStatusCode(statusCode);
        status.setExplanation(error);
        SrmStatusOfPutRequestResponse srmPrepareToPutResponse = new SrmStatusOfPutRequestResponse();
        srmPrepareToPutResponse.setReturnStatus(status);
        return srmPrepareToPutResponse;
    }

    private static URI[] toUris(org.apache.axis.types.URI[] uris) throws URISyntaxException {
        URI[] result = new URI[uris.length];
        for (int i = 0; i < uris.length; ++i) {
            result[i] = new URI(uris[i].toString());
        }
        return result;
    }

    public SrmStatusOfPutRequestResponse srmPutStatus() throws SRMException, URISyntaxException, SQLException {
        Long requestId;
        String requestToken = this.statusOfPutRequestRequest.getRequestToken();
        if (requestToken == null) {
            return SrmStatusOfPutRequest.getFailedResponse("request contains no request token");
        }
        try {
            requestId = new Long(requestToken);
        }
        catch (NumberFormatException nfe) {
            return SrmStatusOfPutRequest.getFailedResponse(" requestToken \"" + requestToken + "\"is not valid", TStatusCode.SRM_FAILURE);
        }
        PutRequest putRequest = Job.getJob(requestId, PutRequest.class);
        if (this.statusOfPutRequestRequest.getArrayOfTargetSURLs() == null) {
            return putRequest.getSrmStatusOfPutRequestResponse();
        }
        URI[] surls = SrmStatusOfPutRequest.toUris(this.statusOfPutRequestRequest.getArrayOfTargetSURLs().getUrlArray());
        if (surls.length == 0) {
            return putRequest.getSrmStatusOfPutRequestResponse();
        }
        return putRequest.getSrmStatusOfPutRequestResponse(surls);
    }
}

