/*
 * Decompiled with CFR 0.152.
 */
package org.dcache.srm.handler;

import java.sql.SQLException;
import org.apache.axis.types.URI;
import org.dcache.srm.AbstractStorageElement;
import org.dcache.srm.SRM;
import org.dcache.srm.SRMException;
import org.dcache.srm.SRMInvalidRequestException;
import org.dcache.srm.SRMUser;
import org.dcache.srm.request.LsRequest;
import org.dcache.srm.request.RequestCredential;
import org.dcache.srm.request.sql.LsFileRequestStorage;
import org.dcache.srm.request.sql.LsRequestStorage;
import org.dcache.srm.scheduler.Job;
import org.dcache.srm.util.Configuration;
import org.dcache.srm.v2_2.SrmStatusOfLsRequestRequest;
import org.dcache.srm.v2_2.SrmStatusOfLsRequestResponse;
import org.dcache.srm.v2_2.TReturnStatus;
import org.dcache.srm.v2_2.TStatusCode;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SrmStatusOfLsRequest {
    private static Logger logger = LoggerFactory.getLogger(SrmStatusOfLsRequest.class);
    private static final String SFN_STRING = "?SFN=";
    AbstractStorageElement storage;
    SrmStatusOfLsRequestRequest request;
    SrmStatusOfLsRequestResponse response;
    SRMUser user;
    RequestCredential credential;
    LsRequestStorage requestStorage;
    LsFileRequestStorage fileRequestStorage;
    Configuration configuration;
    private int results_num;
    private int max_results_num;
    int numOfLevels = 0;
    boolean longFormat = false;
    String servicePathAndSFNPart = "";
    int port;
    String host;

    public SrmStatusOfLsRequest(SRMUser user, RequestCredential credential, SrmStatusOfLsRequestRequest request, AbstractStorageElement storage, SRM srm, String client_host) {
        this.request = request;
        this.user = user;
        this.credential = credential;
        this.storage = storage;
        this.configuration = srm.getConfiguration();
    }

    public SrmStatusOfLsRequestResponse getResponse() {
        if (this.response != null) {
            return this.response;
        }
        try {
            this.response = this.srmStatusOfLsRequest();
        }
        catch (URI.MalformedURIException mue) {
            logger.debug(" malformed uri : " + mue.getMessage());
            this.response = SrmStatusOfLsRequest.getFailedResponse(" malformed uri : " + mue.getMessage(), TStatusCode.SRM_INVALID_REQUEST);
        }
        catch (SQLException sqle) {
            logger.error(sqle.toString());
            this.response = SrmStatusOfLsRequest.getFailedResponse("sql error " + sqle.getMessage(), TStatusCode.SRM_INTERNAL_ERROR);
        }
        catch (SRMInvalidRequestException e) {
            logger.error(e.toString());
            this.response = SrmStatusOfLsRequest.getFailedResponse(e.getMessage(), TStatusCode.SRM_INVALID_REQUEST);
        }
        catch (SRMException srme) {
            logger.error(srme.toString());
            this.response = SrmStatusOfLsRequest.getFailedResponse(srme.toString());
        }
        return this.response;
    }

    public static final SrmStatusOfLsRequestResponse getFailedResponse(String error) {
        return SrmStatusOfLsRequest.getFailedResponse(error, null);
    }

    public static final SrmStatusOfLsRequestResponse getFailedResponse(String error, TStatusCode statusCode) {
        if (statusCode == null) {
            statusCode = TStatusCode.SRM_FAILURE;
        }
        TReturnStatus status = new TReturnStatus();
        status.setStatusCode(statusCode);
        status.setExplanation(error);
        SrmStatusOfLsRequestResponse srmStatusOfLsRequestResponse = new SrmStatusOfLsRequestResponse();
        srmStatusOfLsRequestResponse.setReturnStatus(status);
        return srmStatusOfLsRequestResponse;
    }

    public SrmStatusOfLsRequestResponse srmStatusOfLsRequest() throws SRMException, URI.MalformedURIException, SQLException {
        Long requestId;
        String requestToken = this.request.getRequestToken();
        if (requestToken == null) {
            return SrmStatusOfLsRequest.getFailedResponse("request contains no request token");
        }
        try {
            requestId = new Long(requestToken);
        }
        catch (NumberFormatException nfe) {
            return SrmStatusOfLsRequest.getFailedResponse(" requestToken \"" + requestToken + "\"is not valid", TStatusCode.SRM_FAILURE);
        }
        LsRequest request = Job.getJob(requestId, LsRequest.class);
        return request.getSrmStatusOfLsRequestResponse();
    }
}

