/*
 * Decompiled with CFR 0.152.
 */
package org.dcache.srm.handler;

import org.apache.axis.types.URI;
import org.dcache.srm.AbstractStorageElement;
import org.dcache.srm.SRM;
import org.dcache.srm.SRMException;
import org.dcache.srm.SRMUser;
import org.dcache.srm.request.RequestCredential;
import org.dcache.srm.request.ReserveSpaceRequest;
import org.dcache.srm.util.Configuration;
import org.dcache.srm.v2_2.SrmReserveSpaceRequest;
import org.dcache.srm.v2_2.SrmReserveSpaceResponse;
import org.dcache.srm.v2_2.TAccessLatency;
import org.dcache.srm.v2_2.TRetentionPolicy;
import org.dcache.srm.v2_2.TRetentionPolicyInfo;
import org.dcache.srm.v2_2.TReturnStatus;
import org.dcache.srm.v2_2.TStatusCode;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SrmReserveSpace {
    private static Logger logger = LoggerFactory.getLogger(SrmReserveSpace.class);
    private static final String SFN_STRING = "?SFN=";
    AbstractStorageElement storage;
    SrmReserveSpaceRequest request;
    SrmReserveSpaceResponse response;
    SRMUser user;
    RequestCredential credential;
    Configuration configuration;
    private String client_host;

    public SrmReserveSpace(SRMUser user, RequestCredential credential, SrmReserveSpaceRequest request, AbstractStorageElement storage, SRM srm, String client_host) {
        if (request == null) {
            throw new NullPointerException("request is null");
        }
        this.request = request;
        this.user = user;
        this.credential = credential;
        if (storage == null) {
            throw new NullPointerException("storage is null");
        }
        this.storage = storage;
        this.configuration = srm.getConfiguration();
        if (this.configuration == null) {
            throw new NullPointerException("configuration is null");
        }
        this.client_host = client_host;
    }

    public SrmReserveSpaceResponse getResponse() {
        if (this.response != null) {
            return this.response;
        }
        try {
            this.response = this.reserveSpace();
        }
        catch (URI.MalformedURIException mue) {
            logger.debug(" malformed uri : " + mue.getMessage());
            this.response = SrmReserveSpace.getFailedResponse(" malformed uri : " + mue.getMessage(), TStatusCode.SRM_INVALID_REQUEST);
        }
        catch (SRMException srme) {
            logger.error(srme.toString());
            this.response = SrmReserveSpace.getFailedResponse(srme.toString());
        }
        return this.response;
    }

    public static final SrmReserveSpaceResponse getFailedResponse(String text) {
        return SrmReserveSpace.getFailedResponse(text, null);
    }

    public static final SrmReserveSpaceResponse getFailedResponse(String text, TStatusCode statusCode) {
        if (statusCode == null) {
            statusCode = TStatusCode.SRM_FAILURE;
        }
        SrmReserveSpaceResponse response = new SrmReserveSpaceResponse();
        TReturnStatus returnStatus = new TReturnStatus();
        TReturnStatus status = new TReturnStatus();
        status.setStatusCode(statusCode);
        status.setExplanation(text);
        response.setReturnStatus(status);
        return response;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public SrmReserveSpaceResponse reserveSpace() throws SRMException, URI.MalformedURIException {
        long lifetimeInSeconds;
        if (this.request == null) {
            return SrmReserveSpace.getFailedResponse("srmReserveSpace: null request passed to SrmReserveSpace", TStatusCode.SRM_INVALID_REQUEST);
        }
        long sizeInBytes = this.request.getDesiredSizeOfGuaranteedSpace().longValue();
        TRetentionPolicy retentionPolicy = null;
        TAccessLatency accessLatency = null;
        TRetentionPolicyInfo retentionPolicyInfo = this.request.getRetentionPolicyInfo();
        if (retentionPolicyInfo == null) {
            return SrmReserveSpace.getFailedResponse("srmReserveSpace: retentionPolicyInfo == null", TStatusCode.SRM_INVALID_REQUEST);
        }
        retentionPolicy = retentionPolicyInfo.getRetentionPolicy();
        if (retentionPolicy == null) {
            return SrmReserveSpace.getFailedResponse("srmReserveSpace: retentionPolicy == null", TStatusCode.SRM_INVALID_REQUEST);
        }
        accessLatency = retentionPolicyInfo.getAccessLatency();
        String description = this.request.getUserSpaceTokenDescription();
        if (this.request.getDesiredLifetimeOfReservedSpace() != null) {
            if (this.request.getDesiredLifetimeOfReservedSpace() != -1 && this.request.getDesiredLifetimeOfReservedSpace() <= 0) return SrmReserveSpace.getFailedResponse("srmReserveSpace: DesiredLifetimeOfReservedSpace() == " + this.request.getDesiredLifetimeOfReservedSpace(), TStatusCode.SRM_INVALID_REQUEST);
            lifetimeInSeconds = this.request.getDesiredLifetimeOfReservedSpace().intValue();
        } else {
            lifetimeInSeconds = this.configuration.getDefaultSpaceLifetime();
        }
        long requestLifetime = lifetimeInSeconds == -1L || lifetimeInSeconds > 86400L ? 86400L : lifetimeInSeconds;
        try {
            ReserveSpaceRequest reserveRequest = new ReserveSpaceRequest(this.credential.getId(), this.user, requestLifetime * 1000L, 3, sizeInBytes, lifetimeInSeconds == -1L ? -1L : lifetimeInSeconds * 1000L, retentionPolicy, accessLatency, description, this.client_host);
            reserveRequest.schedule();
            return reserveRequest.getSrmReserveSpaceResponse();
        }
        catch (Exception e) {
            logger.warn(e.toString());
            return SrmReserveSpace.getFailedResponse(e.toString(), TStatusCode.SRM_INTERNAL_ERROR);
        }
    }
}

