/*
 * Decompiled with CFR 0.152.
 */
package org.dcache.srm.handler;

import org.apache.axis.types.URI;
import org.dcache.srm.AbstractStorageElement;
import org.dcache.srm.SRM;
import org.dcache.srm.SRMException;
import org.dcache.srm.SRMUser;
import org.dcache.srm.request.RequestCredential;
import org.dcache.srm.scheduler.Scheduler;
import org.dcache.srm.util.Configuration;
import org.dcache.srm.v2_2.SrmReleaseSpaceRequest;
import org.dcache.srm.v2_2.SrmReleaseSpaceResponse;
import org.dcache.srm.v2_2.TReturnStatus;
import org.dcache.srm.v2_2.TStatusCode;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SrmReleaseSpace {
    private static Logger logger = LoggerFactory.getLogger(SrmReleaseSpace.class);
    private static final String SFN_STRING = "?SFN=";
    AbstractStorageElement storage;
    SrmReleaseSpaceRequest request;
    SrmReleaseSpaceResponse response;
    SRMUser user;
    Scheduler scheduler;
    RequestCredential credential;
    Configuration configuration;
    TReturnStatus status = new TReturnStatus();

    public SrmReleaseSpace(SRMUser user, RequestCredential credential, SrmReleaseSpaceRequest request, AbstractStorageElement storage, SRM srm, String client_host) {
        if (request == null) {
            throw new NullPointerException("request is null");
        }
        this.request = request;
        this.user = user;
        this.credential = credential;
        if (storage == null) {
            throw new NullPointerException("storage is null");
        }
        this.storage = storage;
        this.scheduler = srm.getCopyRequestScheduler();
        if (this.scheduler == null) {
            throw new NullPointerException("scheduler is null");
        }
        this.configuration = srm.getConfiguration();
        if (this.configuration == null) {
            throw new NullPointerException("configuration is null");
        }
    }

    public SrmReleaseSpaceResponse getResponse() {
        if (this.response != null) {
            return this.response;
        }
        try {
            this.response = this.releaseSpace();
        }
        catch (URI.MalformedURIException mue) {
            logger.debug(" malformed uri : " + mue.getMessage());
            this.response = SrmReleaseSpace.getFailedResponse(" malformed uri : " + mue.getMessage(), TStatusCode.SRM_INVALID_REQUEST);
        }
        catch (SRMException srme) {
            logger.error(srme.toString());
            this.response = SrmReleaseSpace.getFailedResponse(srme.toString());
        }
        return this.response;
    }

    public static final SrmReleaseSpaceResponse getFailedResponse(String text) {
        return SrmReleaseSpace.getFailedResponse(text, null);
    }

    public static final SrmReleaseSpaceResponse getFailedResponse(String text, TStatusCode statusCode) {
        if (statusCode == null) {
            statusCode = TStatusCode.SRM_FAILURE;
        }
        SrmReleaseSpaceResponse response = new SrmReleaseSpaceResponse();
        TReturnStatus returnStatus = new TReturnStatus();
        TReturnStatus status = new TReturnStatus();
        status.setStatusCode(statusCode);
        status.setExplanation(text);
        response.setReturnStatus(status);
        return response;
    }

    public SrmReleaseSpaceResponse releaseSpace() throws SRMException, URI.MalformedURIException {
        if (this.request == null) {
            return SrmReleaseSpace.getFailedResponse("srmReleaseSpace: null request passed to SrmReleaseSpace", TStatusCode.SRM_INVALID_REQUEST);
        }
        String token = this.request.getSpaceToken();
        SrmReleaseSpaceCallbacks callbacks = new SrmReleaseSpaceCallbacks();
        this.storage.srmReleaseSpace(this.user, token, null, callbacks);
        callbacks.waitResult(60000L);
        SrmReleaseSpaceResponse response = new SrmReleaseSpaceResponse();
        response.setReturnStatus(this.status);
        return response;
    }

    public String toString() {
        return "SrmReleaseSpace(" + this.request.getSpaceToken() + ")";
    }

    private class SrmReleaseSpaceCallbacks
    implements org.dcache.srm.SrmReleaseSpaceCallbacks {
        private boolean completed;

        public synchronized void waitResult(long timeout) {
            long start;
            long current = start = System.currentTimeMillis();
            while (!this.completed) {
                long wait = timeout - (current - start);
                if (wait > 0L) {
                    try {
                        this.wait(wait);
                    }
                    catch (InterruptedException ie) {}
                } else {
                    SrmReleaseSpace.this.status.setStatusCode(TStatusCode.SRM_INTERNAL_ERROR);
                    SrmReleaseSpace.this.status.setExplanation("release takes longer then " + timeout + " millis");
                    return;
                }
                current = System.currentTimeMillis();
            }
            return;
        }

        public synchronized void complete() {
            this.completed = true;
            this.notifyAll();
        }

        @Override
        public void ReleaseSpaceFailed(String reason) {
            SrmReleaseSpace.this.status.setStatusCode(TStatusCode.SRM_FAILURE);
            SrmReleaseSpace.this.status.setExplanation(reason);
            this.complete();
        }

        @Override
        public void SpaceReleased(String spaceReservationToken, long remainingSpaceSize) {
            SrmReleaseSpace.this.status.setStatusCode(TStatusCode.SRM_SUCCESS);
            SrmReleaseSpace.this.status.setExplanation("Space released");
            this.complete();
        }

        @Override
        public void ReleaseSpaceFailed(Exception e) {
            SrmReleaseSpace.this.status.setStatusCode(TStatusCode.SRM_FAILURE);
            SrmReleaseSpace.this.status.setExplanation(e.toString());
            this.complete();
        }
    }
}

