/*
 * Decompiled with CFR 0.152.
 */
package org.dcache.srm.handler;

import java.net.URI;
import java.net.URISyntaxException;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.apache.axis.types.URI;
import org.dcache.srm.AbstractStorageElement;
import org.dcache.srm.SRM;
import org.dcache.srm.SRMException;
import org.dcache.srm.SRMInvalidRequestException;
import org.dcache.srm.SRMUser;
import org.dcache.srm.request.BringOnlineFileRequest;
import org.dcache.srm.request.BringOnlineRequest;
import org.dcache.srm.request.ContainerRequest;
import org.dcache.srm.request.FileRequest;
import org.dcache.srm.request.GetFileRequest;
import org.dcache.srm.request.GetRequest;
import org.dcache.srm.request.RequestCredential;
import org.dcache.srm.request.sql.DatabaseFileRequestStorage;
import org.dcache.srm.scheduler.IllegalStateTransition;
import org.dcache.srm.scheduler.Job;
import org.dcache.srm.scheduler.JobStorage;
import org.dcache.srm.scheduler.JobStorageFactory;
import org.dcache.srm.scheduler.Scheduler;
import org.dcache.srm.scheduler.SchedulerFactory;
import org.dcache.srm.scheduler.State;
import org.dcache.srm.util.Configuration;
import org.dcache.srm.v2_2.ArrayOfTSURLReturnStatus;
import org.dcache.srm.v2_2.SrmReleaseFilesRequest;
import org.dcache.srm.v2_2.SrmReleaseFilesResponse;
import org.dcache.srm.v2_2.TReturnStatus;
import org.dcache.srm.v2_2.TSURLReturnStatus;
import org.dcache.srm.v2_2.TStatusCode;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SrmReleaseFiles {
    private static final Logger logger = LoggerFactory.getLogger((String)SrmReleaseFiles.class.getName());
    private static final String SFN_STRING = "?SFN=";
    AbstractStorageElement storage;
    SrmReleaseFilesRequest srmReleaseFilesRequest;
    SrmReleaseFilesResponse response;
    Scheduler getScheduler;
    SRMUser user;
    RequestCredential credential;
    Configuration configuration;
    private int results_num;
    private int max_results_num;
    int numOfLevels = 0;
    SRM srm;
    boolean longFormat = false;
    String servicePathAndSFNPart = "";
    int port;
    String host;

    public SrmReleaseFiles(SRMUser user, RequestCredential credential, SrmReleaseFilesRequest srmReleaseFilesRequest, AbstractStorageElement storage, SRM srm, String client_host) {
        logger.info("SrmReleaseFiles user=" + user);
        this.srmReleaseFilesRequest = srmReleaseFilesRequest;
        this.user = user;
        this.credential = credential;
        this.storage = storage;
        this.getScheduler = srm.getGetRequestScheduler();
        this.configuration = srm.getConfiguration();
        this.srm = srm;
    }

    public SrmReleaseFilesResponse getResponse() {
        if (this.response != null) {
            return this.response;
        }
        try {
            this.response = this.srmReleaseFiles();
        }
        catch (URI.MalformedURIException e) {
            logger.debug(" malformed uri : " + e.getMessage());
            this.response = SrmReleaseFiles.getFailedResponse(" malformed uri : " + e.getMessage(), TStatusCode.SRM_INVALID_REQUEST);
        }
        catch (URISyntaxException e) {
            logger.debug(" malformed uri : " + e.getMessage());
            this.response = SrmReleaseFiles.getFailedResponse(" malformed uri : " + e.getMessage(), TStatusCode.SRM_INVALID_REQUEST);
        }
        catch (SQLException sqle) {
            logger.error(sqle.toString());
            this.response = SrmReleaseFiles.getFailedResponse("sql error " + sqle.getMessage(), TStatusCode.SRM_INTERNAL_ERROR);
        }
        catch (SRMInvalidRequestException ire) {
            this.response = SrmReleaseFiles.getFailedResponse(ire.toString(), TStatusCode.SRM_INVALID_REQUEST);
        }
        catch (SRMException srme) {
            logger.error(srme.toString());
            this.response = SrmReleaseFiles.getFailedResponse(srme.toString());
        }
        catch (IllegalStateTransition ist) {
            logger.error("Illegal State Transition : " + ist.getMessage());
            this.response = SrmReleaseFiles.getFailedResponse("Illegal State Transition : " + ist.getMessage());
        }
        return this.response;
    }

    private static URI[] toUris(org.apache.axis.types.URI[] uris) throws URISyntaxException {
        URI[] result = new URI[uris.length];
        for (int i = 0; i < uris.length; ++i) {
            result[i] = new URI(uris[i].toString());
        }
        return result;
    }

    public static final SrmReleaseFilesResponse getFailedResponse(String error) {
        return SrmReleaseFiles.getFailedResponse(error, null);
    }

    public static final SrmReleaseFilesResponse getFailedResponse(String error, TStatusCode statusCode) {
        if (statusCode == null) {
            statusCode = TStatusCode.SRM_FAILURE;
        }
        logger.error("getFailedResponse: " + error + " StatusCode " + statusCode);
        TReturnStatus status = new TReturnStatus();
        status.setStatusCode(statusCode);
        status.setExplanation(error);
        SrmReleaseFilesResponse srmReleaseFilesResponse = new SrmReleaseFilesResponse();
        srmReleaseFilesResponse.setReturnStatus(status);
        return srmReleaseFilesResponse;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public SrmReleaseFilesResponse srmReleaseFiles() throws SRMException, URISyntaxException, URI.MalformedURIException, SQLException, IllegalStateTransition {
        URI[] surls;
        String requestToken = this.srmReleaseFilesRequest.getRequestToken();
        Long requestId = null;
        if (requestToken != null) {
            try {
                requestId = Long.valueOf(requestToken);
            }
            catch (NumberFormatException nfe) {
                return SrmReleaseFiles.getFailedResponse(" requestToken \"" + requestToken + "\"is not valid", TStatusCode.SRM_INVALID_REQUEST);
            }
        }
        if (this.srmReleaseFilesRequest.getArrayOfSURLs() == null) {
            if (requestToken == null) {
                return SrmReleaseFiles.getFailedResponse("request contains no request token and no SURLs", TStatusCode.SRM_NOT_SUPPORTED);
            }
            surls = null;
        } else {
            if (requestToken == null) {
                URI[] surls2 = SrmReleaseFiles.toUris(this.srmReleaseFilesRequest.getArrayOfSURLs().getUrlArray());
                return this.unpinDirectlyBySURLs(surls2);
            }
            surls = SrmReleaseFiles.toUris(this.srmReleaseFilesRequest.getArrayOfSURLs().getUrlArray());
        }
        ContainerRequest request = Job.getJob(requestId, ContainerRequest.class);
        if (!(request instanceof GetRequest) && !(request instanceof BringOnlineRequest)) {
            return SrmReleaseFiles.getFailedResponse("request for requestToken \"" + requestToken + "\"is not srmPrepareToGet or srmBringOnlineRequest request", TStatusCode.SRM_INVALID_REQUEST);
        }
        if (surls == null) {
            if (!(request instanceof GetRequest)) {
                BringOnlineRequest bringOnlineRequest = (BringOnlineRequest)request;
                return bringOnlineRequest.releaseFiles(null);
            }
            request.setState(State.DONE, "SrmReleaseFiles called");
        } else {
            if (surls.length == 0) {
                return SrmReleaseFiles.getFailedResponse("0 lenght SiteURLs array");
            }
            if (!(request instanceof GetRequest)) {
                BringOnlineRequest bringOnlineRequest = (BringOnlineRequest)request;
                return bringOnlineRequest.releaseFiles(surls);
            }
            for (int i = 0; i < surls.length; ++i) {
                FileRequest fileRequest = request.getFileRequestBySurl(surls[i]);
                fileRequest.setState(State.DONE, "SrmReleaseFiles called");
            }
        }
        TReturnStatus status = new TReturnStatus();
        status.setStatusCode(TStatusCode.SRM_SUCCESS);
        SrmReleaseFilesResponse srmReleaseFilesResponse = new SrmReleaseFilesResponse();
        srmReleaseFilesResponse.setReturnStatus(status);
        if (surls != null) {
            TSURLReturnStatus[] surlReturnStatusArray;
            for (TSURLReturnStatus surlReturnStatus : surlReturnStatusArray = request.getArrayOfTSURLReturnStatus(surls)) {
                if (surlReturnStatus.getStatus().getStatusCode() != TStatusCode.SRM_RELEASED) continue;
                surlReturnStatus.getStatus().setStatusCode(TStatusCode.SRM_SUCCESS);
            }
            srmReleaseFilesResponse.setArrayOfFileStatuses(new ArrayOfTSURLReturnStatus(surlReturnStatusArray));
        }
        request.getTReturnStatus();
        return srmReleaseFilesResponse;
    }

    private SrmReleaseFilesResponse unpinFilesDirectlyBySURLAndRequestId(long requestId, URI[] surls) throws URI.MalformedURIException {
        TSURLReturnStatus[] surlReturnStatusArray = new TSURLReturnStatus[surls.length];
        int failure_num = 0;
        for (int i = 0; i < surls.length; ++i) {
            URI surl = surls[i];
            surlReturnStatusArray[i] = new TSURLReturnStatus();
            surlReturnStatusArray[i].setSurl(new org.apache.axis.types.URI(surl.toASCIIString()));
            try {
                BringOnlineFileRequest.unpinBySURLandRequestId(this.storage, this.user, requestId, surl);
                surlReturnStatusArray[i].setStatus(new TReturnStatus(TStatusCode.SRM_SUCCESS, "released"));
                continue;
            }
            catch (Exception e) {
                surlReturnStatusArray[i].setStatus(new TReturnStatus(TStatusCode.SRM_FAILURE, "release failed: " + e));
                ++failure_num;
            }
        }
        TReturnStatus status = new TReturnStatus();
        if (failure_num == 0) {
            status.setStatusCode(TStatusCode.SRM_SUCCESS);
        } else if (failure_num < surls.length) {
            status.setStatusCode(TStatusCode.SRM_PARTIAL_SUCCESS);
        } else {
            status.setStatusCode(TStatusCode.SRM_FAILURE);
        }
        SrmReleaseFilesResponse srmReleaseFilesResponse = new SrmReleaseFilesResponse();
        srmReleaseFilesResponse.setReturnStatus(status);
        srmReleaseFilesResponse.setArrayOfFileStatuses(new ArrayOfTSURLReturnStatus(surlReturnStatusArray));
        return srmReleaseFilesResponse;
    }

    private SrmReleaseFilesResponse unpinDirectlyBySURLs(URI[] surls) throws SQLException, IllegalStateTransition, SRMInvalidRequestException, URI.MalformedURIException {
        HashMap<URI, TSURLReturnStatus> surlsMap = new HashMap<URI, TSURLReturnStatus>();
        for (URI surl : surls) {
            TSURLReturnStatus rs = new TSURLReturnStatus();
            rs.setSurl(new org.apache.axis.types.URI(surl.toASCIIString()));
            rs.setStatus(new TReturnStatus(TStatusCode.SRM_INTERNAL_ERROR, "not released"));
            surlsMap.put(surl, rs);
        }
        this.releaseFileRequestsDirectlyBySURLs(surls, surlsMap);
        this.unpinFilesDirectlyBySURLs(surls, surlsMap);
        int failure_num = 0;
        TSURLReturnStatus[] surlReturnStatusArray = new TSURLReturnStatus[surls.length];
        for (int i = 0; i < surls.length; ++i) {
            TSURLReturnStatus rs = (TSURLReturnStatus)surlsMap.get(surls[i]);
            if (!rs.getStatus().getStatusCode().equals(TStatusCode.SRM_SUCCESS)) {
                ++failure_num;
            }
            surlReturnStatusArray[i] = rs;
        }
        TReturnStatus status = new TReturnStatus();
        if (failure_num == 0) {
            status.setStatusCode(TStatusCode.SRM_SUCCESS);
        } else if (failure_num < surls.length) {
            status.setStatusCode(TStatusCode.SRM_PARTIAL_SUCCESS);
        } else {
            status.setStatusCode(TStatusCode.SRM_FAILURE);
        }
        SrmReleaseFilesResponse srmReleaseFilesResponse = new SrmReleaseFilesResponse();
        srmReleaseFilesResponse.setReturnStatus(status);
        srmReleaseFilesResponse.setArrayOfFileStatuses(new ArrayOfTSURLReturnStatus(surlReturnStatusArray));
        return srmReleaseFilesResponse;
    }

    private void unpinFilesDirectlyBySURLs(URI[] surls, Map<URI, TSURLReturnStatus> surlsMap) {
        for (URI surl : surls) {
            TSURLReturnStatus rs = surlsMap.get(surl);
            try {
                BringOnlineFileRequest.unpinBySURL(this.storage, this.user, surl);
                rs.setStatus(new TReturnStatus(TStatusCode.SRM_SUCCESS, "released"));
            }
            catch (Exception e) {
                logger.warn(e.toString());
                if (!rs.getStatus().getStatusCode().equals(TStatusCode.SRM_INTERNAL_ERROR)) continue;
                rs.setStatus(new TReturnStatus(TStatusCode.SRM_FAILURE, "release failed: " + e));
            }
        }
    }

    private void releaseFileRequestsDirectlyBySURLs(URI[] surls, Map<URI, TSURLReturnStatus> surlsMap) throws SQLException, IllegalStateTransition, SRMInvalidRequestException {
        Set<BringOnlineFileRequest> bofrsToRelease = this.findBringOnlineFileRequestBySURLs(surls);
        for (BringOnlineFileRequest fileRequest : bofrsToRelease) {
            TSURLReturnStatus release_rs = fileRequest.releaseFile();
            if (release_rs.getStatus().getStatusCode().equals(TStatusCode.SRM_SUCCESS)) {
                surlsMap.put(fileRequest.getSurl(), release_rs);
                continue;
            }
            TSURLReturnStatus rs = surlsMap.get(release_rs.getSurl());
            if (!rs.getStatus().getStatusCode().equals(TStatusCode.SRM_INTERNAL_ERROR)) continue;
            surlsMap.put(fileRequest.getSurl(), release_rs);
        }
        Set<GetFileRequest> gfrToRelease = this.findGetFileRequestBySURLs(surls);
        for (GetFileRequest fileRequest : gfrToRelease) {
            fileRequest.setState(State.DONE, "SrmReleaseFiles called");
            TSURLReturnStatus surlReturnStatus = fileRequest.getTSURLReturnStatus();
            if (surlReturnStatus.getStatus().getStatusCode() == TStatusCode.SRM_RELEASED) {
                surlReturnStatus.getStatus().setStatusCode(TStatusCode.SRM_SUCCESS);
                surlsMap.put(fileRequest.getSurl(), surlReturnStatus);
                continue;
            }
            TSURLReturnStatus rs = surlsMap.get(surlReturnStatus.getSurl());
            if (!rs.getStatus().getStatusCode().equals(TStatusCode.SRM_INTERNAL_ERROR)) continue;
            surlsMap.put(fileRequest.getSurl(), surlReturnStatus);
        }
    }

    private Set<BringOnlineFileRequest> findBringOnlineFileRequestBySURLs(URI[] surls) {
        Scheduler scheduler = SchedulerFactory.getSchedulerFactory().getScheduler(BringOnlineFileRequest.class);
        HashSet<BringOnlineFileRequest> foundRequests = new HashSet<BringOnlineFileRequest>();
        JobStorage js = JobStorageFactory.getJobStorageFactory().getJobStorage(BringOnlineFileRequest.class);
        if (js instanceof DatabaseFileRequestStorage) {
            Set<Long> activeRequestIds;
            DatabaseFileRequestStorage reqstorage = (DatabaseFileRequestStorage)js;
            try {
                activeRequestIds = reqstorage.getActiveFileRequestIds(scheduler.getId());
            }
            catch (SQLException sqle) {
                logger.warn(sqle.toString());
                return foundRequests;
            }
            for (Long requestId : activeRequestIds) {
                BringOnlineFileRequest bofr;
                try {
                    bofr = Job.getJob(requestId, BringOnlineFileRequest.class);
                }
                catch (SRMInvalidRequestException ire) {
                    logger.error(ire.toString());
                    continue;
                }
                for (URI surl : surls) {
                    if (!bofr.getSurl().equals(surl)) continue;
                    foundRequests.add(bofr);
                }
            }
        }
        return foundRequests;
    }

    private Set<GetFileRequest> findGetFileRequestBySURLs(URI[] surls) {
        Scheduler scheduler = this.srm.getGetRequestScheduler();
        HashSet<GetFileRequest> foundRequests = new HashSet<GetFileRequest>();
        JobStorage js = JobStorageFactory.getJobStorageFactory().getJobStorage(GetFileRequest.class);
        if (js instanceof DatabaseFileRequestStorage) {
            Set<Long> activeRequestIds;
            DatabaseFileRequestStorage reqstorage = (DatabaseFileRequestStorage)js;
            try {
                activeRequestIds = reqstorage.getActiveFileRequestIds(scheduler.getId());
            }
            catch (SQLException sqle) {
                logger.warn(sqle.toString());
                return foundRequests;
            }
            for (Long requestId : activeRequestIds) {
                GetFileRequest gfr;
                try {
                    gfr = Job.getJob(requestId, GetFileRequest.class);
                }
                catch (SRMInvalidRequestException ire) {
                    logger.error(ire.toString());
                    continue;
                }
                for (URI surl : surls) {
                    if (!gfr.getSurl().equals(surl)) continue;
                    foundRequests.add(gfr);
                }
            }
        }
        return foundRequests;
    }
}

