/*
 * Decompiled with CFR 0.152.
 */
package org.dcache.srm.handler;

import java.net.URI;
import java.net.URISyntaxException;
import org.dcache.srm.AbstractStorageElement;
import org.dcache.srm.SRM;
import org.dcache.srm.SRMAuthorizationException;
import org.dcache.srm.SRMDuplicationException;
import org.dcache.srm.SRMException;
import org.dcache.srm.SRMInternalErrorException;
import org.dcache.srm.SRMInvalidPathException;
import org.dcache.srm.SRMUser;
import org.dcache.srm.request.RequestCredential;
import org.dcache.srm.v2_2.SrmMvRequest;
import org.dcache.srm.v2_2.SrmMvResponse;
import org.dcache.srm.v2_2.TReturnStatus;
import org.dcache.srm.v2_2.TStatusCode;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SrmMv {
    private static Logger logger = LoggerFactory.getLogger(SrmMv.class);
    private static final String SFN_STRING = "?SFN=";
    AbstractStorageElement storage;
    SrmMvRequest request;
    SrmMvResponse response;
    SRMUser user;

    public SrmMv(SRMUser user, RequestCredential credential, SrmMvRequest request, AbstractStorageElement storage, SRM srm, String client_host) {
        this.request = request;
        this.user = user;
        this.storage = storage;
    }

    public SrmMvResponse getResponse() {
        if (this.response != null) {
            return this.response;
        }
        try {
            this.response = this.srmMv();
        }
        catch (URISyntaxException e) {
            logger.debug(" malformed uri : " + e.getMessage());
            this.response = SrmMv.getFailedResponse(" malformed uri : " + e.getMessage(), TStatusCode.SRM_INVALID_REQUEST);
        }
        catch (SRMException srme) {
            logger.error(srme.toString());
            this.response = SrmMv.getFailedResponse(srme.toString());
        }
        return this.response;
    }

    public static final SrmMvResponse getFailedResponse(String error) {
        return SrmMv.getFailedResponse(error, null);
    }

    public static final SrmMvResponse getFailedResponse(String error, TStatusCode statusCode) {
        if (statusCode == null) {
            statusCode = TStatusCode.SRM_FAILURE;
        }
        TReturnStatus status = new TReturnStatus();
        status.setStatusCode(statusCode);
        status.setExplanation(error);
        SrmMvResponse response = new SrmMvResponse();
        response.setReturnStatus(status);
        return response;
    }

    public SrmMvResponse srmMv() throws SRMException, URISyntaxException {
        SrmMvResponse response = new SrmMvResponse();
        TReturnStatus returnStatus = new TReturnStatus();
        returnStatus.setStatusCode(TStatusCode.SRM_SUCCESS);
        response.setReturnStatus(returnStatus);
        if (this.request == null) {
            return SrmMv.getFailedResponse(" null request passed to SrmRm()");
        }
        URI to_surl = new URI(this.request.getToSURL().toString());
        URI from_surl = new URI(this.request.getFromSURL().toString());
        if (to_surl == null || from_surl == null) {
            return SrmMv.getFailedResponse(" target or destination are not defined");
        }
        try {
            this.storage.moveEntry(this.user, from_surl, to_surl);
        }
        catch (Exception e) {
            logger.warn(e.toString());
            response.getReturnStatus().setExplanation(e.getMessage());
            if (e instanceof SRMDuplicationException) {
                response.getReturnStatus().setStatusCode(TStatusCode.SRM_DUPLICATION_ERROR);
            } else if (e instanceof SRMInternalErrorException) {
                response.getReturnStatus().setStatusCode(TStatusCode.SRM_INTERNAL_ERROR);
            } else if (e instanceof SRMInvalidPathException) {
                response.getReturnStatus().setStatusCode(TStatusCode.SRM_INVALID_PATH);
            } else if (e instanceof SRMAuthorizationException) {
                response.getReturnStatus().setStatusCode(TStatusCode.SRM_AUTHORIZATION_FAILURE);
            } else if (e instanceof SRMException) {
                response.getReturnStatus().setStatusCode(TStatusCode.SRM_FAILURE);
            } else {
                response.getReturnStatus().setStatusCode(TStatusCode.SRM_INTERNAL_ERROR);
            }
            return response;
        }
        response.getReturnStatus().setExplanation("success");
        return response;
    }
}

