/*
 * Decompiled with CFR 0.152.
 */
package org.dcache.srm.handler;

import org.apache.axis.types.URI;
import org.dcache.srm.AbstractStorageElement;
import org.dcache.srm.SRM;
import org.dcache.srm.SRMException;
import org.dcache.srm.SRMUser;
import org.dcache.srm.request.LsRequest;
import org.dcache.srm.request.RequestCredential;
import org.dcache.srm.util.Configuration;
import org.dcache.srm.v2_2.SrmLsRequest;
import org.dcache.srm.v2_2.SrmLsResponse;
import org.dcache.srm.v2_2.TReturnStatus;
import org.dcache.srm.v2_2.TStatusCode;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SrmLs {
    private static Logger logger = LoggerFactory.getLogger(SrmLs.class);
    private static final String SFN_STRING = "?SFN=";
    private int maxNumOfLevels = 100;
    AbstractStorageElement storage;
    Configuration configuration;
    SrmLsRequest request;
    SrmLsResponse response;
    RequestCredential credential;
    SRMUser user;
    String client_host;
    private int results_num = 0;
    private int max_results_num = 1000;
    int numOfLevels = 1;
    boolean longFormat = false;
    String servicePathAndSFNPart = "";
    int port;
    String host;

    public SrmLs(SRMUser user, RequestCredential credential, SrmLsRequest request, AbstractStorageElement storage, SRM srm, String client_host) {
        this.request = request;
        this.user = user;
        this.storage = storage;
        this.max_results_num = srm.getConfiguration().getMaxNumberOfLsEntries();
        this.maxNumOfLevels = srm.getConfiguration().getMaxNumberOfLsLevels();
        this.credential = credential;
        this.client_host = client_host;
        this.configuration = srm.getConfiguration();
    }

    public static final SrmLsResponse getFailedResponse(String error) {
        return SrmLs.getFailedResponse(error, null);
    }

    public static final SrmLsResponse getFailedResponse(String error, TStatusCode statusCode) {
        if (statusCode == null) {
            statusCode = TStatusCode.SRM_FAILURE;
        }
        TReturnStatus status = new TReturnStatus();
        status.setStatusCode(statusCode);
        status.setExplanation(error);
        SrmLsResponse response = new SrmLsResponse();
        response.setReturnStatus(status);
        return response;
    }

    public SrmLsResponse getResponse() {
        if (this.response != null) {
            return this.response;
        }
        try {
            this.response = this.srmLs();
        }
        catch (Exception e) {
            logger.error(e.toString());
            this.response = new SrmLsResponse();
            TReturnStatus returnStatus = new TReturnStatus();
            returnStatus.setStatusCode(TStatusCode.SRM_FAILURE);
            returnStatus.setExplanation(e.toString());
            this.response.setReturnStatus(returnStatus);
        }
        return this.response;
    }

    public SrmLsResponse srmLs() throws SRMException, URI.MalformedURIException {
        int count;
        if (this.request.getAllLevelRecursive() != null && this.request.getAllLevelRecursive().booleanValue()) {
            this.numOfLevels = this.maxNumOfLevels;
        } else if (this.request.getNumOfLevels() != null) {
            this.numOfLevels = this.request.getNumOfLevels();
            if (this.numOfLevels < 0) {
                return SrmLs.getFailedResponse("numOfLevels < 0", TStatusCode.SRM_INVALID_REQUEST);
            }
        } else {
            this.numOfLevels = 1;
        }
        int offset = this.request.getOffset() != null ? this.request.getOffset() : 0;
        int n = count = this.request.getCount() != null ? this.request.getCount() : Integer.MAX_VALUE;
        if (offset < 0) {
            return SrmLs.getFailedResponse(" offset value less than 0, disallowed ", TStatusCode.SRM_INVALID_REQUEST);
        }
        if (count < 0) {
            return SrmLs.getFailedResponse(" count value less than 0, disallowed", TStatusCode.SRM_INVALID_REQUEST);
        }
        if (this.request.getFullDetailedList() != null) {
            this.longFormat = this.request.getFullDetailedList();
        }
        if (this.request.getArrayOfSURLs() == null || this.request.getArrayOfSURLs().getUrlArray() == null || this.request.getArrayOfSURLs().getUrlArray().length == 0) {
            return SrmLs.getFailedResponse("empty list of paths", TStatusCode.SRM_INVALID_REQUEST);
        }
        if (this.request.getOffset() != null && this.request.getOffset() < 0) {
            return SrmLs.getFailedResponse(" offset value less than 0, diallowed ", TStatusCode.SRM_INVALID_REQUEST);
        }
        try {
            LsRequest r = new LsRequest(this.user, this.credential.getId(), this.request, 3600000L, this.configuration.getLsRetryTimeout(), this.configuration.getLsMaxNumOfRetries(), this.client_host, (long)count, (long)offset, this.numOfLevels, this.longFormat, this.max_results_num);
            r.schedule();
            return r.getSrmLsResponse(this.configuration.getLsSwitchToAsynchronousModeDelay());
        }
        catch (Exception e) {
            logger.error(e.toString());
            return SrmLs.getFailedResponse(e.toString());
        }
    }
}

