/*
 * Decompiled with CFR 0.152.
 */
package org.dcache.srm.handler;

import org.apache.axis.types.URI;
import org.dcache.srm.AbstractStorageElement;
import org.dcache.srm.SRM;
import org.dcache.srm.SRMException;
import org.dcache.srm.SRMUser;
import org.dcache.srm.request.RequestCredential;
import org.dcache.srm.util.Configuration;
import org.dcache.srm.v2_2.ArrayOfString;
import org.dcache.srm.v2_2.SrmGetSpaceTokensRequest;
import org.dcache.srm.v2_2.SrmGetSpaceTokensResponse;
import org.dcache.srm.v2_2.TReturnStatus;
import org.dcache.srm.v2_2.TStatusCode;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SrmGetSpaceTokens {
    private static Logger logger = LoggerFactory.getLogger(SrmGetSpaceTokens.class);
    private static final String SFN_STRING = "?SFN=";
    AbstractStorageElement storage;
    SrmGetSpaceTokensRequest request;
    SrmGetSpaceTokensResponse response;
    SRMUser user;
    RequestCredential credential;
    Configuration configuration;

    public SrmGetSpaceTokens(SRMUser user, RequestCredential credential, SrmGetSpaceTokensRequest request, AbstractStorageElement storage, SRM srm, String client_host) {
        if (request == null) {
            throw new NullPointerException("request is null");
        }
        this.request = request;
        this.user = user;
        this.credential = credential;
        if (storage == null) {
            throw new NullPointerException("storage is null");
        }
        this.storage = storage;
        this.configuration = srm.getConfiguration();
        if (this.configuration == null) {
            throw new NullPointerException("configuration is null");
        }
    }

    public SrmGetSpaceTokensResponse getResponse() {
        if (this.response != null) {
            return this.response;
        }
        try {
            this.response = this.srmGetSpaceTokens();
        }
        catch (URI.MalformedURIException mue) {
            logger.debug(" malformed uri : " + mue.getMessage());
            this.response = SrmGetSpaceTokens.getFailedResponse(" malformed uri : " + mue.getMessage(), TStatusCode.SRM_INVALID_REQUEST);
        }
        catch (SRMException srme) {
            logger.error(srme.toString());
            this.response = SrmGetSpaceTokens.getFailedResponse(srme.toString());
        }
        return this.response;
    }

    public static final SrmGetSpaceTokensResponse getFailedResponse(String text) {
        return SrmGetSpaceTokens.getFailedResponse(text, null);
    }

    public static final SrmGetSpaceTokensResponse getFailedResponse(String text, TStatusCode statusCode) {
        if (statusCode == null) {
            statusCode = TStatusCode.SRM_FAILURE;
        }
        SrmGetSpaceTokensResponse response = new SrmGetSpaceTokensResponse();
        TReturnStatus returnStatus = new TReturnStatus();
        TReturnStatus status = new TReturnStatus();
        status.setStatusCode(statusCode);
        status.setExplanation(text);
        response.setReturnStatus(status);
        return response;
    }

    public SrmGetSpaceTokensResponse srmGetSpaceTokens() throws SRMException, URI.MalformedURIException {
        if (this.request == null) {
            return SrmGetSpaceTokens.getFailedResponse("srmGetSpaceTokens: null request passed to SrmGetSpaceTokens", TStatusCode.SRM_INVALID_REQUEST);
        }
        String description = this.request.getUserSpaceTokenDescription();
        String[] spaceTokens = this.storage.srmGetSpaceTokens(this.user, description);
        if (spaceTokens == null || spaceTokens.length == 0) {
            return SrmGetSpaceTokens.getFailedResponse("the space token description provided does not refer to any existing space", TStatusCode.SRM_INVALID_REQUEST);
        }
        SrmGetSpaceTokensResponse response = new SrmGetSpaceTokensResponse(new TReturnStatus(TStatusCode.SRM_SUCCESS, "OK"), new ArrayOfString(spaceTokens));
        return response;
    }
}

