/*
 * Decompiled with CFR 0.152.
 */
package org.dcache.srm.handler;

import org.apache.axis.types.URI;
import org.dcache.srm.AbstractStorageElement;
import org.dcache.srm.SRM;
import org.dcache.srm.SRMException;
import org.dcache.srm.SRMUser;
import org.dcache.srm.request.RequestCredential;
import org.dcache.srm.util.Configuration;
import org.dcache.srm.v2_2.ArrayOfTMetaDataSpace;
import org.dcache.srm.v2_2.SrmGetSpaceMetaDataRequest;
import org.dcache.srm.v2_2.SrmGetSpaceMetaDataResponse;
import org.dcache.srm.v2_2.TMetaDataSpace;
import org.dcache.srm.v2_2.TReturnStatus;
import org.dcache.srm.v2_2.TStatusCode;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SrmGetSpaceMetaData {
    private static Logger logger = LoggerFactory.getLogger(SrmGetSpaceMetaData.class);
    private static final String SFN_STRING = "?SFN=";
    AbstractStorageElement storage;
    SrmGetSpaceMetaDataRequest request;
    SrmGetSpaceMetaDataResponse response;
    SRMUser user;
    RequestCredential credential;
    Configuration configuration;

    public SrmGetSpaceMetaData(SRMUser user, RequestCredential credential, SrmGetSpaceMetaDataRequest request, AbstractStorageElement storage, SRM srm, String client_host) {
        if (request == null) {
            throw new NullPointerException("request is null");
        }
        this.request = request;
        this.user = user;
        this.credential = credential;
        if (storage == null) {
            throw new NullPointerException("storage is null");
        }
        this.storage = storage;
        this.configuration = srm.getConfiguration();
        if (this.configuration == null) {
            throw new NullPointerException("configuration is null");
        }
    }

    public SrmGetSpaceMetaDataResponse getResponse() {
        if (this.response != null) {
            return this.response;
        }
        try {
            this.response = this.srmGetSpaceMetaData();
        }
        catch (URI.MalformedURIException mue) {
            logger.debug(" malformed uri : " + mue.getMessage());
            this.response = SrmGetSpaceMetaData.getFailedResponse(" malformed uri : " + mue.getMessage(), TStatusCode.SRM_INVALID_REQUEST);
        }
        catch (SRMException srme) {
            logger.error(srme.toString());
            this.response = SrmGetSpaceMetaData.getFailedResponse(srme.toString());
        }
        return this.response;
    }

    public static final SrmGetSpaceMetaDataResponse getFailedResponse(String text) {
        return SrmGetSpaceMetaData.getFailedResponse(text, null);
    }

    public static final SrmGetSpaceMetaDataResponse getFailedResponse(String text, TStatusCode statusCode) {
        if (statusCode == null) {
            statusCode = TStatusCode.SRM_FAILURE;
        }
        SrmGetSpaceMetaDataResponse response = new SrmGetSpaceMetaDataResponse();
        TReturnStatus returnStatus = new TReturnStatus();
        TReturnStatus status = new TReturnStatus();
        status.setStatusCode(statusCode);
        status.setExplanation(text);
        response.setReturnStatus(status);
        return response;
    }

    public SrmGetSpaceMetaDataResponse srmGetSpaceMetaData() throws SRMException, URI.MalformedURIException {
        if (this.request == null) {
            return SrmGetSpaceMetaData.getFailedResponse("srmGetSpaceMetaData: null request passed to SrmGetSpaceMetaData", TStatusCode.SRM_INVALID_REQUEST);
        }
        String[] spaceTokens = this.request.getArrayOfSpaceTokens().getStringArray();
        if (spaceTokens == null) {
            return SrmGetSpaceMetaData.getFailedResponse("srmGetSpaceMetaData: null array of tokens passed to SrmGetSpaceMetaData", TStatusCode.SRM_INVALID_REQUEST);
        }
        TMetaDataSpace[] array = this.storage.srmGetSpaceMetaData(this.user, spaceTokens);
        SrmGetSpaceMetaDataResponse response = new SrmGetSpaceMetaDataResponse(new TReturnStatus(TStatusCode.SRM_SUCCESS, "OK"), new ArrayOfTMetaDataSpace(array));
        return response;
    }
}

