/*
 * Decompiled with CFR 0.152.
 */
package org.dcache.srm.handler;

import java.net.URISyntaxException;
import org.apache.axis.types.URI;
import org.dcache.srm.AbstractStorageElement;
import org.dcache.srm.FileMetaData;
import org.dcache.srm.SRM;
import org.dcache.srm.SRMException;
import org.dcache.srm.SRMUser;
import org.dcache.srm.handler.PermissionMaskToTPermissionMode;
import org.dcache.srm.request.RequestCredential;
import org.dcache.srm.v2_2.ArrayOfAnyURI;
import org.dcache.srm.v2_2.ArrayOfTGroupPermission;
import org.dcache.srm.v2_2.ArrayOfTPermissionReturn;
import org.dcache.srm.v2_2.ArrayOfTUserPermission;
import org.dcache.srm.v2_2.SrmGetPermissionRequest;
import org.dcache.srm.v2_2.SrmGetPermissionResponse;
import org.dcache.srm.v2_2.TGroupPermission;
import org.dcache.srm.v2_2.TPermissionMode;
import org.dcache.srm.v2_2.TPermissionReturn;
import org.dcache.srm.v2_2.TReturnStatus;
import org.dcache.srm.v2_2.TStatusCode;
import org.dcache.srm.v2_2.TUserPermission;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SrmGetPermission {
    private static Logger logger = LoggerFactory.getLogger(SrmGetPermission.class);
    AbstractStorageElement storage;
    SrmGetPermissionRequest request;
    SrmGetPermissionResponse response;
    SRMUser user;

    public SrmGetPermission(SRMUser user, RequestCredential credential, SrmGetPermissionRequest request, AbstractStorageElement storage, SRM srm, String client_host) {
        this.request = request;
        this.user = user;
        this.storage = storage;
    }

    public SrmGetPermissionResponse getResponse() {
        if (this.response != null) {
            return this.response;
        }
        try {
            this.response = this.srmGetPermission();
        }
        catch (URISyntaxException e) {
            logger.debug(" malformed uri : " + e.getMessage());
            this.response = SrmGetPermission.getFailedResponse(" malformed uri : " + e.getMessage(), TStatusCode.SRM_INVALID_REQUEST);
        }
        catch (SRMException srme) {
            logger.error(srme.toString());
            this.response = SrmGetPermission.getFailedResponse(srme.toString());
        }
        return this.response;
    }

    public static final SrmGetPermissionResponse getFailedResponse(String error) {
        return SrmGetPermission.getFailedResponse(error, null);
    }

    public static final SrmGetPermissionResponse getFailedResponse(String error, TStatusCode statusCode) {
        if (statusCode == null) {
            statusCode = TStatusCode.SRM_FAILURE;
        }
        TReturnStatus status = new TReturnStatus();
        status.setStatusCode(statusCode);
        status.setExplanation(error);
        SrmGetPermissionResponse response = new SrmGetPermissionResponse();
        response.setReturnStatus(status);
        return response;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SrmGetPermissionResponse srmGetPermission() throws SRMException, URISyntaxException {
        SrmGetPermissionResponse response = new SrmGetPermissionResponse();
        TReturnStatus returnStatus = new TReturnStatus();
        returnStatus.setStatusCode(TStatusCode.SRM_SUCCESS);
        returnStatus.setExplanation("success");
        response.setReturnStatus(returnStatus);
        if (this.request == null) {
            return SrmGetPermission.getFailedResponse(" null request passed to SrmGetPermission()");
        }
        ArrayOfAnyURI anyuriarray = this.request.getArrayOfSURLs();
        URI[] uriarray = anyuriarray.getUrlArray();
        int length = uriarray.length;
        if (length == 0) {
            return SrmGetPermission.getFailedResponse(" zero length array of URLS");
        }
        ArrayOfTPermissionReturn permissionarray = new ArrayOfTPermissionReturn();
        TPermissionReturn[] permissionsArray = new TPermissionReturn[length];
        permissionarray.setPermissionArray(permissionsArray);
        boolean haveFailure = false;
        int nfailed = 0;
        for (int i = 0; i < length; ++i) {
            logger.debug("SURL[" + i + "]= " + uriarray[i]);
            java.net.URI surl = new java.net.URI(uriarray[i].toString());
            TReturnStatus rs = new TReturnStatus();
            rs.setStatusCode(TStatusCode.SRM_SUCCESS);
            TPermissionReturn p = new TPermissionReturn();
            p.setStatus(rs);
            p.setSurl(uriarray[i]);
            try {
                FileMetaData fmd = this.storage.getFileMetaData(this.user, surl, false);
                String owner = fmd.owner;
                int permissions = fmd.permMode;
                TPermissionMode upm = PermissionMaskToTPermissionMode.maskToTPermissionMode(permissions >> 6 & 7);
                TPermissionMode gpm = PermissionMaskToTPermissionMode.maskToTPermissionMode(permissions >> 3 & 7);
                TPermissionMode opm = PermissionMaskToTPermissionMode.maskToTPermissionMode(permissions & 7);
                ArrayOfTUserPermission arrayOfTUserPermissions = new ArrayOfTUserPermission();
                TUserPermission[] userPermissionArray = new TUserPermission[1];
                for (int j = 0; j < userPermissionArray.length; ++j) {
                    userPermissionArray[j] = new TUserPermission(owner, upm);
                }
                arrayOfTUserPermissions.setUserPermissionArray(userPermissionArray);
                ArrayOfTGroupPermission arrayOfTGroupPermissions = new ArrayOfTGroupPermission();
                TGroupPermission[] groupPermissionArray = new TGroupPermission[1];
                for (int j = 0; j < groupPermissionArray.length; ++j) {
                    groupPermissionArray[j] = new TGroupPermission(fmd.group, gpm);
                }
                arrayOfTGroupPermissions.setGroupPermissionArray(groupPermissionArray);
                p.setOwnerPermission(upm);
                p.setArrayOfUserPermissions(arrayOfTUserPermissions);
                p.setArrayOfGroupPermissions(arrayOfTGroupPermissions);
                p.setOtherPermission(opm);
                p.setOwner(owner);
                continue;
            }
            catch (SRMException srme) {
                logger.warn(srme.toString());
                p.getStatus().setStatusCode(TStatusCode.SRM_FAILURE);
                p.getStatus().setExplanation(uriarray[i] + " " + srme.getMessage());
                haveFailure = true;
                ++nfailed;
                continue;
            }
            finally {
                permissionarray.setPermissionArray(i, p);
            }
        }
        response.setArrayOfPermissionReturns(permissionarray);
        if (haveFailure) {
            if (nfailed == length) {
                response.getReturnStatus().setStatusCode(TStatusCode.SRM_FAILURE);
                response.getReturnStatus().setExplanation("failed to get Permission for all requested surls");
            } else {
                response.getReturnStatus().setStatusCode(TStatusCode.SRM_PARTIAL_SUCCESS);
                response.getReturnStatus().setExplanation("failed to get Permission for at least one file");
            }
            return response;
        }
        response.getReturnStatus().setStatusCode(TStatusCode.SRM_SUCCESS);
        response.getReturnStatus().setExplanation("success");
        return response;
    }
}

