/*
 * Decompiled with CFR 0.152.
 */
package org.dcache.srm.handler;

import org.apache.axis.types.URI;
import org.dcache.srm.AbstractStorageElement;
import org.dcache.srm.SRM;
import org.dcache.srm.SRMException;
import org.dcache.srm.SRMProtocol;
import org.dcache.srm.SRMUser;
import org.dcache.srm.request.CopyRequest;
import org.dcache.srm.request.RequestCredential;
import org.dcache.srm.util.Configuration;
import org.dcache.srm.v2_2.SrmCopyRequest;
import org.dcache.srm.v2_2.SrmCopyResponse;
import org.dcache.srm.v2_2.TAccessLatency;
import org.dcache.srm.v2_2.TCopyFileRequest;
import org.dcache.srm.v2_2.TExtraInfo;
import org.dcache.srm.v2_2.TOverwriteMode;
import org.dcache.srm.v2_2.TRetentionPolicy;
import org.dcache.srm.v2_2.TReturnStatus;
import org.dcache.srm.v2_2.TStatusCode;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SrmCopy {
    private static Logger logger = LoggerFactory.getLogger(SrmCopy.class);
    private static final String SFN_STRING = "?SFN=";
    AbstractStorageElement storage;
    SrmCopyRequest request;
    SrmCopyResponse response;
    SRMUser user;
    RequestCredential credential;
    Configuration configuration;
    private String client_host;

    public SrmCopy(SRMUser user, RequestCredential credential, SrmCopyRequest request, AbstractStorageElement storage, SRM srm, String client_host) {
        if (request == null) {
            throw new NullPointerException("request is null");
        }
        this.request = request;
        this.user = user;
        this.credential = credential;
        if (storage == null) {
            throw new NullPointerException("storage is null");
        }
        this.storage = storage;
        this.configuration = srm.getConfiguration();
        if (this.configuration == null) {
            throw new NullPointerException("configuration is null");
        }
        this.client_host = client_host;
    }

    public SrmCopyResponse getResponse() {
        if (this.response != null) {
            return this.response;
        }
        try {
            this.response = this.srmCopy();
        }
        catch (Exception e) {
            logger.error(e.toString());
            this.response = SrmCopy.getFailedResponse("Exception : " + e.toString());
        }
        return this.response;
    }

    public static final SrmCopyResponse getFailedResponse(String text) {
        return SrmCopy.getFailedResponse(text, null);
    }

    public static final SrmCopyResponse getFailedResponse(String text, TStatusCode statusCode) {
        if (statusCode == null) {
            statusCode = TStatusCode.SRM_FAILURE;
        }
        SrmCopyResponse response = new SrmCopyResponse();
        TReturnStatus returnStatus = new TReturnStatus();
        TReturnStatus status = new TReturnStatus();
        status.setStatusCode(statusCode);
        status.setExplanation(text);
        response.setReturnStatus(status);
        return response;
    }

    public SrmCopyResponse srmCopy() throws SRMException, URI.MalformedURIException {
        TOverwriteMode overwriteMode;
        long reqLifetime;
        TReturnStatus returnStatus = new TReturnStatus();
        if (this.request == null) {
            return SrmCopy.getFailedResponse("SrmCopy: null request passed to SrmCopy", TStatusCode.SRM_INVALID_REQUEST);
        }
        if (this.request.getArrayOfFileRequests() == null) {
            return SrmCopy.getFailedResponse("SrmCopy: ArrayOfFileRequests is null", TStatusCode.SRM_INVALID_REQUEST);
        }
        TCopyFileRequest[] arrayOfFileRequests = this.request.getArrayOfFileRequests().getRequestArray();
        if (arrayOfFileRequests == null) {
            return SrmCopy.getFailedResponse("SrmCopy: null array of file requests", TStatusCode.SRM_INVALID_REQUEST);
        }
        if (arrayOfFileRequests.length == 0) {
            return SrmCopy.getFailedResponse("SrmCopy: empty array of file requests", TStatusCode.SRM_INVALID_REQUEST);
        }
        String[] from_urls = new String[arrayOfFileRequests.length];
        String[] to_urls = new String[arrayOfFileRequests.length];
        long lifetimeInSeconds = 0L;
        if (this.request.getDesiredTotalRequestTime() != null && lifetimeInSeconds < (reqLifetime = (long)this.request.getDesiredTotalRequestTime().intValue())) {
            lifetimeInSeconds = reqLifetime;
        }
        long lifetime = lifetimeInSeconds > 0L ? (lifetimeInSeconds * 1000L > this.configuration.getCopyLifetime() ? this.configuration.getCopyLifetime() : lifetimeInSeconds * 1000L) : this.configuration.getCopyLifetime();
        String spaceToken = this.request.getTargetSpaceToken();
        for (int i = 0; i < arrayOfFileRequests.length; ++i) {
            URI fromSURL = arrayOfFileRequests[i].getSourceSURL();
            URI toSURL = arrayOfFileRequests[i].getTargetSURL();
            from_urls[i] = fromSURL.toString();
            to_urls[i] = toSURL.toString();
        }
        TRetentionPolicy targetRetentionPolicy = null;
        TAccessLatency targetAccessLatency = null;
        if (this.request.getTargetFileRetentionPolicyInfo() != null) {
            targetRetentionPolicy = this.request.getTargetFileRetentionPolicyInfo().getRetentionPolicy();
            targetAccessLatency = this.request.getTargetFileRetentionPolicyInfo().getAccessLatency();
        }
        if ((overwriteMode = this.request.getOverwriteOption()) != null && overwriteMode.equals(TOverwriteMode.WHEN_FILES_ARE_DIFFERENT)) {
            SrmCopy.getFailedResponse("Overwrite Mode WHEN_FILES_ARE_DIFFERENT is not supported", TStatusCode.SRM_NOT_SUPPORTED);
        }
        try {
            CopyRequest r = new CopyRequest(this.user, this.credential.getId(), from_urls, to_urls, spaceToken, lifetime, this.configuration.getCopyRetryTimeout(), this.configuration.getCopyMaxNumOfRetries(), SRMProtocol.V2_1, this.request.getTargetFileStorageType(), targetRetentionPolicy, targetAccessLatency, this.request.getUserRequestDescription(), this.client_host, overwriteMode);
            if (this.request.getSourceStorageSystemInfo() != null && this.request.getSourceStorageSystemInfo().getExtraInfoArray() != null && this.request.getSourceStorageSystemInfo().getExtraInfoArray().length > 0) {
                for (int i = 0; i < this.request.getSourceStorageSystemInfo().getExtraInfoArray().length; ++i) {
                    TExtraInfo extraInfo = this.request.getSourceStorageSystemInfo().getExtraInfoArray()[i];
                    if (!extraInfo.getKey().equals("priority")) continue;
                    int priority = Integer.parseInt(extraInfo.getValue());
                    r.setPriority(priority);
                }
            }
            r.schedule();
            this.response = r.getSrmCopyResponse();
            return this.response;
        }
        catch (Exception e) {
            logger.error(e.toString());
            return SrmCopy.getFailedResponse("copy request generated error : " + e.toString(), TStatusCode.SRM_INTERNAL_ERROR);
        }
    }
}

