/*
 * Decompiled with CFR 0.152.
 */
package org.dcache.srm.handler;

import java.net.URISyntaxException;
import org.apache.axis.types.URI;
import org.dcache.srm.AbstractStorageElement;
import org.dcache.srm.FileMetaData;
import org.dcache.srm.SRM;
import org.dcache.srm.SRMException;
import org.dcache.srm.SRMUser;
import org.dcache.srm.handler.PermissionMaskToTPermissionMode;
import org.dcache.srm.request.RequestCredential;
import org.dcache.srm.v2_2.ArrayOfAnyURI;
import org.dcache.srm.v2_2.ArrayOfTSURLPermissionReturn;
import org.dcache.srm.v2_2.SrmCheckPermissionRequest;
import org.dcache.srm.v2_2.SrmCheckPermissionResponse;
import org.dcache.srm.v2_2.TPermissionMode;
import org.dcache.srm.v2_2.TReturnStatus;
import org.dcache.srm.v2_2.TSURLPermissionReturn;
import org.dcache.srm.v2_2.TStatusCode;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SrmCheckPermission {
    private static Logger logger = LoggerFactory.getLogger(SrmCheckPermission.class);
    AbstractStorageElement storage;
    SrmCheckPermissionRequest request;
    SrmCheckPermissionResponse response;
    SRMUser user;

    public SrmCheckPermission(SRMUser user, RequestCredential credential, SrmCheckPermissionRequest request, AbstractStorageElement storage, SRM srm, String client_host) {
        this.request = request;
        this.user = user;
        this.storage = storage;
    }

    public SrmCheckPermissionResponse getResponse() {
        if (this.response != null) {
            return this.response;
        }
        try {
            this.response = this.srmCheckPermission();
        }
        catch (Exception e) {
            logger.error(e.toString());
        }
        return this.response;
    }

    public static final SrmCheckPermissionResponse getFailedResponse(String error) {
        return SrmCheckPermission.getFailedResponse(error, null);
    }

    public static final SrmCheckPermissionResponse getFailedResponse(String error, TStatusCode statusCode) {
        if (statusCode == null) {
            statusCode = TStatusCode.SRM_FAILURE;
        }
        TReturnStatus status = new TReturnStatus();
        status.setStatusCode(statusCode);
        status.setExplanation(error);
        SrmCheckPermissionResponse response = new SrmCheckPermissionResponse();
        response.setReturnStatus(status);
        return response;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SrmCheckPermissionResponse srmCheckPermission() throws SRMException, URISyntaxException {
        SrmCheckPermissionResponse response = new SrmCheckPermissionResponse();
        TReturnStatus returnStatus = new TReturnStatus();
        returnStatus.setStatusCode(TStatusCode.SRM_SUCCESS);
        returnStatus.setExplanation("success");
        response.setReturnStatus(returnStatus);
        if (this.request == null) {
            return SrmCheckPermission.getFailedResponse(" null request passed to SrmCheckPermission()");
        }
        ArrayOfAnyURI anyuriarray = this.request.getArrayOfSURLs();
        String authorizationID = this.request.getAuthorizationID();
        URI[] uriarray = anyuriarray.getUrlArray();
        int length = uriarray.length;
        if (length == 0) {
            return SrmCheckPermission.getFailedResponse(" zero length array of URLS");
        }
        ArrayOfTSURLPermissionReturn arrayOfPermissions = new ArrayOfTSURLPermissionReturn();
        TSURLPermissionReturn[] surlPermissionArray = new TSURLPermissionReturn[length];
        arrayOfPermissions.setSurlPermissionArray(surlPermissionArray);
        int nfailed = 0;
        for (int i = 0; i < length; ++i) {
            TReturnStatus rs = new TReturnStatus();
            rs.setStatusCode(TStatusCode.SRM_SUCCESS);
            TSURLPermissionReturn pr = new TSURLPermissionReturn();
            pr.setStatus(rs);
            pr.setSurl(uriarray[i]);
            logger.debug("SURL[" + i + "]= " + uriarray[i]);
            java.net.URI surl = new java.net.URI(uriarray[i].toString());
            try {
                FileMetaData fmd = this.storage.getFileMetaData(this.user, surl, false);
                int permissions = fmd.permMode;
                TPermissionMode pm = TPermissionMode.NONE;
                pm = fmd.isOwner(this.user) ? PermissionMaskToTPermissionMode.maskToTPermissionMode(permissions >> 6 & 7) : (fmd.isGroupMember(this.user) ? PermissionMaskToTPermissionMode.maskToTPermissionMode(permissions >> 3 & 7) : PermissionMaskToTPermissionMode.maskToTPermissionMode(permissions & 7));
                pr.setPermission(pm);
                continue;
            }
            catch (SRMException srme) {
                logger.warn(srme.toString());
                pr.getStatus().setStatusCode(TStatusCode.SRM_FAILURE);
                pr.getStatus().setExplanation(uriarray[i] + " " + srme.getMessage());
                ++nfailed;
                continue;
            }
            finally {
                arrayOfPermissions.setSurlPermissionArray(i, pr);
            }
        }
        response.setArrayOfPermissions(arrayOfPermissions);
        if (nfailed != 0) {
            if (nfailed == length) {
                response.getReturnStatus().setStatusCode(TStatusCode.SRM_FAILURE);
                response.getReturnStatus().setExplanation("failed to check Permission for all requested surls");
            } else {
                response.getReturnStatus().setStatusCode(TStatusCode.SRM_PARTIAL_SUCCESS);
                response.getReturnStatus().setExplanation("failed to check Permission for at least one file");
            }
            return response;
        }
        response.getReturnStatus().setStatusCode(TStatusCode.SRM_SUCCESS);
        response.getReturnStatus().setExplanation("success");
        return response;
    }
}

