/*
 * Decompiled with CFR 0.152.
 */
package org.dcache.srm.handler;

import java.net.URI;
import java.net.URISyntaxException;
import java.sql.SQLException;
import org.dcache.srm.AbstractStorageElement;
import org.dcache.srm.SRM;
import org.dcache.srm.SRMException;
import org.dcache.srm.SRMInvalidRequestException;
import org.dcache.srm.SRMUser;
import org.dcache.srm.request.ContainerRequest;
import org.dcache.srm.request.FileRequest;
import org.dcache.srm.request.RequestCredential;
import org.dcache.srm.scheduler.IllegalStateTransition;
import org.dcache.srm.scheduler.Job;
import org.dcache.srm.scheduler.Scheduler;
import org.dcache.srm.scheduler.State;
import org.dcache.srm.util.Configuration;
import org.dcache.srm.v2_2.ArrayOfTSURLReturnStatus;
import org.dcache.srm.v2_2.SrmAbortFilesRequest;
import org.dcache.srm.v2_2.SrmAbortFilesResponse;
import org.dcache.srm.v2_2.TReturnStatus;
import org.dcache.srm.v2_2.TSURLReturnStatus;
import org.dcache.srm.v2_2.TStatusCode;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SrmAbortFiles {
    private static Logger logger = LoggerFactory.getLogger(SrmAbortFiles.class);
    private static final String SFN_STRING = "?SFN=";
    AbstractStorageElement storage;
    SrmAbortFilesRequest srmAbortFilesRequest;
    SrmAbortFilesResponse response;
    Scheduler getScheduler;
    SRMUser user;
    RequestCredential credential;
    Configuration configuration;
    private int results_num;
    private int max_results_num;
    int numOfLevels = 0;
    boolean longFormat = false;
    String servicePathAndSFNPart = "";
    int port;
    String host;

    public SrmAbortFiles(SRMUser user, RequestCredential credential, SrmAbortFilesRequest srmAbortFilesRequest, AbstractStorageElement storage, SRM srm, String client_host) {
        this.srmAbortFilesRequest = srmAbortFilesRequest;
        this.user = user;
        this.credential = credential;
        this.storage = storage;
        this.getScheduler = srm.getGetRequestScheduler();
        this.configuration = srm.getConfiguration();
    }

    public SrmAbortFilesResponse getResponse() {
        if (this.response != null) {
            return this.response;
        }
        try {
            this.response = this.srmAbortFiles();
        }
        catch (URISyntaxException mue) {
            logger.debug(" malformed uri : " + mue.getMessage());
            this.response = SrmAbortFiles.getFailedResponse(" malformed uri : " + mue.getMessage(), TStatusCode.SRM_INVALID_REQUEST);
        }
        catch (SRMInvalidRequestException ire) {
            logger.debug(" invalid request : " + ire.getMessage());
            this.response = SrmAbortFiles.getFailedResponse(" invalid request : " + ire.getMessage(), TStatusCode.SRM_INVALID_REQUEST);
        }
        catch (SQLException sqle) {
            logger.error(sqle.toString());
            this.response = SrmAbortFiles.getFailedResponse("sql error " + sqle.getMessage(), TStatusCode.SRM_INTERNAL_ERROR);
        }
        catch (SRMException srme) {
            logger.error(srme.toString());
            this.response = SrmAbortFiles.getFailedResponse(srme.toString());
        }
        catch (IllegalStateTransition ist) {
            logger.error("Illegal State Transition : " + ist.getMessage());
            this.response = SrmAbortFiles.getFailedResponse("Illegal State Transition : " + ist.getMessage());
        }
        return this.response;
    }

    public static final SrmAbortFilesResponse getFailedResponse(String error) {
        return SrmAbortFiles.getFailedResponse(error, null);
    }

    public static final SrmAbortFilesResponse getFailedResponse(String error, TStatusCode statusCode) {
        if (statusCode == null) {
            statusCode = TStatusCode.SRM_FAILURE;
        }
        TReturnStatus status = new TReturnStatus();
        status.setStatusCode(statusCode);
        status.setExplanation(error);
        SrmAbortFilesResponse srmAbortFilesResponse = new SrmAbortFilesResponse();
        srmAbortFilesResponse.setReturnStatus(status);
        return srmAbortFilesResponse;
    }

    private static URI[] toUris(org.apache.axis.types.URI[] uris) throws URISyntaxException {
        URI[] result = new URI[uris.length];
        for (int i = 0; i < uris.length; ++i) {
            result[i] = new URI(uris[i].toString());
        }
        return result;
    }

    public SrmAbortFilesResponse srmAbortFiles() throws SRMException, URISyntaxException, SQLException, IllegalStateTransition {
        TSURLReturnStatus[] surlReturnStatusArray;
        Long requestId;
        String requestToken = this.srmAbortFilesRequest.getRequestToken();
        if (requestToken == null) {
            return SrmAbortFiles.getFailedResponse("request contains no request token");
        }
        try {
            requestId = new Long(requestToken);
        }
        catch (NumberFormatException nfe) {
            return SrmAbortFiles.getFailedResponse(" requestToken \"" + requestToken + "\"is not valid", TStatusCode.SRM_INVALID_REQUEST);
        }
        ContainerRequest request = Job.getJob(requestId, ContainerRequest.class);
        if (this.srmAbortFilesRequest.getArrayOfSURLs() == null) {
            return SrmAbortFiles.getFailedResponse("request does not contain any SURLs", TStatusCode.SRM_INVALID_REQUEST);
        }
        URI[] surls = SrmAbortFiles.toUris(this.srmAbortFilesRequest.getArrayOfSURLs().getUrlArray());
        if (surls.length == 0) {
            return SrmAbortFiles.getFailedResponse("0 length SiteURLs array", TStatusCode.SRM_INVALID_REQUEST);
        }
        for (URI surl : surls) {
            FileRequest fileRequest = request.getFileRequestBySurl(surl);
            fileRequest.setState(State.CANCELED, "SrmAbortFiles called");
        }
        TReturnStatus status = new TReturnStatus();
        status.setStatusCode(TStatusCode.SRM_SUCCESS);
        SrmAbortFilesResponse srmAbortFilesResponse = new SrmAbortFilesResponse();
        srmAbortFilesResponse.setReturnStatus(status);
        for (TSURLReturnStatus surlReturnStatus : surlReturnStatusArray = request.getArrayOfTSURLReturnStatus(surls)) {
            if (surlReturnStatus.getStatus().getStatusCode() != TStatusCode.SRM_ABORTED) continue;
            surlReturnStatus.getStatus().setStatusCode(TStatusCode.SRM_SUCCESS);
        }
        srmAbortFilesResponse.setArrayOfFileStatuses(new ArrayOfTSURLReturnStatus(surlReturnStatusArray));
        request.getTReturnStatus();
        return srmAbortFilesResponse;
    }
}

