/*
 * Decompiled with CFR 0.152.
 */
package org.dcache.gplazma.strategies;

import java.security.Principal;
import java.util.List;
import java.util.Set;
import org.dcache.gplazma.AuthenticationException;
import org.dcache.gplazma.monitor.LoginMonitor;
import org.dcache.gplazma.plugins.GPlazmaSessionPlugin;
import org.dcache.gplazma.strategies.GPlazmaPluginElement;
import org.dcache.gplazma.strategies.PAMStyleStrategy;
import org.dcache.gplazma.strategies.PluginCaller;
import org.dcache.gplazma.strategies.SessionStrategy;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultSessionStrategy
implements SessionStrategy {
    private static final Logger logger = LoggerFactory.getLogger(DefaultSessionStrategy.class);
    private PAMStyleStrategy<GPlazmaSessionPlugin> pamStyleSessionStrategy;

    @Override
    public void setPlugins(List<GPlazmaPluginElement<GPlazmaSessionPlugin>> plugins) {
        this.pamStyleSessionStrategy = new PAMStyleStrategy(plugins);
    }

    @Override
    public synchronized void session(final LoginMonitor monitor, final Set<Principal> authorizedPrincipals, final Set<Object> attrib) throws AuthenticationException {
        this.pamStyleSessionStrategy.callPlugins(new PluginCaller<GPlazmaSessionPlugin>(){

            @Override
            public void call(GPlazmaPluginElement<GPlazmaSessionPlugin> pe) throws AuthenticationException {
                monitor.sessionPluginBegins(pe.getName(), pe.getControl(), authorizedPrincipals, attrib);
                GPlazmaSessionPlugin plugin = pe.getPlugin();
                String error = null;
                LoginMonitor.Result result = LoginMonitor.Result.FAIL;
                try {
                    plugin.session(authorizedPrincipals, attrib);
                    result = LoginMonitor.Result.SUCCESS;
                }
                catch (AuthenticationException e) {
                    error = e.getMessage();
                    throw e;
                }
                finally {
                    monitor.sessionPluginEnds(pe.getName(), pe.getControl(), result, error, authorizedPrincipals, attrib);
                }
            }
        });
    }
}

