/*
 * Decompiled with CFR 0.152.
 */
package org.dcache.gplazma.strategies;

import java.security.Principal;
import java.util.List;
import java.util.Set;
import org.dcache.gplazma.NoSuchPrincipalException;
import org.dcache.gplazma.plugins.GPlazmaIdentityPlugin;
import org.dcache.gplazma.strategies.GPlazmaPluginElement;
import org.dcache.gplazma.strategies.IdentityStrategy;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultIdentityStrategy
implements IdentityStrategy {
    private static final Logger _log = LoggerFactory.getLogger(DefaultIdentityStrategy.class);
    private List<GPlazmaPluginElement<GPlazmaIdentityPlugin>> ideStyleStrategies;

    @Override
    public Principal map(Principal principal) throws NoSuchPrincipalException {
        for (GPlazmaPluginElement<GPlazmaIdentityPlugin> ideStyleStrategy : this.ideStyleStrategies) {
            try {
                return ideStyleStrategy.getPlugin().map(principal);
            }
            catch (RuntimeException e) {
                _log.error("Bug in plugin " + ideStyleStrategy.getName(), (Throwable)e);
            }
            catch (NoSuchPrincipalException e) {
            }
        }
        throw new NoSuchPrincipalException(principal);
    }

    @Override
    public Set<Principal> reverseMap(Principal principal) throws NoSuchPrincipalException {
        for (GPlazmaPluginElement<GPlazmaIdentityPlugin> ideStyleStrategy : this.ideStyleStrategies) {
            try {
                return ideStyleStrategy.getPlugin().reverseMap(principal);
            }
            catch (RuntimeException e) {
                _log.error("Bug in plugin " + ideStyleStrategy.getName(), (Throwable)e);
            }
            catch (NoSuchPrincipalException e) {
            }
        }
        throw new NoSuchPrincipalException(principal);
    }

    @Override
    public void setPlugins(List<GPlazmaPluginElement<GPlazmaIdentityPlugin>> plugins) {
        this.ideStyleStrategies = plugins;
    }
}

