/*
 * Decompiled with CFR 0.152.
 */
package org.dcache.gplazma.loader.cli;

import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.Arrays;
import org.dcache.gplazma.loader.cli.Command;

public class Main {
    public static void main(String[] args) {
        Command command;
        Constructor<?> constructor;
        Class<?> className;
        if (args.length == 0) {
            throw new IllegalArgumentException("Need command name");
        }
        try {
            className = Class.forName(args[0]);
        }
        catch (ClassNotFoundException e) {
            System.err.println("Unknown command " + args[0]);
            System.exit(1);
            return;
        }
        if (!Command.class.isAssignableFrom(className)) {
            System.err.println("Command " + args[0] + " is not a command");
            System.exit(1);
        }
        Class<?> commandName = className;
        try {
            constructor = commandName.getConstructor(new Class[0]);
        }
        catch (SecurityException e) {
            System.err.println("Cannot run command");
            System.exit(1);
            return;
        }
        catch (NoSuchMethodException e) {
            System.err.println("Cannot create command");
            System.exit(1);
            return;
        }
        try {
            command = (Command)constructor.newInstance(new Object[0]);
        }
        catch (IllegalArgumentException e) {
            e.printStackTrace();
            return;
        }
        catch (InstantiationException e) {
            e.printStackTrace();
            return;
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
            return;
        }
        catch (InvocationTargetException e) {
            e.printStackTrace();
            return;
        }
        int rc = command.run(Arrays.copyOfRange(args, 1, args.length));
        System.exit(rc);
    }
}

