/*
 * Decompiled with CFR 0.152.
 */
package org.dcache.gplazma.loader;

import java.io.Reader;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpression;
import javax.xml.xpath.XPathExpressionException;
import javax.xml.xpath.XPathFactory;
import org.dcache.gplazma.loader.PluginMetadata;
import org.dcache.gplazma.plugins.GPlazmaPlugin;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;
import org.xml.sax.SAXParseException;

public class XmlParser {
    private static final Logger LOGGER = LoggerFactory.getLogger(XmlParser.class);
    private static final XPathFactory XPATH_FACTORY = XPathFactory.newInstance();
    private static final String XPATH_EXPRESSION_PLUGINS_PLUGIN = "/plugins/plugin";
    private final InputSource _is;
    private final Set<PluginMetadata> _plugins = new HashSet<PluginMetadata>();
    private final Set<Class<? extends GPlazmaPlugin>> _bannedClasses = new HashSet<Class<? extends GPlazmaPlugin>>();

    public XmlParser(Reader source) {
        this._is = new InputSource(source);
    }

    public void parse() {
        LOGGER.debug("starting parse");
        NodeList nodes = this.buildPluginNodeList();
        LOGGER.debug("NodeList has {} entries", (Object)nodes.getLength());
        this.addPluginsFromNodeList(nodes);
        LOGGER.debug("Created {} plugin metadata entries", (Object)this._plugins.size());
    }

    public Set<PluginMetadata> getPlugins() {
        return Collections.unmodifiableSet(this._plugins);
    }

    private NodeList buildPluginNodeList() {
        Object result;
        XPathExpression expression;
        XPath xpath = XPATH_FACTORY.newXPath();
        try {
            expression = xpath.compile(XPATH_EXPRESSION_PLUGINS_PLUGIN);
        }
        catch (XPathExpressionException e) {
            throw new RuntimeException("Unable to compile XPath expression/plugins/plugin", e);
        }
        try {
            result = expression.evaluate(this._is, XPathConstants.NODESET);
        }
        catch (XPathExpressionException e) {
            Throwable genericCause = e.getCause();
            if (genericCause instanceof SAXParseException) {
                SAXParseException cause = (SAXParseException)genericCause;
                LOGGER.error("Unable to parse plugin metadata: [{},{}] {}", new Object[]{cause.getLineNumber(), cause.getColumnNumber(), cause.getMessage()});
            } else {
                LOGGER.error("Unable to parse plugin metadata: {}", (Object)genericCause.getMessage());
            }
            return new EmptyNodeList();
        }
        NodeList nodes = (NodeList)result;
        return nodes;
    }

    private void addPluginsFromNodeList(NodeList nodes) {
        for (int i = 0; i < nodes.getLength(); ++i) {
            Node item = nodes.item(i);
            this.tryToAddPluginFromNode(item);
        }
    }

    private void tryToAddPluginFromNode(Node pluginRootNode) {
        try {
            PluginMetadata plugin = this.processPluginNode(pluginRootNode);
            LOGGER.debug("Adding plugin {}", plugin.getPluginNames());
            this._plugins.add(plugin);
        }
        catch (IllegalArgumentException e) {
            LOGGER.error("Unable register new plugin: {}", (Object)e.getMessage());
        }
    }

    private PluginMetadata processPluginNode(Node pluginRootNode) {
        PluginMetadata metadata = new PluginMetadata();
        this.addMetadataFromPluginNodeChildren(metadata, pluginRootNode);
        this.validMetadataGuard(metadata);
        return metadata;
    }

    private void validMetadataGuard(PluginMetadata metadata) {
        if (!metadata.isValid()) {
            throw new IllegalArgumentException(this.pluginName(metadata) + " metadata is incomplete");
        }
        Class<? extends GPlazmaPlugin> thisPluginClass = metadata.getPluginClass();
        LOGGER.debug("examining plugin with class {}", thisPluginClass);
        if (this.removeIfClassAlreadyRegistered(thisPluginClass)) {
            this._bannedClasses.add(thisPluginClass);
            throw new IllegalArgumentException("Plugin '" + metadata.getShortestName() + "' uses class " + thisPluginClass.getName() + " which is already registered");
        }
        if (this._bannedClasses.contains(thisPluginClass)) {
            throw new IllegalArgumentException("Plugin '" + metadata.getShortestName() + "' uses class " + thisPluginClass.getName() + " which was used by another plugin");
        }
    }

    private boolean removeIfClassAlreadyRegistered(Class<? extends GPlazmaPlugin> pluginClass) {
        Iterator<PluginMetadata> itr = this._plugins.iterator();
        while (itr.hasNext()) {
            PluginMetadata registeredPlugin = itr.next();
            Class<? extends GPlazmaPlugin> registeredPluginClass = registeredPlugin.getPluginClass();
            LOGGER.debug("comparing plugin class {} against registered plugin with class {}", pluginClass, registeredPluginClass);
            if (!pluginClass.equals(registeredPluginClass)) continue;
            itr.remove();
            return true;
        }
        return false;
    }

    private void addMetadataFromPluginNodeChildren(PluginMetadata metadata, Node pluginRootNode) {
        NodeList childNodes = pluginRootNode.getChildNodes();
        for (int i = 0; i < childNodes.getLength(); ++i) {
            Node childNode = childNodes.item(i);
            if (childNode.getNodeType() != 1) continue;
            this.addMetadataFromChildNode(metadata, childNode);
        }
    }

    private void addMetadataFromChildNode(PluginMetadata metadata, Node node) {
        String nodeName = node.getLocalName();
        String value = node.getTextContent();
        if (!XML_CHILD_NODE.hasLocalName(nodeName)) {
            LOGGER.warn(this.pluginName(metadata) + ": ignoring unknown field " + nodeName);
            return;
        }
        switch (XML_CHILD_NODE.byLocalName(nodeName)) {
            case NAME: {
                metadata.addName(value);
                break;
            }
            case CLASS: {
                metadata.setPluginClass(value);
                break;
            }
            case DEFAULT_CONTROL: {
                metadata.setDefaultControl(value);
            }
        }
    }

    private String pluginName(PluginMetadata metadata) {
        String name = metadata.hasPluginName() ? "Plugin " + metadata.getShortestName() : "Plugin";
        return name;
    }

    private static class EmptyNodeList
    implements NodeList {
        private EmptyNodeList() {
        }

        @Override
        public int getLength() {
            return 0;
        }

        @Override
        public Node item(int index) {
            return null;
        }
    }

    private static enum XML_CHILD_NODE {
        NAME("name"),
        CLASS("class"),
        DEFAULT_CONTROL("default-control");

        private static Map<String, XML_CHILD_NODE> LOCAL_NAME_STORE;
        private String _localName;

        private XML_CHILD_NODE(String localName) {
            this._localName = localName;
        }

        public String getLocalName() {
            return this._localName;
        }

        static boolean hasLocalName(String localName) {
            return LOCAL_NAME_STORE.containsKey(localName);
        }

        static XML_CHILD_NODE byLocalName(String localName) {
            return LOCAL_NAME_STORE.get(localName);
        }

        static {
            LOCAL_NAME_STORE = new HashMap<String, XML_CHILD_NODE>();
            for (XML_CHILD_NODE node : XML_CHILD_NODE.values()) {
                LOCAL_NAME_STORE.put(node.getLocalName(), node);
            }
        }
    }
}

