/*
 * Decompiled with CFR 0.152.
 */
package org.dcache.gplazma.loader;

import com.google.common.base.Preconditions;
import java.util.Properties;
import org.dcache.gplazma.loader.PluginLoader;
import org.dcache.gplazma.loader.PluginLoadingException;
import org.dcache.gplazma.plugins.GPlazmaPlugin;

public class SafePluginLoaderDecorator
implements PluginLoader {
    private boolean _haveInitialised;
    private final PluginLoader _inner;

    public SafePluginLoaderDecorator(PluginLoader inner) {
        this._inner = inner;
    }

    @Override
    public void init() {
        Preconditions.checkState((!this._haveInitialised ? 1 : 0) != 0, (Object)"Cannot call init twice");
        this._inner.init();
        this._haveInitialised = true;
    }

    @Override
    public GPlazmaPlugin newPluginByName(String name) throws PluginLoadingException {
        Preconditions.checkState((boolean)this._haveInitialised, (Object)"PluginLoader has not been initialised");
        return this._inner.newPluginByName(name);
    }

    @Override
    public GPlazmaPlugin newPluginByName(String name, Properties properties) throws PluginLoadingException {
        Preconditions.checkState((boolean)this._haveInitialised, (Object)"PluginLoader has not been initialised");
        return this._inner.newPluginByName(name, properties);
    }
}

