/*
 * Decompiled with CFR 0.152.
 */
package org.dcache.gplazma.loader;

import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.Map;
import java.util.Properties;
import org.dcache.gplazma.loader.PluginFactory;
import org.dcache.gplazma.loader.PluginLoadingException;
import org.dcache.gplazma.plugins.GPlazmaPlugin;

public class PropertiesPluginFactory
implements PluginFactory {
    private static final Properties EMPTY_ARGUMENTS = new Properties();

    @Override
    public <T extends GPlazmaPlugin> T newPlugin(Class<T> pluginClass) throws PluginLoadingException {
        return this.newPlugin(pluginClass, EMPTY_ARGUMENTS);
    }

    @Override
    public <T extends GPlazmaPlugin> T newPlugin(Class<T> pluginClass, Properties properties) throws PluginLoadingException {
        Constructor<T> constructor = this.tryToGetConstructor(pluginClass);
        T plugin = this.tryToCreatePlugin(constructor, properties);
        return plugin;
    }

    private <T extends GPlazmaPlugin> Constructor<T> tryToGetConstructor(Class<T> pluginClass) throws PluginLoadingException {
        Constructor<T> constructor;
        try {
            constructor = pluginClass.getConstructor(Properties.class);
        }
        catch (SecurityException e) {
            throw new PluginLoadingException("not authorised", e);
        }
        catch (NoSuchMethodException e) {
            throw new PluginLoadingException("constructor missing", e);
        }
        return constructor;
    }

    private <T extends GPlazmaPlugin> T tryToCreatePlugin(Constructor<T> constructor, Properties properties) throws PluginLoadingException {
        GPlazmaPlugin plugin;
        Properties constructorProperties = new Properties();
        if (properties != null) {
            for (Map.Entry<Object, Object> kv : properties.entrySet()) {
                constructorProperties.put(kv.getKey(), kv.getValue());
            }
        }
        try {
            plugin = (GPlazmaPlugin)constructor.newInstance(properties);
        }
        catch (IllegalArgumentException e) {
            throw new PluginLoadingException("missing correct constructor", e);
        }
        catch (InstantiationException e) {
            throw new PluginLoadingException("type cannot be instantiated", e);
        }
        catch (IllegalAccessException e) {
            throw new PluginLoadingException("unauthorised", e);
        }
        catch (InvocationTargetException e) {
            Throwable cause = e.getCause();
            throw new PluginLoadingException(cause.getMessage(), cause);
        }
        return (T)plugin;
    }
}

