/*
 * Decompiled with CFR 0.152.
 */
package org.dcache.gplazma.loader;

import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.dcache.gplazma.plugins.GPlazmaPlugin;

public class PluginMetadata {
    private final Set<String> _names = new HashSet<String>();
    private Class<? extends GPlazmaPlugin> _class;
    private String _defaultControl;

    void addName(String name) {
        this.validPluginNameGuard(name);
        this._names.add(name);
    }

    void validPluginNameGuard(String name) {
        if (name == null || name.trim().isEmpty()) {
            throw new IllegalArgumentException("Plugin name cannot be null or empty.");
        }
    }

    public void setPluginClass(String className) {
        this.validClassNameGuard(className);
        Class<?> arbClass = this.tryToGetClassForName(className);
        Class<? extends GPlazmaPlugin> pluginClass = this.tryToCastClass(arbClass);
        this.setPluginClass(pluginClass);
    }

    private void validClassNameGuard(String name) {
        if (name == null) {
            throw new IllegalArgumentException("Plugin class name cannot be null");
        }
        if (this.hasPluginClass()) {
            throw new IllegalArgumentException("Plugin class cannot be specified twice");
        }
    }

    public boolean hasPluginClass() {
        return this._class != null;
    }

    private Class<?> tryToGetClassForName(String className) {
        Class<?> arbitraryClass;
        try {
            arbitraryClass = Class.forName(className);
        }
        catch (ClassNotFoundException e) {
            throw new IllegalArgumentException("Class " + className + " could not be found.", e);
        }
        return arbitraryClass;
    }

    private Class<? extends GPlazmaPlugin> tryToCastClass(Class<?> arbClass) {
        Class<GPlazmaPlugin> pluginClass;
        try {
            pluginClass = arbClass.asSubclass(GPlazmaPlugin.class);
        }
        catch (ClassCastException e) {
            throw new IllegalArgumentException("Named plugin class is not a GPlazmaPlugin class", e);
        }
        return pluginClass;
    }

    public void setPluginClass(Class<? extends GPlazmaPlugin> pluginClass) {
        this._class = pluginClass;
        this.addName(pluginClass.getName());
    }

    void setDefaultControl(String defaultControl) {
        this._defaultControl = defaultControl;
    }

    public Set<String> getPluginNames() {
        return Collections.unmodifiableSet(this._names);
    }

    public String getShortestName() {
        String shortestName = null;
        for (String name : this._names) {
            if (shortestName != null && name.length() >= shortestName.length()) continue;
            shortestName = name;
        }
        return shortestName;
    }

    public Class<? extends GPlazmaPlugin> getPluginClass() {
        return this._class;
    }

    public String getDefaultControl() {
        return this._defaultControl;
    }

    public boolean isValid() {
        return this.hasPluginName() && this.hasPluginClass();
    }

    public boolean hasPluginName() {
        return !this._names.isEmpty();
    }
}

