/*
 * Decompiled with CFR 0.152.
 */
package org.dcache.gplazma.configuration;

import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import java.util.Properties;
import org.dcache.gplazma.configuration.ConfigurationItemControl;
import org.dcache.gplazma.configuration.ConfigurationItemType;

public class ConfigurationItem {
    private final ConfigurationItemType type;
    private final ConfigurationItemControl control;
    private final String pluginName;
    private final Properties pluginProperties;

    public ConfigurationItem(ConfigurationItemType type, ConfigurationItemControl control, String pluginName, Properties pluginProperties) {
        this.type = (ConfigurationItemType)((Object)Preconditions.checkNotNull((Object)((Object)type), (Object)"type is null"));
        this.control = (ConfigurationItemControl)((Object)Preconditions.checkNotNull((Object)((Object)control), (Object)"control is null"));
        this.pluginName = (String)Preconditions.checkNotNull((Object)pluginName, (Object)"pluginName is null");
        this.pluginProperties = (Properties)Preconditions.checkNotNull((Object)pluginProperties, (Object)"pluginProperties is null");
    }

    public ConfigurationItemType getType() {
        return this.type;
    }

    public ConfigurationItemControl getControl() {
        return this.control;
    }

    public String getPluginName() {
        return this.pluginName;
    }

    public Properties getPluginConfiguration() {
        return this.pluginProperties;
    }

    public boolean equals(Object anObject) {
        if (!(anObject instanceof ConfigurationItem)) {
            return false;
        }
        ConfigurationItem anItem = (ConfigurationItem)anObject;
        if (!(this.type.equals((Object)anItem.type) && this.control.equals((Object)anItem.control) && this.pluginName.equals(anItem.pluginName))) {
            return false;
        }
        return Objects.equal((Object)this.pluginProperties, (Object)anItem.pluginProperties);
    }

    public int hashCode() {
        int hash = 7;
        hash = 83 * hash + this.type.hashCode();
        hash = 83 * hash + this.control.hashCode();
        hash = 83 * hash + this.pluginName.hashCode();
        hash = 83 * hash + this.pluginProperties.hashCode();
        return hash;
    }

    public String toString() {
        return (Object)((Object)this.type) + " " + (Object)((Object)this.control) + " " + this.pluginName + " " + this.pluginProperties;
    }
}

