/*
 * Decompiled with CFR 0.152.
 */
package org.pcells.services.connection;

import dmg.protocols.ssh.SshAuthMethod;
import dmg.protocols.ssh.SshAuthPassword;
import dmg.protocols.ssh.SshAuthRsa;
import dmg.protocols.ssh.SshClientAuthentication;
import dmg.protocols.ssh.SshRsaKey;
import dmg.protocols.ssh.SshSharedKey;
import dmg.protocols.ssh.SshStreamEngine;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.net.InetAddress;
import java.net.Socket;
import org.pcells.services.connection.DomainConnection;
import org.pcells.services.connection.DomainConnectionAdapter;
import org.pcells.services.connection.DomainConnectionListener;
import org.pcells.services.connection.DomainEventListener;

public class Ssh1DomainConnection
extends DomainConnectionAdapter
implements SshClientAuthentication {
    private String _hostname = null;
    private int _portnumber = 0;
    private Socket _socket = null;
    public SshAuthRsa _rsaAuth = null;
    public String _password = null;
    public String _loginName = "Unknown";
    private int _requestCounter = 0;

    public Ssh1DomainConnection(String hostname, int portnumber) {
        this._hostname = hostname;
        this._portnumber = portnumber;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void go() throws Exception {
        this._socket = new Socket(this._hostname, this._portnumber);
        SshStreamEngine engine = new SshStreamEngine(this._socket, this);
        this.setIoStreams(engine.getInputStream(), engine.getOutputStream(), engine.getReader(), engine.getWriter());
        try {
            super.go();
        }
        finally {
            try {
                this._socket.close();
            }
            catch (Exception exception) {}
        }
    }

    public void setLoginName(String name) {
        this._loginName = name;
    }

    public void setPassword(String password) {
        this._password = password;
    }

    public void setIdentityFile(File identityFile) throws Exception {
        FileInputStream in = new FileInputStream(identityFile);
        SshRsaKey key = new SshRsaKey(in);
        try {
            ((InputStream)in).close();
        }
        catch (Exception ee) {
            // empty catch block
        }
        this._rsaAuth = new SshAuthRsa(key);
    }

    @Override
    public boolean isHostKey(InetAddress host, SshRsaKey keyModulus) {
        return true;
    }

    @Override
    public String getUser() {
        this._requestCounter = 0;
        return this._loginName;
    }

    @Override
    public SshSharedKey getSharedKey(InetAddress host) {
        return null;
    }

    @Override
    public SshAuthMethod getAuthMethod() {
        SshAuthMethod result = null;
        result = this._requestCounter++ == 0 ? (this._rsaAuth == null ? new SshAuthPassword(this._password) : this._rsaAuth) : (this._requestCounter++ <= 2 ? new SshAuthPassword(this._password) : null);
        return result;
    }

    public static void main(String[] args) throws Exception {
        if (args.length < 2) {
            System.err.println("Usage : <hostname> <portNumber>");
            System.exit(4);
        }
        String hostname = args[0];
        int portnumber = Integer.parseInt(args[1]);
        System.out.println("Creating new Raw...");
        Ssh1DomainConnection connection = new Ssh1DomainConnection(hostname, portnumber);
        System.out.println("Starting Test");
        connection.test();
    }

    public void test() throws Exception {
        System.out.println("Starting test");
        new RunConnection();
    }

    private class RunConnection
    implements Runnable,
    DomainConnectionListener,
    DomainEventListener {
        public RunConnection() throws Exception {
            System.out.println("class runConnection init");
            Ssh1DomainConnection.this.addDomainEventListener(this);
            Ssh1DomainConnection.this.setLoginName("admin");
            Ssh1DomainConnection.this.setIdentityFile(new File(System.getProperty("user.home") + "/.ssh/identity"));
            Ssh1DomainConnection.this.setPassword("dickerelch");
            new Thread(this).start();
        }

        @Override
        public void run() {
            try {
                Ssh1DomainConnection.this.go();
            }
            catch (Exception ee) {
                System.out.println("RunConnection got : " + ee);
                ee.printStackTrace();
            }
        }

        @Override
        public void domainAnswerArrived(Object obj, int id) {
            System.out.println("Answer : " + obj);
            if (id == 54) {
                try {
                    Ssh1DomainConnection.this.sendObject("logoff", this, 55);
                }
                catch (Exception ee) {
                    System.out.println("Exception in sendObject" + ee);
                }
            }
        }

        @Override
        public void connectionOpened(DomainConnection connection) {
            System.out.println("DomainConnection : connectionOpened");
            try {
                Ssh1DomainConnection.this.sendObject("System", "ps -f", this, 54);
            }
            catch (Exception ee) {
                System.out.println("Exception in sendObject" + ee);
            }
        }

        @Override
        public void connectionClosed(DomainConnection connection) {
            System.out.println("DomainConnection : connectionClosed");
        }

        @Override
        public void connectionOutOfBand(DomainConnection connection, Object subject) {
            System.out.println("DomainConnection : connectionOutOfBand");
        }
    }
}

