/*
 * Decompiled with CFR 0.152.
 */
package dmg.util.graphics;

import dmg.util.graphics.TreeCanvas;
import dmg.util.graphics.TreeNodeable;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.LayoutManager;
import java.awt.Panel;
import java.awt.Point;
import java.awt.Scrollbar;
import java.awt.event.AdjustmentEvent;
import java.awt.event.AdjustmentListener;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;

public class TreeNodePanel
extends Panel
implements ComponentListener,
AdjustmentListener {
    private Scrollbar _right = null;
    private Scrollbar _bottom = null;
    private TreeCanvas _tree = null;

    public TreeNodePanel() {
        this.setLayout(new ScrollLayout());
        this._right = new Scrollbar(1, 0, 50, 0, 101);
        this._bottom = new Scrollbar(0, 0, 50, 0, 101);
        this._tree = new TreeCanvas();
        this.add(this._bottom);
        this.add(this._right);
        this.add(this._tree);
        this._tree.addComponentListener(this);
        this._bottom.addAdjustmentListener(this);
        this._right.addAdjustmentListener(this);
        this._tree.setOffset(new Point(20, 20));
    }

    @Override
    public void adjustmentValueChanged(AdjustmentEvent event) {
        System.out.println("Adjustment event : " + event);
        if (event.getSource() == this._right) {
            this._tree.setLocation(new Point(10, -event.getValue()));
        }
    }

    @Override
    public void componentMoved(ComponentEvent event) {
        System.out.println("ComponentEvent : " + event);
    }

    @Override
    public void componentHidden(ComponentEvent event) {
        System.out.println("ComponentEvent : " + event);
    }

    @Override
    public void componentShown(ComponentEvent event) {
        System.out.println("ComponentEvent : " + event);
    }

    @Override
    public void componentResized(ComponentEvent event) {
        System.out.println("ComponentEvent : " + event);
        Component c = event.getComponent();
        Dimension ourDim = this.getSize();
        Dimension botDim = this._bottom.getSize();
        Dimension rigDim = this._right.getSize();
        Dimension viewPort = new Dimension(ourDim.width - rigDim.width, ourDim.height - botDim.height);
        Dimension dim = c.getSize();
        int vis = ourDim.height;
        this._right.setVisibleAmount(vis);
        this._right.setMaximum(dim.height - vis);
        System.out.println(" dim : " + vis + "  " + dim.width);
    }

    public void setTree(TreeNodeable node) {
        this._tree.setTree(node);
    }

    @Override
    public Dimension getPreferredSize() {
        return new Dimension(300, 300);
    }

    @Override
    public Dimension getSize() {
        return this.getPreferredSize();
    }

    public class ScrollLayout
    implements LayoutManager {
        private int _scrollWidth = 10;

        @Override
        public void addLayoutComponent(String name, Component comp) {
        }

        @Override
        public void removeLayoutComponent(Component comp) {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Dimension preferredLayoutSize(Container target) {
            Object object = target.getTreeLock();
            synchronized (object) {
                int nmembers = target.getComponentCount();
                if (nmembers < 3) {
                    return target.getSize();
                }
                Dimension dim = target.getComponent(2).getSize();
                return new Dimension(dim.width + this._scrollWidth, dim.height + this._scrollWidth);
            }
        }

        @Override
        public Dimension minimumLayoutSize(Container target) {
            return this.preferredLayoutSize(target);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void layoutContainer(Container target) {
            Object object = target.getTreeLock();
            synchronized (object) {
                int nmembers = target.getComponentCount();
                if (nmembers < 3) {
                    return;
                }
                Dimension dim = target.getSize();
                Component c = target.getComponent(0);
                c.setLocation(0, dim.height - this._scrollWidth);
                c.setSize(dim.width - this._scrollWidth, this._scrollWidth);
                c = target.getComponent(1);
                c.setLocation(dim.width - this._scrollWidth, 0);
                c.setSize(this._scrollWidth, dim.height - this._scrollWidth);
                c = target.getComponent(2);
                c.setLocation(0, 0);
                c.setSize(dim.width - this._scrollWidth, dim.height - this._scrollWidth);
            }
        }
    }
}

