/*
 * Decompiled with CFR 0.152.
 */
package dmg.util.graphics;

import dmg.util.graphics.TreeNodeable;
import java.awt.Canvas;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.Enumeration;
import java.util.Vector;

public class TreeCanvas
extends Canvas
implements MouseListener {
    private TreeNodeable _tree = null;
    private TreeNodeable _currentTree = null;
    private Toolkit _toolkit = Toolkit.getDefaultToolkit();
    private Font _bigFont = new Font("SansSerif", 1, 10);
    private Font _font = this._bigFont;
    private FontMetrics _fontMetrics = this.getFontMetrics(this._font);
    private int _height = 0;
    private int _width = 0;
    private int _move = 0;
    private int _descent;
    private int _ascent = this._fontMetrics.getAscent();
    private Vector _recs = null;
    private int _b = 10;
    private Point _offset = null;

    public TreeCanvas() {
        this._descent = this._fontMetrics.getDescent();
        this._height = this._ascent + this._descent;
        this._width = this._fontMetrics.getMaxAdvance();
        this._move = (this._ascent - this._descent) / 2;
        this.addMouseListener(this);
    }

    private void _deselectAll() {
        TreeNodeable tree = this._tree;
        if (tree == null) {
            return;
        }
        this._deselect(tree);
    }

    private void _deselect(TreeNodeable tree) {
        TreeNodeable sub = null;
        if (tree == null) {
            return;
        }
        for (TreeNodeable c = tree; c != null; c = c.getNext()) {
            c.setSelected(false);
            if (c.isFolded() || (sub = c.getSub()) == null) continue;
            this._deselect(sub);
        }
    }

    @Override
    public void mouseClicked(MouseEvent event) {
        if (event.isControlDown()) {
            this._currentTree = this._tree;
            this._deselectAll();
            this.repaint();
            return;
        }
        Point p = event.getPoint();
        Enumeration e = this._recs.elements();
        while (e.hasMoreElements()) {
            RecFrame frame = (RecFrame)e.nextElement();
            if (!frame.rectangle.contains(p)) continue;
            if (frame.sw) {
                if (event.isShiftDown()) {
                    this._currentTree = frame.node;
                    break;
                }
                frame.node.switchFold();
                break;
            }
            if (!event.isShiftDown()) {
                this._deselectAll();
            }
            frame.node.setSelected(true);
            break;
        }
        this.repaint();
    }

    @Override
    public void mouseExited(MouseEvent event) {
    }

    @Override
    public void mouseReleased(MouseEvent event) {
    }

    @Override
    public void mousePressed(MouseEvent event) {
    }

    @Override
    public void mouseEntered(MouseEvent event) {
    }

    public void setTree(TreeNodeable node) {
        this._currentTree = this._tree = node;
        this.repaint();
    }

    public void setOffset(Point offset) {
        this._offset = offset;
        this.repaint();
    }

    @Override
    public void paint(Graphics g) {
        Dimension d = this.getSize();
        System.out.println(" new size : " + d);
        Color base = this.getBackground();
        g.setColor(Color.blue);
        g.setFont(this._font);
        if (this._currentTree != null) {
            this._recs = new Vector();
            Point p = null;
            p = this._offset == null ? new Point(10, 10) : this._offset;
            Dimension z = this.drawNode(g, p, this._currentTree);
            this.setSize(z.width + p.x, z.height + p.y);
        }
    }

    private Dimension drawNode(Graphics g, Point offIn, TreeNodeable node) {
        Point off = new Point(offIn);
        Rectangle rec = null;
        Dimension area = new Dimension(0, 0);
        Point m = null;
        while (node != null) {
            Point n = new Point(off);
            n.translate(0, 2 * this._height);
            g.drawLine(off.x, off.y, n.x, n.y);
            m = new Point(n);
            m.translate(1 * this._width, 0);
            g.drawLine(n.x, n.y, m.x, m.y);
            m.translate(this._width, 0);
            if (node.isSelected()) {
                Color x = g.getColor();
                g.setColor(Color.red);
                g.drawString(node.getName(), m.x, m.y + this._move);
                g.setColor(x);
            } else {
                g.drawString(node.getName(), m.x, m.y + this._move);
            }
            int nameLength = this._fontMetrics.stringWidth(node.getName());
            area.width = Math.max(area.width, nameLength + 2 * this._width);
            rec = new Rectangle(m.x, m.y + this._move - this._ascent, nameLength, this._height);
            this._recs.addElement(new RecFrame(rec, node));
            m.translate(this._width, this._height);
            Point k = new Point(n);
            if (node.isContainerNode()) {
                TreeNodeable sub;
                rec = new Rectangle(n.x - this._height / 4, n.y - this._height / 4, this._height / 2, this._height / 2);
                g.fillRect(rec.x, rec.y, rec.width, rec.height);
                this._recs.addElement(new RecFrame(rec, node, true));
                if (!node.isFolded() && (sub = node.getSub()) != null) {
                    Dimension z = this.drawNode(g, m, node.getSub());
                    k.translate(0, z.height + 2 * this._height);
                    area.width = Math.max(area.width, m.x + z.width);
                }
            }
            off = k;
            if ((node = node.getNext()) == null) continue;
            g.drawLine(n.x, n.y, k.x, k.y);
        }
        area.height = off.y - offIn.y + this._height;
        return area;
    }

    private class RecFrame {
        public Rectangle rectangle;
        public TreeNodeable node;
        public boolean sw = false;

        public RecFrame(Rectangle rec, TreeNodeable node) {
            this.rectangle = rec;
            this.node = node;
        }

        public RecFrame(Rectangle rec, TreeNodeable node, boolean sw) {
            this.rectangle = rec;
            this.node = node;
            this.sw = sw;
        }
    }
}

