/*
 * Decompiled with CFR 0.152.
 */
package dmg.util.edb;

import dmg.util.edb.JdbmAvElementList;
import dmg.util.edb.JdbmSerializable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;

public class JdbmFileHeader
implements JdbmSerializable {
    private static final int MAGIC = 324508367;
    int _magic = 324508367;
    int _blockSize = 0;
    int _elementsPerBucket = 0;
    long _nextUnallocatedAddress = 0L;
    long _directoryAddress = 0L;
    long[] _directory = null;
    int _directorySize = 0;
    int _directoryBits = 0;
    boolean _directoryChanged = false;
    long _avListAddress = 0L;
    JdbmAvElementList _avList = null;

    public JdbmFileHeader() {
    }

    public JdbmFileHeader(int blockSize) {
        this._blockSize = blockSize;
        this.initDirectory(this._blockSize);
    }

    private void initDirectory(int maxBytes) {
        int size;
        int bits = 1;
        for (size = 2; size < maxBytes; size *= 2) {
            ++bits;
        }
        if (size != maxBytes) {
            throw new IllegalArgumentException("block size not 2**n");
        }
        this._directorySize = size;
        this._directoryBits = bits;
        this._directoryChanged = true;
        this._directory = new long[this._directorySize];
    }

    public void expandDirectory() {
        this._directorySize *= 2;
        long[] newAddr = new long[this._directorySize];
        int n = 0;
        int i = 0;
        while (i < this._directorySize) {
            long l = this._directory[n];
            newAddr[i + 1] = l;
            newAddr[i] = l;
            i += 2;
            ++n;
        }
        ++this._directoryBits;
        this._directory = newAddr;
        this._directoryChanged = true;
    }

    public long[] getDirectory() {
        return this._directory;
    }

    public int getDirectorySize() {
        return this._directorySize * 8;
    }

    public long getDirectoryAddress() {
        return this._directoryAddress;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append("dir{b=").append(this._directoryBits).append(";e=").append(this._directorySize).append(";s=").append(this.getDirectorySize()).append("}");
        return sb.toString();
    }

    @Override
    public void writeObject(ObjectOutput out) throws IOException {
        out.writeInt(this._magic);
        out.writeInt(this._blockSize);
        out.writeInt(this._elementsPerBucket);
        out.writeLong(this._nextUnallocatedAddress);
        out.writeLong(this._directoryAddress);
        out.writeInt(this._directorySize);
        out.writeInt(this._directoryBits);
        out.writeLong(this._avListAddress);
        out.writeInt(this._magic);
    }

    @Override
    public void readObject(ObjectInput in) throws IOException, ClassNotFoundException {
        this._magic = in.readInt();
        if (this._magic != 324508367) {
            throw new IOException("Not a JDBM file");
        }
        this._blockSize = in.readInt();
        this._elementsPerBucket = in.readInt();
        this._nextUnallocatedAddress = in.readLong();
        this._directoryAddress = in.readLong();
        this._directorySize = in.readInt();
        this._directoryBits = in.readInt();
        this._avListAddress = in.readLong();
        this._magic = in.readInt();
        if (this._magic != 324508367) {
            throw new IOException("Not a JDBM file");
        }
    }

    @Override
    public int getPersistentSize() {
        return this._blockSize;
    }
}

