/*
 * Decompiled with CFR 0.152.
 */
package dmg.util.cdb;

import dmg.util.cdb.CdbElementable;
import dmg.util.cdb.CdbGLock;
import dmg.util.cdb.CdbLockException;
import dmg.util.cdb.CdbLockable;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;

public class CdbFileRecord
extends CdbGLock
implements CdbElementable {
    private CdbLockable _superLock = null;
    private File _dataSource = null;
    private Hashtable _table = new Hashtable();
    private boolean _exists = true;
    private boolean _dataValid = false;

    public CdbFileRecord(CdbLockable superLock, File source, boolean create) throws IOException {
        super(superLock);
        this._superLock = superLock;
        this._dataSource = source;
        if (create && this._dataSource.exists()) {
            throw new IllegalArgumentException("DataSource already exists(2)");
        }
        if (!create && !this._dataSource.exists()) {
            throw new IllegalArgumentException("DataSource not found");
        }
        if (create) {
            FileOutputStream out = new FileOutputStream(this._dataSource);
            out.close();
        }
    }

    @Override
    public synchronized void open(int mode) throws CdbLockException, InterruptedException {
        if (!this._exists) {
            throw new CdbLockException("Object removed");
        }
        super.open(mode);
    }

    public synchronized void addListItem(String attributeName, String itemName) {
        this.addListItem(attributeName, itemName, false);
    }

    public synchronized void addListItem(String attributeName, String itemName, boolean unique) {
        Object o = this._table.get(attributeName);
        String[] list = null;
        if (o == null) {
            list = new String[]{itemName};
            this._table.put(attributeName, list);
        } else {
            if (!(o instanceof Object[])) {
                throw new IllegalArgumentException("Not a list : " + attributeName);
            }
            list = (String[])o;
            String[] tmp = new String[list.length + 1];
            if (unique) {
                int i;
                for (i = 0; i < list.length && !list[i].equals(itemName); ++i) {
                    tmp[i] = list[i];
                }
                if (i < list.length) {
                    throw new IllegalArgumentException("duplicated entry");
                }
            } else {
                for (int i = 0; i < list.length; ++i) {
                    tmp[i] = list[i];
                }
            }
            tmp[list.length] = itemName;
            this._table.put(attributeName, tmp);
        }
    }

    public synchronized void removeListItem(String attributeName, String itemName) {
        int j;
        int i;
        Object o = this._table.get(attributeName);
        String[] list = null;
        if (o == null) {
            return;
        }
        if (!(o instanceof Object[])) {
            throw new IllegalArgumentException("Not a list : " + attributeName);
        }
        list = (String[])o;
        if (list.length == 0) {
            return;
        }
        for (i = 0; i < list.length && !list[i].equals(itemName); ++i) {
        }
        if (i == list.length) {
            return;
        }
        String[] tmp = new String[list.length - 1];
        int l = 0;
        for (j = 0; j < i; ++j) {
            tmp[l++] = list[j];
        }
        for (j = i + 1; j < list.length; ++j) {
            tmp[l++] = list[j];
        }
        list = tmp;
        this._table.put(attributeName, list);
    }

    public synchronized void setAttribute(String name, String attribute) {
        this._table.put(name, attribute);
    }

    public synchronized void setAttribute(String name, String[] attribute) {
        this._table.put(name, attribute);
    }

    public void setAttibute(String name, int value) {
        this._table.put(name, "" + value);
    }

    public synchronized Object getAttribute(String name) {
        return this._table.get(name);
    }

    public int getIntAttribute(String key) {
        String str = (String)this.getAttribute(key);
        if (str == null) {
            return 0;
        }
        try {
            return Integer.parseInt(str);
        }
        catch (NumberFormatException eee) {
            return 0;
        }
    }

    @Override
    public synchronized void remove() {
        this._exists = false;
        this._dataSource.delete();
    }

    public synchronized String[] getAttributeNames() {
        int size = this._table.size();
        String[] names = new String[size];
        Enumeration e = this._table.keys();
        for (int i = 0; i < size && e.hasMoreElements(); ++i) {
            names[i] = (String)e.nextElement();
        }
        return names;
    }

    public String toLine() {
        StringBuffer sb = new StringBuffer();
        Enumeration e = this._table.keys();
        int i = 0;
        while (e.hasMoreElements()) {
            String key = (String)e.nextElement();
            Object value = this._table.get(key);
            if (value instanceof String) {
                sb.append(key).append("=").append((String)value);
            } else if (value instanceof String[]) {
                sb.append(key).append("=");
                String[] values = (String[])value;
                for (int j = 0; j < values.length; ++j) {
                    if (j > 0) {
                        sb.append(",");
                    }
                    sb.append(values[j]);
                }
            }
            sb.append(";");
            ++i;
        }
        return sb.toString();
    }

    @Override
    public String toString() {
        StringBuffer sb = new StringBuffer();
        Enumeration e = this._table.keys();
        int i = 0;
        while (e.hasMoreElements()) {
            String key = (String)e.nextElement();
            Object value = this._table.get(key);
            if (value instanceof String) {
                sb.append(key).append("=").append((String)value).append("\n");
            } else if (value instanceof String[]) {
                sb.append(key).append("=List\n");
                String[] values = (String[])value;
                for (int j = 0; j < values.length; ++j) {
                    sb.append(values[j]).append("\n");
                }
            }
            ++i;
        }
        return sb.toString();
    }

    public synchronized Enumeration getAttributes() {
        return this._table.keys();
    }

    public synchronized void read() throws IOException {
        BufferedReader reader = new BufferedReader(new FileReader(this._dataSource));
        try {
            boolean state = false;
            String line = null;
            String name = null;
            String value = null;
            Vector<String> vec = null;
            while ((line = reader.readLine()) != null) {
                if (!state) {
                    int pos = line.indexOf(61);
                    if (pos < 0) continue;
                    name = line.substring(0, pos);
                    String string = value = pos == line.length() - 1 ? "" : line.substring(pos + 1);
                    if (value.equals("***LIST***")) {
                        state = true;
                        vec = new Vector<String>();
                        continue;
                    }
                    this._table.put(name, value);
                    continue;
                }
                if (!state) continue;
                if (line.equals("***LIST***")) {
                    Object[] a = new String[vec.size()];
                    vec.copyInto(a);
                    this._table.put(name, a);
                    state = false;
                    continue;
                }
                vec.addElement(line);
            }
        }
        catch (IOException e) {
            throw e;
        }
        finally {
            try {
                reader.close();
            }
            catch (Exception ee) {}
        }
    }

    public synchronized void write() throws IOException {
        PrintWriter pw = new PrintWriter(new FileWriter(this._dataSource));
        Enumeration e = this._table.keys();
        while (e.hasMoreElements()) {
            String name = (String)e.nextElement();
            Object o = this._table.get(name);
            if (o == null) continue;
            if (o instanceof String[]) {
                pw.println(name + "=***LIST***");
                String[] str = (String[])o;
                for (int i = 0; i < str.length; ++i) {
                    pw.println(str[i]);
                }
                pw.println("***LIST***");
                continue;
            }
            if (!(o instanceof String)) continue;
            pw.println(name + "=" + o);
        }
        pw.close();
    }

    @Override
    public void readLockGranted() {
        if (!this._dataValid) {
            try {
                this.read();
            }
            catch (Exception exception) {
                // empty catch block
            }
            this._dataValid = true;
        }
    }

    @Override
    public void writeLockGranted() {
        if (!this._dataValid) {
            try {
                this.read();
            }
            catch (Exception exception) {
                // empty catch block
            }
            this._dataValid = true;
        }
    }

    @Override
    public void readLockReleased() {
    }

    @Override
    public void writeLockReleased() {
        if (this._exists) {
            try {
                this.write();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    @Override
    public void writeLockAborted() {
        try {
            this.read();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static void main(String[] args) throws Exception {
        if (args.length < 2) {
            System.out.println("... read/write <filename>");
            System.exit(4);
        }
        if (args[0].equals("read")) {
            CdbFileRecord rec = new CdbFileRecord(null, new File(args[1]), false);
            for (int l = 0; l < 2; ++l) {
                long start = System.currentTimeMillis();
                rec.open(2);
                long opened = System.currentTimeMillis();
                Enumeration e = rec.getAttributes();
                while (e.hasMoreElements()) {
                    String name = (String)e.nextElement();
                    Object o = rec.getAttribute(name);
                    if (o != null && !(o instanceof String[]) && !(o instanceof String)) continue;
                }
                long fetched = System.currentTimeMillis();
                rec.close(8);
                long finished = System.currentTimeMillis();
                System.out.println("Open  : " + (opened - start));
                System.out.println("Read  : " + (fetched - opened));
                System.out.println("Close : " + (finished - fetched));
            }
        } else if (!args[0].equals("test") && args[0].equals("write")) {
            CdbFileRecord rec = new CdbFileRecord(null, new File(args[1]), true);
            rec.open(2);
            rec.setAttribute("storageGroup", "dst-98");
            String[] bfids = new String[2000];
            String str = null;
            StringBuffer sb = null;
            for (int i = 0; i < bfids.length; ++i) {
                sb = new StringBuffer();
                str = "" + i;
                sb.append("U");
                for (int j = 5; j >= str.length(); --j) {
                    sb.append('0');
                }
                sb.append(str);
                bfids[i] = sb.toString();
            }
            rec.setAttribute("bfids", bfids);
            rec.close(8);
        }
    }
}

