/*
 * Decompiled with CFR 0.152.
 */
package dmg.util;

import dmg.util.ClassDataProvider;
import java.io.DataInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;

class ClassLoaderA
extends ClassLoader {
    private File _dir = null;
    private ClassDataProvider _provider = null;

    ClassLoaderA(String dir) {
        this._dir = new File(dir);
        if (!this._dir.isDirectory()) {
            throw new IllegalArgumentException("Not a directory : " + this._dir);
        }
    }

    ClassLoaderA(File dir) {
        this._dir = dir;
        if (!this._dir.isDirectory()) {
            throw new IllegalArgumentException("Not a directory : " + this._dir);
        }
    }

    ClassLoaderA(ClassDataProvider dataProvider) {
        this._provider = dataProvider;
    }

    public static byte[] loadClassData(File dir, String name) {
        System.out.println("loadClassData : File=" + name);
        File file = new File(dir, name);
        try {
            long length = file.length();
            System.out.println("loadClassData : length=" + length);
            if (length == 0L) {
                return null;
            }
            byte[] data = new byte[(int)length];
            DataInputStream in = new DataInputStream(new FileInputStream(file));
            in.read(data);
            in.close();
            return data;
        }
        catch (Exception eee) {
            System.out.println("loadClassData : Exception : " + eee);
            return null;
        }
    }

    public synchronized Class loadClass(String name) {
        return this.loadClass(name, true);
    }

    public synchronized Class loadClass(String name, boolean resolve) {
        System.out.println("Loading class " + name);
        if (name.startsWith("java") || name.startsWith("dmg")) {
            try {
                return Class.forName(name);
            }
            catch (ClassNotFoundException cnf) {
                return null;
            }
        }
        byte[] data = null;
        if (this._dir != null) {
            data = ClassLoaderA.loadClassData(this._dir, name + ".class");
            if (data == null && (data = ClassLoaderA.loadClassData(this._dir, (name = name.replace('.', '/')) + ".class")) == null) {
                return null;
            }
        } else if (this._provider != null) {
            try {
                data = this._provider.getClassData(name);
            }
            catch (IOException ioe) {
                data = null;
            }
        } else {
            data = null;
        }
        if (data == null) {
            return null;
        }
        Class<?> entry = this.defineClass(name, data, 0, data.length);
        if (resolve) {
            this.resolveClass(entry);
        }
        return entry;
    }
}

