/*
 * Decompiled with CFR 0.152.
 */
package dmg.util;

public class BufferDescriptor {
    private byte[] _buffer;
    private int _mode;
    private int _usable;
    private int _size;
    private int _num;
    private int _usageCounter = 0;
    public static final int FILLED = 0;
    public static final int EMPTY = 1;
    public static final int FILLING = 2;
    public static final int DRAINING = 3;
    private static final String[] _modeStrings = new String[]{"Filled", "Empty", "Filling", "Draining"};

    BufferDescriptor(int size, int bufferNumber) {
        this._size = size;
        this._buffer = new byte[this._size];
        this._mode = 1;
        this._num = bufferNumber;
        this._usable = 0;
    }

    public void setFilled() {
        this._mode = 0;
    }

    public void setEmpty() {
        this._mode = 1;
    }

    public void setFilling() {
        this._mode = 2;
    }

    public void setDraining() {
        this._mode = 3;
    }

    void setMode(int mode) {
        this._mode = mode;
    }

    int getMode() {
        return this._mode;
    }

    public byte[] getBase() {
        return this._buffer;
    }

    public int getSize() {
        return this._size;
    }

    public int getUsable() {
        return this._usable;
    }

    public void setUsable(int usable) {
        ++this._usageCounter;
        this._usable = usable;
    }

    public String modeToString() {
        return _modeStrings[this._mode];
    }

    public String toString() {
        return "BufferDescriptor n=" + this._num + ";u=" + this._usageCounter + ";m=" + _modeStrings[this._mode];
    }
}

