/*
 * Decompiled with CFR 0.152.
 */
package dmg.security.cipher.rsa;

import java.io.BufferedInputStream;
import java.io.DataInputStream;
import java.io.EOFException;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.math.BigInteger;

public class ReadSecreteKey {
    public static final int PUBLIC_KEY_ENCRYPTED = 1;
    public static final int SECRET_KEY_ENCRYPTED = 2;
    public static final int SECRET_KEY_CERTIFICATE = 5;
    public static final int PUBLIC_KEY_CERTIFICATE = 6;
    DataInputStream _input;
    int _ctb;
    int _version;
    int _timestamp;
    int _validity;
    int _checkSum;
    int _secreteAlgorithm;
    int _publicAlgorithm;
    BigInteger _d;
    BigInteger _p;
    BigInteger _q;
    BigInteger _u;
    BigInteger _e;
    BigInteger _n;

    public ReadSecreteKey(String filename) throws FileNotFoundException, IOException {
        this._input = new DataInputStream(new BufferedInputStream(new FileInputStream(filename)));
        this._read();
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append(" Validity : " + this._validity + " Days\n");
        sb.append(" n = " + this._n.toString(16) + "\n");
        sb.append(" p = " + this._p.toString(16) + "\n");
        sb.append(" q = " + this._q.toString(16) + "\n");
        sb.append(" e = " + this._e.toString(16) + "\n");
        sb.append(" d = " + this._d.toString(16) + "\n");
        sb.append(" u = " + this._u.toString(16) + "\n");
        BigInteger p = this._e.multiply(this._d);
        sb.append(" (e*d)       = " + p.toString(16) + "\n");
        BigInteger pmodn = p.mod(p);
        sb.append(" (e*d) mod n = " + pmodn.toString(16) + "\n");
        return sb.toString();
    }

    private BigInteger readMPI() throws IOException {
        int len = this._input.readUnsignedShort();
        System.out.println(" trying to read " + len);
        len = len / 8 + (len % 8 != 0 ? 1 : 0);
        byte[] data = new byte[len];
        int rc = this._input.read(data);
        if (rc < len) {
            throw new IOException("Premature EOF encountered(2) " + rc + "<" + len);
        }
        try {
            return new BigInteger(1, data);
        }
        catch (NumberFormatException nfe) {
            throw new IOException("Not a BigInteger");
        }
    }

    private int _read() throws IOException {
        try {
            this._ctb = this._input.readUnsignedByte();
        }
        catch (EOFException x) {
            return 0;
        }
        if ((this._ctb & 0x80) == 0) {
            throw new IOException("NOT a Cipher Type Byte");
        }
        try {
            int type = this._ctb >>> 2 & 0xF;
            if (type != 5) {
                throw new IOException("NOT a SECRET_KEY_ENCRYPTED");
            }
            int lengthLength = this._ctb & 3;
            if (lengthLength == 0) {
                int length = this._input.readUnsignedByte();
            } else if (lengthLength == 1) {
                int length = this._input.readUnsignedShort();
            } else if (lengthLength == 2) {
                int length = this._input.readInt();
            } else {
                throw new IOException("can't lengthLength = " + lengthLength);
            }
            this._version = this._input.readUnsignedByte();
            this._timestamp = this._input.readInt();
            this._validity = this._input.readUnsignedShort();
            this._publicAlgorithm = this._input.readUnsignedByte();
            if (this._publicAlgorithm != 1) {
                throw new IOException("Can't read Non RSA " + this._publicAlgorithm);
            }
            this._n = this.readMPI();
            this._e = this.readMPI();
            this._secreteAlgorithm = this._input.readUnsignedByte();
            if (this._secreteAlgorithm != 0) {
                throw new IOException("Can't decrypt sa : " + this._secreteAlgorithm);
            }
            this._d = this.readMPI();
            this._p = this.readMPI();
            this._q = this.readMPI();
            this._u = this.readMPI();
            this._checkSum = this._input.readUnsignedShort();
        }
        catch (EOFException eof) {
            throw new IOException("Premature EOF encountered");
        }
        return 1;
    }

    public static void main(String[] args) {
        if (args.length < 1) {
            System.err.println(" USAGE : ... <secretKeyRing> ");
            System.exit(4);
        }
        try {
            ReadSecreteKey rsa = new ReadSecreteKey(args[0]);
            System.out.println(rsa);
        }
        catch (IOException e) {
            System.err.println(" Sorry : " + e);
        }
    }
}

